#!/bin/bash

set -eu

dir="${1:-"."}"

cd "${dir}"

engines="dot neato twopi circo fdp sfdp patchwork"
formats="svg"

for file in *.dot; do 
  echo "Generating images for source file ${file}"
  for engine in ${engines}; do
    for format in ${formats}; do
      ${engine} -T${format} -o "${file%.dot}_${engine}.${format}" "${file}" || true
    done
  done
done

