# encoding: utf-8
# license: gpl3p external

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

# This file includes an external library and makes it accessible from
# ruby. This library has it's own license, which is accessible via the
# LICENSE symlink in this directory. The corresponding directory in the
# license hierarchy may contain further information about the library or
# it's license.
#
# The license this file and the software using this file are under, does
# not apply to the external library.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST
module Jena
  module Query
    include_package "com.hp.hpl.jena.query"
  end
  module Sparql
    include_package "com.hp.hpl.jena.sparql"
    module Algebra
      include_package "com.hp.hpl.jena.sparql.algebra"
      module Op
        include_package "com.hp.hpl.jena.sparql.algebra.op"
      end
      module Optimize
        include_package "com.hp.hpl.jena.sparql.algebra.optimize"
      end
      module Table
        include_package "com.hp.hpl.jena.sparql.algebra.table"
      end
    end
    module Core
      include_package "com.hp.hpl.jena.sparql.core"
      module Assembler
        include_package "com.hp.hpl.jena.sparql.core.assembler"
      end
      module Describe
        include_package "com.hp.hpl.jena.sparql.core.describe"
      end
    end
    module Engine
      include_package "com.hp.hpl.jena.sparql.engine"
      module Binding
        include_package "com.hp.hpl.jena.sparql.engine.binding"
      end
      module Http
        include_package "com.hp.hpl.jena.sparql.engine.http"
      end
      module Iterator
        include_package "com.hp.hpl.jena.sparql.engine.iterator"
      end
      module Main
        include_package "com.hp.hpl.jena.sparql.engine.main"
        module Iterator
          include_package "com.hp.hpl.jena.sparql.engine.main.iterator"
        end
      end
      module Optimizer
        include_package "com.hp.hpl.jena.sparql.engine.optimizer"
        module Reorder
          include_package "com.hp.hpl.jena.sparql.engine.optimizer.reorder"
        end
      end
      module Ref
        include_package "com.hp.hpl.jena.sparql.engine.ref"
      end
    end
    module Expr
      include_package "com.hp.hpl.jena.sparql.expr"
      module Aggregate
        include_package "com.hp.hpl.jena.sparql.expr.aggregate"
      end
      module NodeValue
        include_package "com.hp.hpl.jena.sparql.expr.nodevalue"
      end
    end
    module Function
      include_package "com.hp.hpl.jena.sparql.function"
      module Library
        java_import('com.hp.hpl.jena.sparql.function.library.bnode'){ |pkg,name| 'BNode' }
        java_import('com.hp.hpl.jena.sparql.function.library.date'){ |pkg,name| 'Date' }
        java_import('com.hp.hpl.jena.sparql.function.library.e'){ |pkg,name| 'E' }
        java_import('com.hp.hpl.jena.sparql.function.library.eval'){ |pkg,name| 'Eval' }
        java_import('com.hp.hpl.jena.sparql.function.library.evenInteger'){ |pkg,name| 'EvenInteger' }
        java_import('com.hp.hpl.jena.sparql.function.library.langeq'){ |pkg,name| 'LangEq' }
        java_import('com.hp.hpl.jena.sparql.function.library.localname'){ |pkg,name| 'Localname' }
        java_import('com.hp.hpl.jena.sparql.function.library.max'){ |pkg,name| 'Max' }
        java_import('com.hp.hpl.jena.sparql.function.library.min'){ |pkg,name| 'Min' }
        java_import('com.hp.hpl.jena.sparql.function.library.namespace'){ |pkg,name| 'Namespace' }
        java_import('com.hp.hpl.jena.sparql.function.library.now'){ |pkg,name| 'Now' }
        java_import('com.hp.hpl.jena.sparql.function.library.pi'){ |pkg,name| 'Pi' }
        java_import('com.hp.hpl.jena.sparql.function.library.sha1sum'){ |pkg,name| 'Sha1Sum' }
        java_import('com.hp.hpl.jena.sparql.function.library.sqrt'){ |pkg,name| 'Sqrt' }
        java_import('com.hp.hpl.jena.sparql.function.library.strjoin'){ |pkg,name| 'StrJoin' }
        java_import('com.hp.hpl.jena.sparql.function.library.strlen'){ |pkg,name| 'StrLen' }
        java_import('com.hp.hpl.jena.sparql.function.library.struuid'){ |pkg,name| 'StrUuid' }
        java_import('com.hp.hpl.jena.sparql.function.library.substr'){ |pkg,name| 'SubStr' }
        java_import('com.hp.hpl.jena.sparql.function.library.substring'){ |pkg,name| 'Substring' }
        java_import('com.hp.hpl.jena.sparql.function.library.uuid'){ |pkg,name| 'Uuid' }
        java_import('com.hp.hpl.jena.sparql.function.library.wait'){ |pkg,name| 'Wait' }
        include_package "com.hp.hpl.jena.sparql.function.library"
      end
    end
    module Graph
      include_package "com.hp.hpl.jena.sparql.graph"
    end
    module Lang
      include_package "com.hp.hpl.jena.sparql.lang"
      module Arq
        include_package "com.hp.hpl.jena.sparql.lang.arq"
      end
      module Sparql10
        include_package "com.hp.hpl.jena.sparql.lang.sparql_10"
      end
      module Sparql11
        include_package "com.hp.hpl.jena.sparql.lang.sparql_11"
      end
    end
    module Lib
      include_package "com.hp.hpl.jena.sparql.lib"
    end
    module Mgt
      include_package "com.hp.hpl.jena.sparql.mgt"
    end
    module Modify
      include_package "com.hp.hpl.jena.sparql.modify"
      module Request
        include_package "com.hp.hpl.jena.sparql.modify.request"
      end
    end
    module Path
      include_package "com.hp.hpl.jena.sparql.path"
      module Eval
        include_package "com.hp.hpl.jena.sparql.path.eval"
      end
    end
    module PFunction
      include_package "com.hp.hpl.jena.sparql.pfunction"
      module Library
        java_import('com.hp.hpl.jena.sparql.pfunction.library.alt'){ |pkg,name| 'Alt' }
        java_import('com.hp.hpl.jena.sparql.pfunction.library.assign'){ |pkg,name| 'Assign' }
        java_import('com.hp.hpl.jena.sparql.pfunction.library.bag'){ |pkg,name| 'Bag' }
        java_import('com.hp.hpl.jena.sparql.pfunction.library.blankNode'){ |pkg,name| 'BlankNode' }
        java_import('com.hp.hpl.jena.sparql.pfunction.library.bnode'){ |pkg,name| 'BNode' }
        java_import('com.hp.hpl.jena.sparql.pfunction.library.concat'){ |pkg,name| 'Concat' }
        java_import('com.hp.hpl.jena.sparql.pfunction.library.container'){ |pkg,name| 'Container' }
        java_import('com.hp.hpl.jena.sparql.pfunction.library.listIndex'){ |pkg,name| 'ListIndex' }
        java_import('com.hp.hpl.jena.sparql.pfunction.library.listLength'){ |pkg,name| 'ListLength' }
        java_import('com.hp.hpl.jena.sparql.pfunction.library.listMember'){ |pkg,name| 'ListMember' }
        java_import('com.hp.hpl.jena.sparql.pfunction.library.seq'){ |pkg,name| 'Seq' }
        java_import('com.hp.hpl.jena.sparql.pfunction.library.splitIRI'){ |pkg,name| 'SplitIri' }
        java_import('com.hp.hpl.jena.sparql.pfunction.library.splitURI'){ |pkg,name| 'SplitUri' }
        java_import('com.hp.hpl.jena.sparql.pfunction.library.str'){ |pkg,name| 'Str' }
        java_import('com.hp.hpl.jena.sparql.pfunction.library.version'){ |pkg,name| 'Version' }
        java_import('com.hp.hpl.jena.sparql.pfunction.library.versionARQ'){ |pkg,name| 'VersionArq' }
        include_package "com.hp.hpl.jena.sparql.pfunction.library"
      end
    end
    module Procedure
      include_package "com.hp.hpl.jena.sparql.procedure"
      module Library
        java_import('com.hp.hpl.jena.sparql.procedure.library.debug'){ |pkg,name| 'Debug' }
        include_package "com.hp.hpl.jena.sparql.procedure.library"
      end
    end
    module ResultSet
      include_package "com.hp.hpl.jena.sparql.resultset"
    end
    module Serializer
      include_package "com.hp.hpl.jena.sparql.serializer"
    end
    module Sse
      include_package "com.hp.hpl.jena.sparql.sse"
      module Builders
        include_package "com.hp.hpl.jena.sparql.sse.builders"
      end
      module Lang
        include_package "com.hp.hpl.jena.sparql.sse.lang"
        module Parser
          include_package "com.hp.hpl.jena.sparql.sse.lang.parser"
        end
      end
      module Writers
        include_package "com.hp.hpl.jena.sparql.sse.writers"
      end
    end
    module Syntax
      include_package "com.hp.hpl.jena.sparql.syntax"
    end
    module Util
      include_package "com.hp.hpl.jena.sparql.util"
      module Graph
        include_package "com.hp.hpl.jena.sparql.util.graph"
      end
    end
    module Vocabulary
      include_package "com.hp.hpl.jena.sparql.vocabulary"
    end
  end
  module Update
    include_package "com.hp.hpl.jena.update"
  end
  module Atlas
    include_package "org.openjena.atlas"
    module Data
      include_package "org.openjena.atlas.data"
    end
    module Event
      include_package "org.openjena.atlas.event"
    end
    module Io
      include_package "org.openjena.atlas.io"
    end
    module Iterator
      include_package "org.openjena.atlas.iterator"
    end
    module Json
      include_package "org.openjena.atlas.json"
      module Io
        include_package "org.openjena.atlas.json.io"
        module Parser
          include_package "org.openjena.atlas.json.io.parser"
        end
        module ParserJavaCc
          include_package "org.openjena.atlas.json.io.parserjavacc"
          module JavaCc
            include_package "org.openjena.atlas.json.io.parserjavacc.javacc"
          end
        end
      end
    end
    module Lib
      include_package "org.openjena.atlas.lib"
      module Cache
        include_package "org.openjena.atlas.lib.cache"
      end
    end
    module Logging
      include_package "org.openjena.atlas.logging"
      module Java
        include_package "org.openjena.atlas.logging.java"
      end
    end
    module Test
      include_package "org.openjena.atlas.test"
    end
    module Web
      include_package "org.openjena.atlas.web"
    end
  end
  module Riot
    include_package "org.openjena.riot"
    module Checker
      include_package "org.openjena.riot.checker"
    end
    module Lang
      include_package "org.openjena.riot.lang"
    end
    module Out
      include_package "org.openjena.riot.out"
    end
    module Pipeline
      include_package "org.openjena.riot.pipeline"
      module Inf
        include_package "org.openjena.riot.pipeline.inf"
      end
      module Normalize
        include_package "org.openjena.riot.pipeline.normalize"
      end
    end
    module System
      include_package "org.openjena.riot.system"
    end
    module Tokens
      include_package "org.openjena.riot.tokens"
    end
    module Web
      include_package "org.openjena.riot.web"
    end
  end
end
