# encoding: utf-8
# license: gpl3p external

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

# This file includes an external library and makes it accessible from
# ruby. This library has it's own license, which is accessible via the
# LICENSE symlink in this directory. The corresponding directory in the
# license hierarchy may contain further information about the library or
# it's license.
#
# The license this file and the software using this file are under, does
# not apply to the external library.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST
module Jena
  java_import('jena.qtest'){ |pkg,name| 'QTest' }
  java_import('jena.query'){ |pkg,name| 'JenaQuery' }
  java_import('jena.rdfcat'){ |pkg,name| 'RdfCat' }
  java_import('jena.rdfcompare'){ |pkg,name| 'RdfCompare' }
  java_import('jena.rdfparse'){ |pkg,name| 'RdfParse' }
  java_import('jena.rset'){ |pkg,name| 'RSet' }
  java_import('jena.schemagen'){ |pkg,name| 'SchemaGen' }
  java_import('jena.sparql'){ |pkg,name| 'JenaSparql' }
  java_import('jena.turtle'){ |pkg,name| 'Turtle' }
  java_import('jena.version'){ |pkg,name| 'Version' }

  include_package 'com.hp.hpl.jena'
  include_package 'jena'

  module Assembler
    include_package 'com.hp.hpl.jena.assembler'
  end

  module DataTypes
    include_package 'com.hp.hpl.jena.datatypes'
    module Xsd
      include_package 'com.hp.hpl.jena.datatypes.xsd'
    end
  end

  module Enhanced
    include_package 'com.hp.hpl.jena.enhanced'
  end

  module Graph
    include_package 'com.hp.hpl.jena.graph'
    module Compose
      include_package 'com.hp.hpl.jena.graph.compose'
    end
    module Query
      include_package 'com.hp.hpl.jena.graph.query'
    end
  end

  module Ontology
    include_package 'com.hp.hpl.jena.ontology'
  end

  module Rdf
    include_package 'com.hp.hpl.jena.rdf'
    module Arp
      include_package 'com.hp.hpl.jena.rdf.arp'
    end
    module Listeners
      include_package 'com.hp.hpl.jena.rdf.listeners'
    end
    module Model
      include_package 'com.hp.hpl.jena.rdf.model'
    end
  end

  module Reasoner
    include_package 'com.hp.hpl.jena.reasoner'
    module RuleSys
      include_package 'com.hp.hpl.jena.reasoner.rulesys'
      module Builtins
        include_package 'com.hp.hpl.jena.reasoner.rulesys.builtins'
      end
    end
    module TransitiveReasoner
      include_package 'com.hp.hpl.jena.reasoner.transitiveReasoner'
    end
  end

  module Shared
    include_package 'com.hp.hpl.jena.shared'
  end

  module Util
    include_package 'com.hp.hpl.jena.util'
  end

  module Vocabulary
    include_package 'com.hp.hpl.jena.vocabulary'
  end

  module XmlOutput
    include_package 'com.hp.hpl.jena.xmloutput'
  end
end


