# encoding: utf-8
# license: gpl3p external

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

# This file includes an external library and makes it accessible from
# ruby. This library has it's own license, which is accessible via the
# LICENSE symlink in this directory. The corresponding directory in the
# license hierarchy may contain further information about the library or
# it's license.
#
# The license this file and the software using this file are under, does
# not apply to the external library.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST
module Jena
  module Sdb
    include_package 'com.hp.hpl.jena.sdb'
    include_package 'sdb'


    module Assember
      include_package 'com.hp.hpl.jena.sdb.assembler'
    end

    module Compiler
      module Rewrite
        include_package 'com.hp.hpl.jena.sdb.compiler.rewrite'
      end
      include_package 'com.hp.hpl.jena.sdb.compiler'
    end

    module Core
      module SqlExpr
        include_package 'com.hp.hpl.jena.sdb.core.sqlexpr'
      end
      module SqlNode
        include_package 'com.hp.hpl.jena.sdb.core.sqlnode'
      end
      include_package 'com.hp.hpl.jena.sdb.core'
    end

    module Engine
      include_package 'com.hp.hpl.jena.sdb.engine'
    end

    module ExprMatch
      include_package 'com.hp.hpl.jena.sdb.exprmatch'
    end

    module Graph
      include_package 'com.hp.hpl.jena.sdb.graph'
    end

    module Layout1
      include_package 'com.hp.hpl.jena.sdb.layout1'
    end

    module Layout2
      module Expr
        include_package 'com.hp.hpl.jena.sdb.layout2.expr'
      end
      module Hash
        include_package 'com.hp.hpl.jena.sdb.layout2.hash'
      end
      module Index
        include_package 'com.hp.hpl.jena.sdb.layout2.index'
      end
      include_package 'com.hp.hpl.jena.sdb.layout2'
    end

    module Modify
      include_package 'com.hp.hpl.jena.sdb.modify'
    end

    module Print
      include_package 'com.hp.hpl.jena.sdb.print'
    end

    module Script
      include_package 'com.hp.hpl.jena.sdb.script'
    end

    module Shared
      include_package 'com.hp.hpl.jena.sdb.shared'
    end

    module Sql
      include_package 'com.hp.hpl.jena.sdb.sql'
    end

    module Store
      include_package 'com.hp.hpl.jena.sdb.store'
    end

    module Util
      include_package 'com.hp.hpl.jena.sdb.util'
    end

    module Cmd
      include_package 'sdb.cmd'
    end
  end
end

