# encoding: utf-8
# license: gpl3p external

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

# This file includes an external library and makes it accessible from
# ruby. This library has it's own license, which is accessible via the
# LICENSE symlink in this directory. The corresponding directory in the
# license hierarchy may contain further information about the library or
# it's license.
#
# The license this file and the software using this file are under, does
# not apply to the external library.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST
module Pellet
  include_package "com.clarkparsia.pellet"
  include_package "org.mindswap.pellet"
  include_package "pellet"
  module Modularity
    include_package "com.clarkparsia.modularity"
    module Io
      include_package "com.clarkparsia.modularity.io"
    end
  end
  module Owlapi
    include_package "com.clarkparsia.owlapi"
  end
  module Owlapiv3
    include_package "com.clarkparsia.owlapiv3"
  end
  module Datatypes
    include_package "com.clarkparsia.pellet.datatypes"
    include_package "org.mindswap.pellet.datatypes"
    module Exceptions
      include_package "com.clarkparsia.pellet.datatypes.exceptions"
    end
    module Types
      module Bool
        include_package "com.clarkparsia.pellet.datatypes.types.bool"
      end
      module Datetime
        include_package "com.clarkparsia.pellet.datatypes.types.datetime"
      end
      module Duration
        include_package "com.clarkparsia.pellet.datatypes.types.duration"
      end
      module Floating
        include_package "com.clarkparsia.pellet.datatypes.types.floating"
      end
      module Real
        include_package "com.clarkparsia.pellet.datatypes.types.real"
      end
      module Text
        include_package "com.clarkparsia.pellet.datatypes.types.text"
      end
      module Uri
        include_package "com.clarkparsia.pellet.datatypes.types.uri"
      end
    end
  end
  module El
    include_package "com.clarkparsia.pellet.el"
  end
  module Expressivity
    include_package "com.clarkparsia.pellet.expressivity"
  end
  module Impl
    include_package "com.clarkparsia.pellet.impl"
  end
  module Owlapiv3
    include_package "com.clarkparsia.pellet.owlapiv3"
  end
  module Rules
    include_package "com.clarkparsia.pellet.rules"
    module Builtins
      include_package "com.clarkparsia.pellet.rules.builtins"
    end
    module Model
      include_package "com.clarkparsia.pellet.rules.model"
    end
    module Rete
      include_package "com.clarkparsia.pellet.rules.rete"
    end
  end
  module Sparqldl
    module Engine
      include_package "com.clarkparsia.pellet.sparqldl.engine"
    end
    module Jena
      include_package "com.clarkparsia.pellet.sparqldl.jena"
    end
    module Model
      include_package "com.clarkparsia.pellet.sparqldl.model"
    end
    module Parser
      include_package "com.clarkparsia.pellet.sparqldl.parser"
    end
  end
  module Utils
    include_package "com.clarkparsia.pellet.utils"
    include_package "org.mindswap.pellet.utils"
    module Fsm
      include_package "org.mindswap.pellet.utils.fsm"
    end
    module Intset
      include_package "org.mindswap.pellet.utils.intset"
    end
    module Iterator
      include_package "org.mindswap.pellet.utils.iterator"
    end
    module Progress
      include_package "org.mindswap.pellet.utils.progress"
    end
  end
  module Vocabulary
    include_package "com.clarkparsia.pellet.vocabulary"
  end
  module Dig
    include_package "org.mindswap.pellet.dig"
  end
  module Exceptions
    include_package "org.mindswap.pellet.exceptions"
  end
  module Jena
    include_package "org.mindswap.pellet.jena"
    module Graph
      module Converter
        include_package "org.mindswap.pellet.jena.graph.converter"
      end
      module Loader
        include_package "org.mindswap.pellet.jena.graph.loader"
      end
      module Query
        include_package "org.mindswap.pellet.jena.graph.query"
      end
    end
    module Vocabulary
      include_package "org.mindswap.pellet.jena.vocabulary"
    end
  end
  module Output
    include_package "org.mindswap.pellet.output"
  end
  module Owlapi
    include_package "org.mindswap.pellet.owlapi"
  end
  module Tableau
    module Blocking
      include_package "org.mindswap.pellet.tableau.blocking"
    end
    module Branch
      include_package "org.mindswap.pellet.tableau.branch"
    end
    module Cache
      include_package "org.mindswap.pellet.tableau.cache"
    end
    module Completion
      include_package "org.mindswap.pellet.tableau.completion"
      module Incremental
        include_package "org.mindswap.pellet.tableau.completion.incremental"
      end
      module Queue
        include_package "org.mindswap.pellet.tableau.completion.queue"
      end
      module Rule
        include_package "org.mindswap.pellet.tableau.completion.rule"
      end
    end
  end
  module Taxonomy
    include_package "org.mindswap.pellet.taxonomy"
    module Printer
      include_package "org.mindswap.pellet.taxonomy.printer"
    end
  end
  module Tbox
    include_package "org.mindswap.pellet.tbox"
    module Impl
      include_package "org.mindswap.pellet.tbox.impl"
    end
  end
  module Pellint
    module Format
      include_package "com.clarkparsia.pellint.format"
    end
    module Lintpattern
      include_package "com.clarkparsia.pellint.lintpattern"
      module Axiom
        include_package "com.clarkparsia.pellint.lintpattern.axiom"
      end
      module Ontology
        include_package "com.clarkparsia.pellint.lintpattern.ontology"
      end
    end
    module Model
      include_package "com.clarkparsia.pellint.model"
    end
    module Rdfxml
      include_package "com.clarkparsia.pellint.rdfxml"
    end
    module Util
      include_package "com.clarkparsia.pellint.util"
    end
  end
  module Sparqlowl
    module Parser
      include_package "com.clarkparsia.sparqlowl.parser"
      module Arq
        include_package "com.clarkparsia.sparqlowl.parser.arq"
      end
    end
  end
end
