# encoding: utf-8
# license: gpl3p

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST
module Iof
  module Data
    class Mapper < Ghun::Base::Module
      @mapper_mutex=Mutex.new()
      class << self
        def instance
          #TODO support mapping from multiple ontologies
          #TODO support storing to multiple ontologies
          @mapper_mutex.synchronize {
            if Ghun::Base::Blackboard.mapper.nil?()
              ontology=Ghun::Base::Blackboard.ontology.init_ontology(:mapper)
              Ghun::Base::Blackboard.mapper=Iof::Data::Mapper.new(ontology)
            end
            return Ghun::Base::Blackboard.mapper
          }
        end
      end

      def initialize(ontology)
        super(Ghun::Log::Source::ONTOLOGY)
        register
        @ontology=ontology
        load_namespaces()
        create_all_hierarchies()
        remove_instance_variable(:@ontology)
        Ghun::Base::Blackboard.ontology.destroy_ontology(:mapper)
      end

      #def reload_configuration
      #  load_namespaces()
      #end

    private
      def load_namespaces()
        @ontology.prefixes.each do |prefix,url|
          Iof::Data.add_namespace(prefix.to_s, url)
        end
      end

      def load_class_options(new,result)
        #load options from ontology
        result.each do |line|
          next if !line.include?(:p) || !line.include?(:v) || line[:p]=="iofMetaData"
          case line[:p]
          when "isTopLevelObject"
            new.options[:top_level_object]=(line[:v].downcase=="true")
          when "isReasoningResult"
            new.options[:reasoning_result]=(line[:v].downcase=="true")
          when "namingPolicy"
            new.options[:naming_policy]=line[:v].downcase.intern
          when "disableMapping"
            new.options[:disable_mapping]=(line[:v].downcase=="true")
          when "forceDisableMapping"
            new.options[:force_disable_mapping]=(line[:v].downcase=="true")
          else
            warn "Unknown iofMetaData property '#{line[:p]}' with value '#{line[:v]}' for class '#{new.ns}:#{new.ontology_name}'"
          end
        end unless result.nil?()

        #load inherited options from superclass
        s_opts=new.direct_super.options
        if s_opts.include?(:top_level_object) && !new.options.include?(:top_level_object) then
          debug "Loading 'isTopLevelObject' from superclass '#{new.direct_super.to_s}'"
          new.options[:top_level_object]=s_opts[:top_level_object]
        end
        if s_opts.include?(:naming_policy) && !new.options.include?(:naming_policy) then
          debug "Loading 'namingPolicy' from superclass '#{new.direct_super.to_s}'"
          new.options[:naming_policy]=s_opts[:naming_policy]
        end

        #using default values
        new.options[:top_level_object]=false unless new.options.include?(:top_level_object)
        new.options[:reasoning_result]=false unless new.options.include?(:reasoning_result)
        new.options[:naming_policy]=:unique unless new.options.include?(:naming_policy)
        new.options[:disable_mapping]=false unless new.options.include?(:disable_mapping)
        new.options[:force_disable_mapping]=false unless new.options.include?(:force_disable_mapping)
      rescue => e
        error "Failed to load options for class '#{new.to_s}'", e
      end

      def load_object_property_options(new,result)
        #load options from ontology
        result.each do |line|
          next if !line.include?(:p) || !line.include?(:v) ||line[:p]=="iofMetaData"
          case line[:p]
          when "allowsAnnotation"
            new.options[:allows_annotation]=(line[:v].downcase=="true")
          when "singleUsage"
            new.options[:single_usage]=(line[:v].downcase=="true")
          when "isReasoningResult"
            new.options[:reasoning_result]=(line[:v].downcase=="true")
          when "isTreeLeavingProperty"
            new.options[:tree_leaving_property]=(line[:v].downcase=="true")
          when "disableMapping"
            new.options[:disable_mapping]=(line[:v].downcase=="true")
          when "forceDisableMapping"
            new.options[:force_disable_mapping]=(line[:v].downcase=="true")
          else
            warn "Unknown iofMetaData property '#{line[:p]}' with value '#{line[:v]}' for class '#{new.ns}:#{new.ontology_name}'"
          end
        end unless result.nil?()
        #load inherited options from superproperty
        s_opts=new.direct_super.options
        if s_opts.include?(:single_usage) && !new.options.include?(:single_usage) then
          debug "Loading 'singleUsage' from superclass '#{new.direct_super.to_s}'"
          new.options[:single_usage]=s_opts[:single_usage]
        end
        if s_opts.include?(:tree_leaving_property) && !new.options.include?(:tree_leaving_property) then
          debug "Loading 'isTreeLeavingProperty' from superclass '#{new.direct_super.to_s}'"
          new.options[:tree_leaving_property]=s_opts[:tree_leaving_property]
        end

        #using default values
        new.options[:allows_annotation]=false unless new.options.include?(:allows_annotation)
        new.options[:single_usage]=false unless new.options.include?(:single_usage)
        new.options[:reasoning_result]=false unless new.options.include?(:reasoning_result)
        new.options[:tree_leaving_property]=false unless new.options.include?(:tree_leaving_property)
        new.options[:disable_mapping]=false unless new.options.include?(:disable_mapping)
        new.options[:force_disable_mapping]=false unless new.options.include?(:force_disable_mapping)
        Iof::Data::RECURSIVE_BLACKLIST[new.ns.intern]=Array.new() unless Iof::Data::RECURSIVE_BLACKLIST.include?(new.ns.intern)
        Iof::Data::RECURSIVE_BLACKLIST[new.ns.intern] << new.ontology_name.intern if new.options[:reasoning_result] || new.options[:tree_leaving_property]
      rescue => e
        error "Failed to load options for property '#{new.to_s}'", e
      end

      def load_data_options(new,result)
        #load options from ontology
        result.each do |line|
          next if !line.include?(:p) || !line.include?(:v) ||line[:p]=="iofMetaData"
          case line[:p]
          when "allowsAnnotation"
            new.options[:allows_annotation]=(line[:v].downcase=="true")
          when "singleUsage"
            new.options[:single_usage]=(line[:v].downcase=="true")
          when "isReasoningResult"
            new.options[:reasoning_result]=(line[:v].downcase=="true")
          when "disableMapping"
            new.options[:disable_mapping]=(line[:v].downcase=="true")
          when "forceDisableMapping"
            new.options[:force_disable_mapping]=(line[:v].downcase=="true")
          else
            warn "Unknown iofMetaData property '#{line[:p]}' with value '#{line[:v]}' for class '#{new.ns}:#{new.ontology_name}'"
          end
        end unless result.nil?()
        #load inherited options from superproperty
        s_opts=new.direct_super.options
        if s_opts.include?(:single_usage) && !new.options.include?(:single_usage) then
          debug "Loading 'singleUsage' from superclass '#{new.direct_super.to_s}'"
          new.options[:single_usage]=s_opts[:single_usage]
        end

        #using default values
        new.options[:allows_annotation]=false unless new.options.include?(:allows_annotation)
        new.options[:single_usage]=false unless new.options.include?(:single_usage)
        new.options[:reasoning_result]=false unless new.options.include?(:reasoning_result)
        new.options[:disable_mapping]=false unless new.options.include?(:disable_mapping)
        new.options[:force_disable_mapping]=false unless new.options.include?(:force_disable_mapping)
      rescue => e
        error "Failed to load options for property '#{new.to_s}'", e
      end

      def load_property_datatype_range_helper(property,plain,union)
        #TODO extend data type support
        result=Array.new()
        begin
          plain.each do |line|
            next if line.nil?() || line.empty?()
            next if line[:"__unknown_t"]
            result << {:name => line[:t].intern, :ns => line[:__ns_t]} if line.include?(:t)
          end unless plain.nil?()
          unless union.nil?() || union.empty?() then
            parsed_union=resolve_union_blank_nodes(property,union)
            parsed_union.each do |datatype|
              result << datatype unless result.include?(datatype)
            end
          end
        rescue Iof::Data::IntersectionUnsupportedError => e
          error "Found intersection structure in range definition of property #{property.name}", e
          result=nil
        rescue Iof::Data::NestingUnsupportedError => e
          error "Found nested defintion collections in range definition of property #{property.name}", e
          result=nil
        rescue => e
          error "Unknown error while resolving blank nodes in range definition of property #{property.name}", e
          result=nil
        end
        if result.nil?() then
          property.domain.each do |cls|
            begin
              Iof::Data.namespace_to_module(cls[:ns]).const_get(cls[:name]).in_domain_of.delete({:name => property.name.intern, :ns => property.ns.intern})
            rescue => e
              error "Failed to remove property #{property.name} from class #{cls.to_s}", e
            end
          end
          property.domain=nil
          property.range=nil
        else
          r=[]
          if result.nil?() then
            warn "Property '#{property.name}' has invalid range"
            r=nil
          elsif result.empty?() then
            #no own range using range from super property
            sup=property.direct_super
            until sup.nil?() || sup==Iof::Data::Base ||sup==Iof::Data::BaseObjectProperty || sup==Iof::Data::BaseDatatypeProperty || sup==Iof::Data::BaseAnnotationProperty do
              s=sup.send(:range)
              if s.nil?() then
                warn "Super property '#{sup.name}' of property '#{property.name}' has invalid range; inheriting"
                r=nil
                break
              elsif s.empty?() then
                warn "Super property '#{sup.name}' of property '#{property.name}' has empty range; trying next super"
                sup=sup.direct_super
              else
                r=s
                break
              end
            end
          else
            r=result
          end
          if r.nil?() then
            property.domain.each do |cls|
              begin
                Iof::Data.namespace_to_module(cls[:ns]).const_get(cls[:name]).in_domain_of.delete({:name => property.name.intern, :ns => property.ns.intern})
              rescue => e
                error "Failed to remove property #{property.name} from class #{cls.to_s}", e
              end
            end
            property.domain=nil
            property.range=nil
          else
            property.range=r.clone()
          end
        end
        return nil
      end

      def load_property_object_domain_range_helper(property,no_range,domain_plain,domain_union,range_plain,range_union)
        result=Hash.new()
        result[:range]=Array.new() unless no_range
        result[:domain]=Array.new()
        result.keys.each do |type|
          plain=nil
          union=nil
          if type==:domain then
            plain=domain_plain
            union=domain_union
          else
            plain=range_plain
            union=range_union
          end
          begin
            raise IntersectionUnsupportedError, "Found multiple domain entries in #{type.to_s} definition of property '#{property}'" if type==:domain && !plain.nil?() && plain.size() > 1
            plain.each do |line|
              next if line.nil?() || line.empty?()
              next if line[:"__unknown_t"]
              result[type] << {:name => line[:t].intern, :ns => line[:__ns_t]} if line.include?(:t)
            end unless plain.nil?()
            unless union.nil?() || union.empty?()
              parsed_union=resolve_union_blank_nodes(property,union)
              parsed_union.each do |cls|
                result[type] << cls unless result[type].include?(cls)
              end
            end
          rescue Iof::Data::IntersectionUnsupportedError => e
            error "Found intersection structure in #{type.to_s} definition of property #{property.name}", e
            result=Hash.new()
            break
          rescue Iof::Data::NestingUnsupportedError => e
            error "Found nested defintion collections in #{type.to_s} definition of property #{property.name}", e
            result=Hash.new()
            break
          rescue => e
            error "Unknown error while resolving blank nodes in #{type.to_s} definition of property #{property.name}", e
            result=Hash.new()
            break
          end
        end
        if result.nil?() || result.empty?() then
          property.domain=nil
          property.range=nil
        else
          result.keys.each do |type|
            r=[{:name => :BaseClass, :ns => nil}]
            if result[type].nil?() then
              warn "Property '#{property.name}' has invalid #{type.to_s}"
              r=nil
            elsif result[type].empty?() then
              #no own domain/range using domain/range from super property
              sup=property.direct_super
              until sup.nil?() || sup==Iof::Data::Base ||sup==Iof::Data::BaseObjectProperty || sup==Iof::Data::BaseDatatypeProperty || sup==Iof::Data::BaseAnnotationProperty do
                s=sup.send(type)
                if s.nil?() then
                  warn "Super property '#{sup.name}' of property '#{property.name}' has invalid #{type.to_s}; inheriting"
                  r=nil
                  break
                elsif s.empty?() then
                  warn "Super property '#{sup.name}' of property '#{property.name}' has empty #{type.to_s}; trying next super"
                  sup=sup.direct_super
                else
                  r=s
                  break
                end
              end
            else
              r=result[type]
            end
            if r.nil?() then
              property.send("#{type.to_s}=".intern,nil)
            else
              tmp=r.clone
              r.each do |cls|
                mod=nil
                mod=Iof::Data.namespace_to_module(cls[:ns])
                mod=Iof::Data if mod.nil?()
                mod.const_get(cls[:name].to_s).subs.keys.each do |ns|
                  mod.const_get(cls[:name].to_s).subs[ns].keys.each do |c|
                    debug "Found #{c.to_s} as sub of #{cls[:name].to_s}"
                    tmp <<  {:name => c.intern, :ns => ns.intern}
                  end
                end
              end unless r.nil?()
              tmp.compact!
              tmp.uniq!
              debug "Storing #{type.to_s} for #{property.name}: '#{tmp.inspect}'"
              property.send("#{type.to_s}=".intern,tmp)
              tmp.each do |cls|
                mod=nil
                mod=Iof::Data.namespace_to_module(cls[:ns])
                mod=Iof::Data if mod.nil?()
                in_of=mod.const_get(cls[:name]).send("in_#{type.to_s}_of".intern)
                debug "Adding #{property.name} to 'in_#{type}_of' class of #{cls[:name]}"
                in_of << { :name => property.name.intern, :ns => property.ns.intern }
              end
            end
          end
        end
        return nil
      end

      def resolve_union_blank_nodes(property,union)
        result=Array.new()
        union.each do |line|
          if line.include?(:"__ns_p") && line[:"__ns_p"]==:owl && line.include?(:"p") && line[:"p"]=="intersectionOf" then
            raise IntersectionUnsupportedError, "Found 'owl:intersectionOf' in definition of property '#{property.ns}:#{property.ontology_name}'"
          elsif line.include?(:"__unknown_c") && line[:"__unknown_c"] then
            raise NestingUnsupportedError, "Found node in unknown namespace in definition of property '#{property.ns}:#{property.ontology_name}'; assuming blank node; assuming nested collections"
          elsif line.include?(:c) then
            result << {:name => line[:c].intern, :ns => line[:__ns_c]}
          else
            raise "Unexpected result structure in line '#{line}'"
          end
        end unless union.nil?()
        return result
      end

      def create_all_hierarchies()
        @tmp_query_results=Hash.new()
        create_hierarchy(Iof::Data::BaseClass,"class","class","Class","subClassOf")
        @tmp_query_results=Hash.new()
        create_hierarchy(Iof::Data::BaseObjectProperty,"object property","property","ObjectProperty","subPropertyOf")
        @tmp_query_results=Hash.new()
        create_hierarchy(Iof::Data::BaseDatatypeProperty,"datatype property","property","DatatypeProperty","subPropertyOf")
        @tmp_query_results=Hash.new()
        create_hierarchy(Iof::Data::BaseAnnotationProperty,"annotation property","property","AnnotationProperty","subPropertyOf")
        remove_instance_variable(:@tmp_query_results)
      end

      def sort_in_hash_by(key,query_result)
        result=Hash.new()
        query_result.each do |line|
          unless line.include?(key) then
            warn "Skipping line '#{line}' due to missing key"
            next
          end
          result[line[key].intern]=Array.new()  unless result.include?(line[key].intern)
          result[line[key].intern] << line
        end unless query_result.nil?()
        return result
      end

      def create_hierarchy(base,long_type_name,short_type_name,ontology_type,ontology_relation)
        debug "Creating #{long_type_name} hierarchy"
        raw_super=Hash.new()
        raw_sub=Hash.new()
        sub=Hash.new()
        top=Array.new()
        objects=Array.new()
        #query structure
        debug "Querying #{long_type_name} structure"
        structure=@ontology.query("SELECT DISTINCT ?c1 ?c2 WHERE { ?c1 rdfs:#{ontology_relation} ?c2 . ?c1 a owl:#{ontology_type} . ?c2 a owl:#{ontology_type} }",false,false,[:no,:owl])
        debug  "Querying #{long_type_name} options"
        @tmp_query_results[short_type_name.intern]=Hash.new()
        q=@ontology.query("SELECT DISTINCT ?p ?o ?v WHERE { ?p rdfs:subPropertyOf #{@ontology.default_ns}:iofMetaData . ?o a owl:#{ontology_type} . ?o ?p ?v }",false,true,[:no,:owl])
        @tmp_query_results[short_type_name.intern][:options]=sort_in_hash_by(:o, q)
        unless short_type_name.intern==:class then
          debug "Querying #{long_type_name} domain"
          q_plain=@ontology.query("SELECT DISTINCT ?p ?t WHERE { ?p a owl:#{ontology_type} . ?p rdfs:domain ?t }",false,true,[])
          debug "Querying #{long_type_name} domain unions"
          q_union=@ontology.query("SELECT DISTINCT ?col ?p ?c WHERE { ?p a owl:#{ontology_type} . ?p rdfs:domain _:b0 . _:b0 ?col [list:member ?c] }",false,true,[])
          @tmp_query_results[short_type_name.intern][:domain]=Hash.new()
          @tmp_query_results[short_type_name.intern][:domain][:plain]=sort_in_hash_by(:p, q_plain)
          @tmp_query_results[short_type_name.intern][:domain][:union]=sort_in_hash_by(:p, q_union)
          debug "Querying #{long_type_name} range"
          q_plain=@ontology.query("SELECT DISTINCT ?p ?t WHERE { ?p a owl:#{ontology_type} . ?p rdfs:range ?t }",false,true,[])
          debug "Querying #{long_type_name} range unions"
          q_union=@ontology.query("SELECT DISTINCT ?col ?p ?c WHERE { ?p a owl:#{ontology_type} . ?p rdfs:range _:b0 . _:b0 ?col [list:member ?c] }",false,true,[])
          @tmp_query_results[short_type_name.intern][:range]=Hash.new()
          @tmp_query_results[short_type_name.intern][:range][:plain]=sort_in_hash_by(:p, q_plain)
          @tmp_query_results[short_type_name.intern][:range][:union]=sort_in_hash_by(:p, q_union)
        end
        structure.each do |c|
          objects << {:name => c[:c1].intern, :ns => c[:__ns_c1].intern} unless c[:c1].nil?() || objects.include?({:name => c[:c1].intern, :ns => c[:__ns_c1].intern})
          objects << {:name => c[:c2].intern, :ns => c[:__ns_c2].intern} unless c[:c2].nil?() || objects.include?({:name => c[:c2].intern, :ns => c[:__ns_c2].intern})
          next if c[:c1]==c[:c2] && c[:__ns_c1]==c[:__ns_c2]
          next unless c.include?(:c2) && c.include?(:c1)
          raw_sub["#{c[:__ns_c2]}___#{c[:c2]}".intern]=Array.new() unless raw_sub.include?("#{c[:__ns_c2]}___#{c[:c2]}".intern)
          raw_sub["#{c[:__ns_c2]}___#{c[:c2]}".intern] << {:name => c[:c1].intern, :ns => c[:__ns_c1].intern} unless raw_sub["#{c[:__ns_c2]}___#{c[:c2]}".intern].include?({:name => c[:c1].intern, :ns => c[:__ns_c1].intern})
          raw_super["#{c[:__ns_c1]}___#{c[:c1]}".intern]=Array.new() unless raw_super.include?("#{c[:__ns_c1]}___#{c[:c1]}".intern)
          raw_super["#{c[:__ns_c1]}___#{c[:c1]}".intern] << {:name => c[:c2].intern, :ns => c[:__ns_c2].intern} unless raw_super["#{c[:__ns_c1]}___#{c[:c1]}".intern].include?({:name => c[:c2].intern, :ns => c[:__ns_c2].intern})
        end
        objects.each do |o|
          s=raw_super["#{o[:ns]}___#{o[:name]}".intern]
          debug "Sorting super#{short_type_name} of #{o.to_s}"
          candidate=nil
          s.each do |s1|
            success=true
            s.each do |s2|
              next if s1[:ns]==s2[:ns] && s1[:name]==s2[:name]
              #check if s1 is sub of s1
              #candidate is direct super of current object (o) if candidate is sub of all other objects which are super of o
              success&&=raw_sub["#{s2[:ns]}___#{s2[:name]}".intern].include?(s1)
              break unless success
            end
            next unless success
            if candidate.nil?() then
              candidate=s1
            else
              error "Conflicting real super#{short_type_name} #{s1.to_s} and #{candidate}"
            end
          end unless s.nil?()
          if s.nil?() then
            debug "#{o.to_s} is top level #{long_type_name}"
            top << o unless top.include?(o)
            next
          end
          if candidate.nil?() then
            debug "Got no direct super#{short_type_name} for #{o.to_s}"
            next
          else
            debug "Got direct super#{short_type_name} for #{o.to_s} '#{candidate}'"
            sub["#{candidate[:ns]}___#{candidate[:name]}".intern]=Array.new() unless sub.include?("#{candidate[:ns]}___#{candidate[:name]}".intern)
            sub["#{candidate[:ns]}___#{candidate[:name]}".intern] << o unless sub["#{candidate[:ns]}___#{candidate[:name]}".intern].include?(o)
          end
        end
        top.each do |object|
          create_hierarchy_helper(sub,base,object,short_type_name,long_type_name)
        end unless top.nil?()
        debug "Creating #{long_type_name} hierarchy done"
        return nil
      end

      def create_hierarchy_helper(structure,parent,klass,short_type_name,long_type_name)
        debug "Creating #{long_type_name} '#{klass.to_s}' as sub#{short_type_name} of '#{parent.to_s}' in #{long_type_name} hierarchy"
        new=parent.new_sub(klass[:ns],klass[:name])
        if new.is_sub_of?(:BaseObjectProperty,nil) then
          debug "Processing domain and range for #{long_type_name} #{new.to_s}"
          load_property_object_domain_range_helper(new,false,
              @tmp_query_results[short_type_name.intern][:domain][:plain][new.ontology_name.intern],
              @tmp_query_results[short_type_name.intern][:domain][:union][new.ontology_name.intern],
              @tmp_query_results[short_type_name.intern][:range][:plain][new.ontology_name.intern],
              @tmp_query_results[short_type_name.intern][:range][:union][new.ontology_name.intern])
          debug "Processing options for #{long_type_name} #{new.to_s}"
          load_object_property_options(new,
              @tmp_query_results[short_type_name.intern][:options][new.ontology_name.intern])
        elsif new.is_sub_of?(:BaseDatatypeProperty,nil) || new.is_sub_of?(:BaseAnnotationProperty,nil)
          debug "Processing domain for #{long_type_name} #{new.to_s}"
          load_property_object_domain_range_helper(new,true,
                @tmp_query_results[short_type_name.intern][:domain][:plain][new.ontology_name.intern],
                @tmp_query_results[short_type_name.intern][:domain][:union][new.ontology_name.intern],
                nil,nil)
          debug "Processing range for #{long_type_name} #{new.to_s}"
          load_property_datatype_range_helper(new,
                @tmp_query_results[short_type_name.intern][:range][:plain][new.ontology_name.intern],
                @tmp_query_results[short_type_name.intern][:range][:union][new.ontology_name.intern])
          debug "Processing options for #{long_type_name} #{new.to_s}"
          load_data_options(new,@tmp_query_results[short_type_name.intern][:options][new.ontology_name.intern])
        elsif new.is_sub_of?(:BaseClass,nil)
          debug "Processing options for #{long_type_name} #{new.to_s}"
          load_class_options(new,@tmp_query_results[short_type_name.intern][:options][new.ontology_name.intern])
        end
        substructure=structure["#{klass[:ns]}___#{klass[:name]}".intern]
        debug "Processing substructure for #{long_type_name} #{new.to_s}"
        substructure.each do |sub|
          create_hierarchy_helper(structure,new,sub,short_type_name,long_type_name)
        end unless substructure.nil?()
      end
    end
  end
end
