# encoding: utf-8
# license: gpl2p

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST
require 'ipaddress'

module Iof
  module Data
    def self.mac_cisco_format(mac)
      return mac_plain(mac).scan(/[0-9a-f]{4}/).join('.')
    rescue
      return nil
    end

    def self.mac_plain(mac)
      m=mac.tr('_ .:','').downcase
      if m.match(/^[0-9a-f]{12}$/)
        return m
      else
        return nil
      end
    rescue
      return nil
    end

    def self.mac_with_colon(mac)
      return mac_plain(mac).scan(/[0-9a-f]{2}/).join(':')
    rescue
      return nil
    end

    def self.ipv4_network_part(address,netmask)
      IPAddress::IPv4.new("#{address}/#{netmask}").network.to_s
    rescue
      return nil
    end

    def self.ipv4_netmask_to_length(netmask)
      IPAddress::Prefix32.parse_netmask(netmask).to_s
    rescue
      return nil
    end

    def self.ipv4_length_to_netmask(length)
      IPAddress::Prefix32.new(length).to_ip
    rescue
      return nil
    end

    def self.ipv4_to_netmask(mask)
      ipv4_parse_netmask(mask)
    rescue
      return nil
    end

    def self.ipv4_parse_netmask(netmask)
      if netmask.is_a?(String) && netmask.match(/\./) then
        octets=netmask.split('.')
        bits=Array.new()
        bits.concat(Array.new(8) { |i| octets[0].to_i[i] }.reverse!)
        bits.concat(Array.new(8) { |i| octets[1].to_i[i] }.reverse!)
        bits.concat(Array.new(8) { |i| octets[2].to_i[i] }.reverse!)
        bits.concat(Array.new(8) { |i| octets[3].to_i[i] }.reverse!)
        invalid=false
        start_with=nil
        end_with=nil
        inverted_bits=Array.new
        bits.each do |b|
          inverted_bits << 1-b
          if start_with.nil?() then
            start_with=b
            next
          elsif end_with.nil?() then
            next if start_with==b
            end_with=b
          else
            next if end_with==b
            invalid=true
          end
        end
        return nil if invalid
        #if bits start with 0 and end with 1 it is a hostmask
        bits=inverted_bits if start_with==0 && end_with==1
        octets=Array.new()
        (0..3).each do |n|
          octets[n]=0
          bits[(n*8)..(n*8+7)].map { |i| octets[n]*=2; octets[n]+=i}
          octets[n]=octets[n].to_s
        end
        return octets.join('.')
      else
        #seems to be a netmask length
        begin
          n=netmask.to_i
          return self.ipv4_length_to_netmask(n)
        rescue
          return nil
        end
      end
    rescue
      return nil
    end

    def self.ipv6_address_compressed(address)
      if address.match(/\//) then
        IPAddress::IPv6.new(address).to_string.downcase
      else
        IPAddress::IPv6.new(address).to_string.sub(/\/.*/,'').downcase
      end
    rescue
      return nil
    end

    def self.ipv6_address_uncompressed(address)
      if address.match(/\//) then
        IPAddress::IPv6.new(address).to_string_uncompressed.downcase
      else
        IPAddress::IPv6.new(address).to_string_uncompressed.sub(/\/.*/,'').downcase
      end
    rescue
      return nil
    end

    def self.ipv6_address_ifmap(address)
      netmask=nil
      uncompressed=nil
      if address.match(/\//) then
        netmask=address.sub(/.*\//,'')
        uncompressed=IPAddress::IPv6.new(address.sub(/\/.*/,'')).to_string_uncompressed.sub(/\/.*/,'').downcase
      else
        uncompressed=IPAddress::IPv6.new(address).to_string_uncompressed.sub(/\/.*/,'').downcase
      end

      new_address=""
      address_split=uncompressed.split(':')
      address_split.each do |block|
        new_address+=":" unless new_address==""
        if block.match(/^0/) then
          new_block=block.gsub(/^0*/,'').downcase
          new_block="0" if new_block==""
          new_address+=new_block
        else
          new_address+=block.downcase
        end
      end
      if netmask.nil?() then
        return new_address
      else
        return "#{new_address}/#{netmask}"
      end
    rescue
      return nil
    end

    def self.ipv6_network_part_uncompressed(address,netmask)
      IPAddress::IPv6.new("#{address}/#{netmask}").network.to_string_uncompressed.sub(/\/.*/,'').downcase
    rescue
      return nil
    end

    def self.ipv6_network_part_compressed(address,netmask)
      IPAddress::IPv6.new("#{address}/#{netmask}").network.to_string.sub(/\/.*/,'').downcase
    rescue
      return nil
    end

    def self.ipv6_network_part_ifmap(address,netmask)
      network=IPAddress::IPv6.new("#{address}/#{netmask}").network.to_string_uncompressed.sub(/\/.*/,'').downcase
      return ipv6_address_ifmap(network)
    rescue
      return nil
    end

  end
end
