# encoding: utf-8
# license: gpl2p

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST
Ghun::Base::java_require("ifmap")
module Iof
  module IfMap
    class Connector < Ghun::Base::StatefullConnection
      def initialize(name,type=:ifmap)
        super(:sync,type,true,Ghun::Log::Source::IFMAP)
        @name=name.intern
        Ghun::Base::Blackboard.config.declare_dynamic_key(:"ifmap.#{@name.to_s}.auth", :string)
        Ghun::Base::Blackboard.config.declare_dynamic_key(:"ifmap.#{@name.to_s}.server", :string)
        @server_address=config[:"ifmap.#{@name.to_s}.server"]
        @auth_name=config[:"ifmap.#{@name.to_s}.auth"].intern

        @arc=nil
        @ssrc=nil
        @auth_handler=Ghun::Auth::Handler.new()

        @auth=@auth_handler[@auth_name]

        @registered_subscriptions=Hash.new()
        @published_data=Hash.new()
        @notified_data=Hash.new()
        @subscription_couter=0
      end
      attr_reader :factories

      def publish(publish_elements)
        pubreq=::IfMap::Messages::Requests.create_publish_req
        publish_elements.each do |p|
          pubreq.add_publish_element(p)
        end
        execute_request({:channel => :ssrc, :request_type => :publish, :request => pubreq})
      end

      def publish_update(d1,d2,meta)
        pu=::IfMap::Messages::Requests.createPublishUpdate()
        pu.identifier1=d1
        pu.identifier2=d2 unless d2.nil?()
        pu.add_metadata(meta)
        return pu
      end

      def publish_notify(d1,d2,meta)
        pn=::IfMap::Messages::Requests.createPublishNotify()
        pn.identifier1=d1
        pn.identifier2=d2 unless d2.nil?()
        pn.add_metadata(meta)
        return pn
      end

      def device(name)
        id=::IfMap::Identifier::Identifiers.createDev(name)
      end

      def dev_ip
        @factories[:meta].create_dev_ip()
      end

      def ip_mac
        @factories[:meta].create_ip_mac()
      end

      def extended_identifier(identifier,attributes,ns,ns_prefix)
        if attributes.nil?()
          attr={}
        else
          attr=attributes.clone
        end
        attr[:"xmlns:#{ns_prefix}"]=ns
        attr[:"administrative-domain"]="" unless attr.include?(:"administrative-domain")
        result="<"
        result+="#{ns_prefix}:#{identifier} "
        attr.keys.sort.each do |a_key|
          result+="#{a_key.to_s}=\"#{attr[a_key]}\" "
        end
        result+="/>"
        debug "Created extended identifier #{result}"
        return ::IfMap::Identifier::Identifiers.create_extended_identity(result)
      end

      def vendor_specific_metadata(name,cardinality,attributes,ns,ns_prefix)
        c=case cardinality
        when :single_value
          ::IfMap::Metadata::Cardinality.singleValue
        when :multi_value
          ::IfMap::Metadata::Cardinality.multiValue
        end
        if attributes.nil?() || attributes.empty?()
          @factories[:meta].create(name,ns_prefix,ns,c,java.util.HashMap.new({}))
        else
          @factories[:meta].create(name,ns_prefix,ns,c,java.util.HashMap.new(attributes))
        end
      end
     private

      def connect_helper()
        unless @arc.nil?()
          @arc.close_tcp_connection()
          @arc=nil
        end
        unless @ssrc.nil?()
          @ssrc.end_session()
          @ssrc.close_tcp_connection()
        end
        @ssrc=::IfMap::IfmapJ.create_ssrc(@server_address,@auth.username,@auth.password,::IfMap::IfmapJHelper.getTrustManagers(@auth.keyfile,@auth.passphrase))
        @factories=Hash.new()
        @factories[:meta]=::IfMap::IfmapJ.create_standard_metadata_factory()

        @ssrc.new_session()
        @arc=@ssrc.arc()
        return true
      end

      def disconnect_helper()
        unless @arc.nil?()
          @arc.close_tcp_connection()
          @arc=nil
        end
        unless @ssrc.nil?()
          @ssrc.end_session()
          @ssrc.close_tcp_connection()
          @ssrc=nil
        end
        @registered_subscriptions=Hash.new()
        @published_data=Hash.new()
        @subscription_couter=0
        @factories=Hash.new()
        return true
      end

      def execute_helper(args)
        begin
          if args[:channel]==:ssrc
            #ssrc
            case args[:request_type]
            when :publish
              @ssrc.publish(args[:request])
            when :subscribe
              #FIXME
              #@ssrc.subscribe(::IfMap::Messages::Requests.create_subscribe_req(args[:request]))
            else
              raise "Unsupported request type #{args[:request_type]} for channel type #{args[:channel]}"
            end
          elsif args[:channel]==:arc
            #arc
            case args[:request_type]
            when :poll
              #FIXME
              #@arc.poll(::IfMap::Messages::Requests.create_poll_req(args[:request]))
           else
              raise "Unsupported request type #{args[:request_type]} for channel type #{args[:channel]}"
            end
          else
            raise "Unknown channel #{args[:channel]}"
          end
          return true
        rescue => e
          error "Ifmap Request #{args} failed", e
          return nil
        end
      end

      def convert_rfc5952_to_ifmap_v20(identifier)
        new_id=""
        qs=identifier.split(':')
        missing=8-(qs.size)
        qs.each do |q|
          new_q=""
          if q=="" then
            new_q="0"
            new_id+=":" unless new_id==""
            new_id+=new_q
            missing.times do
              new_id+=":" unless new_id==""
              new_id+="0"
            end
            missing=0
          elsif q.match(/^0/) then
            new_q=q.gsub(/^0*/,'')
            new_q="0" if new_q==""
            new_id+=":" unless new_id==""
            new_id+=new_q
          else
            new_id+=":" unless new_id==""
            new_id+=q
          end
        end
        new_id.downcase!
        return new_id
      end

      def convert_ifmap_v20_to_rfc5952_full(identifier)
        new_id=""
        qs=identifier.split(':')
        qs.each do |q|
          new_id+=":" unless new_id==""
          l=q.length
          until l==4 do
            new_id+="0"
            l+=1
          end
          new_id+=q
        end
        new_id.downcase!
        return new_id
      end
    end
  end
end


#      def unpublish(type,d1,d2)
#        identifier="#{type.to_s}_#{d1}_#{d2}".intern
#        unless @published_data.include?(type) && @published_data[type].include?(identifier.intern) then
#          warn "Subscription of type '#{type.to_s}' with data '#{d1}' and '#{d2}'"
#        else
#          debug "Unsubscribing type '#{type.to_s}' with data '#{d1}' and '#{d2}'"
#          publish_helper(@published_data[type][identifier.intern][:unpub])
#          @published_data[type].delete(identifier.intern)
#        end
#        return nil
#      rescue => e
#        error "Failed to unpublish type '#{type.to_s}' with data '#{d1}' and '#{d2}'", e
#        return nil
#      end
#
#      def unpublish_all()
#        @published_data.each do |type,identifiers|
#          if identifiers.nil?() || identifiers.empty?() then
#            debug "Nothing to unsubscribe for type '#{type.to_s}'"
#          else
#            debug "Unsubscribing #{identifiers.size} elements of type '#{type.to_s}'"
#          end
#          identifiers.keys.each do |identifier|
#            debug "Unsubscribing type '#{type.to_s}' with identifier '#{identifier}'"
#            publish_helper(@published_data[type][identifier][:unpub])
#            @published_data[type].delete(identifier.intern)
#          end
#        end
#        @published_data=Hash.new()
#        return nil
#      end
#
#      def subscribe(type,identifier)
#        if @registered_subscriptions.include?(type) && @registered_subscriptions[type].include?(identifier.intern) then
#          warn "Subscription of type '#{type.to_s}' with identifier '#{identifier}' already registered"
#          return false
#        else
#          debug "Subscribing type '#{type.to_s}' with identifier '#{identifier}'"
#          name="io#{"%07d" % @subscription_couter.to_s}"
#          @subscription_couter+=1
#          @registered_subscriptions[type]=Hash.new() unless @registered_subscriptions.include?(type)
#          subscribe=Hash.new()
#          id=nil
#          begin
#            case type
#            when :device
#              id=::IfMap::Identifier::Identifiers.createDev(identifier)
#            when :ipv4
#              id=::IfMap::Identifier::Identifiers.createIp4(identifier)
#            when :ipv6
#              #FIXME address validation in irond for ipv6 addresses is heavily broken
#              id=::IfMap::Identifier::Identifiers.createIp6(convert_rfc5952_to_ifmap_v20(identifier))
#            when :mac
#              id=::IfMap::Identifier::Identifiers.createMac(identifier)
#            end
#          rescue => e
#            error "Failed to create subscription object for type '#{type.to_s}' and identifier '#{identifier}'", e
#          end
#          if id.nil?() then
#            error "Either type '#{type.to_s}' or identifier '#{identifier}' seems to be invalid"
#            return
#          end
#          subscribe[:sub]=::IfMap::Messages::Requests.createSubscribeUpdate(name,nil,255,nil,nil,nil,id)
#          subscribe[:unsub]=::IfMap::Messages::Requests.createSubscribeDelete(name)
#          begin
#            subscribe_helper(subscribe[:sub])
#            @registered_subscriptions[type][identifier.intern]=subscribe
#          rescue => e
#            error "Failed to subscribe type '#{type.to_s}' with identifier '#{identifier}'", e
#          end
#          return true
#        end
#      end
#
#      def unsubscribe(type,identifier)
#        unless @registered_subscriptions.include?(type) && @registered_subscriptions[type].include?(identifier.intern) then
#          warn "Subscription of type '#{type.to_s}' with identifier '#{identifier}' not known"
#        else
#          debug "Unsubscribing type '#{type.to_s}' with identifier '#{identifier}'"
#          subscribe_helper(@registered_subscriptions[type][identifier.intern][:unsub])
#          @registered_subscriptions[type].delete(identifier.intern)
#        end
#        return nil
#      rescue => e
#        error "Failed to unsubscribe type '#{type.to_s}' with identifier '#{identifier}'", e
#        return nil
#      end
#
#      def unsubscribe_all()
#        @registered_subscriptions.each do |type,identifiers|
#          if identifiers.nil?() || identifiers.empty?() then
#            debug "Nothing to unsubscribe for type '#{type.to_s}'"
#          else
#            debug "Unsubscribing #{identifiers.size} elements of type '#{type.to_s}'"
#          end
#          identifiers.keys.each do |identifier|
#            unsubscribe(type, identifier)
#          end
#        end
#        @registered_subscriptions=Hash.new()
#        return nil
#      end
#
#      def stop_session(cleanup=true)
#      end
#
#      def dump()
#        dump_req=::IfMap::Messages::Requests.createDumpReq()
#        result_raw=@ssrc.genericRequestWithSessionId(dump_req)
#        result=Hash.new()
#        result[:mac]=Array.new()
#        result[:ipv4]=Array.new()
#        result[:ipv6]=Array.new()
#        result_raw.get_identifiers.each do |id|
#          next if id.nil?()
#          if id.is_a?(Java::DeFhhannoverInformTrustIfmapjIdentifier::MacAddress) then
#            result[:mac] << id.get_value
#          elsif id.is_a?(Java::DeFhhannoverInformTrustIfmapjIdentifier::IpAddress) then
#            if id.type.to_s == "IPv4" then
#              result[:ipv4] << id.get_value
#            elsif id.type.to_s == "IPv6" then
#              result[:ipv6] << convert_ifmap_v20_to_rfc5952_full(id.get_value)
#            else
#              warn "Unknown ip type '#{id.type.to_s}' in dump result"
#            end
#          else
#            warn "Unknown identifier type '#{id.type.to_s}' in dump result"
#          end
#        end
#        return result
#      rescue => e
#        error "An error occured while dumping data", e
#        raise
#        return nil
#      end
#
#      def poll
#        restart_session() unless @connected
#        @arc=@ssrc.getArc() if @arc.nil?()
#        raw=@arc.poll()
#        result=Hash.new()
#        result[:delete]=raw.delete_results.to_a
#        result[:notify]=raw.notify_results.to_a
#        result[:search]=raw.search_results.to_a
#        result[:update]=raw.update_results.to_a
#        result[:error]=raw.error_results.to_a
#        result.each do |key,result_raw|
#          next if result_raw.empty?()
#          result_new=Array.new()
#          result_raw.each do |r|
#            items=r.result_items.to_a
#            items_new=Hash.new()
#            items_new[:mac]=Array.new()
#            items_new[:ipv4]=Array.new()
#            items_new[:ipv6]=Array.new()
#            items.each do |i|
#              identifiers=Array.new()
#              identifiers << i.identifier1 if i.respond_to?(:identifier1)
#              identifiers << i.identifier2 if i.respond_to?(:identifier2)
#              identifiers.each do |id|
#                next if id.nil?()
#                if id.is_a?(Java::DeFhhannoverInformTrustIfmapjIdentifier::MacAddress) then
#                  items_new[:mac] << id.get_value
#                elsif id.is_a?(Java::DeFhhannoverInformTrustIfmapjIdentifier::IpAddress) then
#                  if id.type.to_s == "IPv4" then
#                    items_new[:ipv4] << id.get_value
#                  elsif id.type.to_s == "IPv6" then
#                    items_new[:ipv6] << convert_ifmap_v20_to_rfc5952_full(id.get_value)
#                  else
#                    warn "Unknown ip type '#{id.type.to_s}' in polling result"
#                  end
#                else
#                  warn "Unknown identifier type '#{id.type.to_s}' in polling result"
#                end
#              end
#            end
#            items_new.each do |type,values|
#              values.compact!
#              values.sort!
#              values.uniq!
#            end
#            result_new << items_new
#          end
#          result[key]=result_new
#        end
#        return result
#      rescue => e
#        error "An error occured while polling for data", e
#        return nil
#      end
