# encoding: utf-8
# license: gpl2p 

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST
class Administrativedomain < ActiveRecord::Base

  belongs_to :parent_administrativedomain, class_name: 'Administrativedomain'
  has_many :sub_administrativedomains, class_name: 'Administrativedomain', foreign_key: 'parent_administrativedomain_id'

  has_many :administrativedomain_users, autosave: true
  has_many :users, through: :administrativedomain_users

  has_many :administrativedomain_locations, autosave: true
  has_many :locations, through: :administrativedomain_locations

  accepts_nested_attributes_for :administrativedomain_users, allow_destroy: true

  validates :name, length: { maximum: 255 }
  validates :shortname, length: { maximum: 255 }

  attr_accessor :new_user_role_id

  def self.main
    Administrativedomain.where(parent_administrativedomain_id: nil)
  end

  def is_admin?(user)
    administrativedomain_users.where(user_id: user, role: Role.find_by(int_name: 'admin')).present?
  end

  def to_s
    self.name
  end

  def to_h
    { name: name, id: id, shortname: shortname, comment: comment, :super => parent_administrativedomain.present? ? parent_administrativedomain.id : nil }
  end

  def locations_with_exception
    administrativedomain_locations.map { |ad_l| [ ad_l.location, ad_l.blacklist ] }.sort { |a,b| a[1] <=> b[1] }
  end

end
