# encoding: utf-8
# license: gpl2p 

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST
class Location < ActiveRecord::Base
  belongs_to :building

  belongs_to :parent_location, class_name: 'Location'
  has_many :sub_locations, class_name: 'Location', foreign_key: 'parent_location_id'

  has_many :administrativedomain_locations
  has_many :administrativedomains, through: :administrativedomain_locations

  has_many :maintenanceperiods

  has_many :switches


  validates :level, length: { maximum: 16 }, allow_blank: true
  validates :doornumber, length: { maximum: 16}, allow_blank: true
  validates :place, length: { maximum: 45 }, allow_blank: true

  validate do
    if parent_location.present?
      errors.add(:building, 'is present in parent location and must be empty') if parent_location.building.present? && self.building(false).present?
      errors.add(:level, 'is present in parent location and must be empty') if parent_location.level.present? && self.level(false).present?
      errors.add(:doornumber, 'is present in parent location and must be empty') if parent_location.doornumber.present? && self.doornumber(false).present?
    end
  end

  def self.main()
    Location.where(parent_location_id: nil)
  end

  def super_parent
    return self if !parent_location.present?
    parent_location.super_parent
  end

  def parent_location=(p)
    if p != self
      super(p)
    else
      super(nil)
    end
  end

  def building(p = true)
    b_tmp = get_attribute_or_from_parents(:building_id, p)
    if b_tmp
      Building.find(b_tmp)
    else
      nil
    end
  end

  def level(p = true)
    get_attribute_or_from_parents(:level, p)
  end

  def doornumber(p = true)
    get_attribute_or_from_parents(:doornumber, p)
  end

  def to_s
    r = building

    if level.present?
      r += " - #{level}"

      if doornumber.present?
        r += " - #{doornumber}"

        if place.present?
          r += " - #{place}"
        end # place
      end # doornumber
    end # level

    r
  end

  def to_h
    { building: { longname: building.longname, shortname: building.shortname }, floor: level, door: doornumber, place: place, id: id, :super => parent_location.present? ? parent_location.id : nil }
  end

=begin
  def to_tree(selected = Array.new)
    ret = Hash.new

    ret["title"] = to_s
    ret["key"] = id

    if (selected.include?(id))
      ret["selected"] = true
    end

    if (sub_locations.present?)
      ret["folder"] = true
      ret["children"] = sub_locations.map { |l| l.to_tree(selected) }
    end

    ret
  end
=end

  protected

  def get_attribute_or_from_parents(attribute, use_parent = true)
    attr_value = read_attribute(attribute)

    if attr_value.blank? && !parent_location.nil? && use_parent
      parent_location.get_attribute_or_from_parents(attribute)
    else
      attr_value
    end
  end

end
