# encoding: utf-8
# license: gpl2p 

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST
module Iof
  module Lookup
    class Base < Ghun::Base::Member
      def initialize(name,multiple_values=true)
        super('lookup',name,Ghun::Log::Source::LOOKUP)
        @data=Hash.new()
        @multiple_values=multiple_values
        init_data()
      end

      def get_data_by(type)
        @data[type]
      end

      #type_key is a hash with lookup type as key and an array or a single key as value
      def lookup_by(type_key)
        result=Array.new()
        type_key.each do |type,k|
          if !@data.include?(type)
            next
          elsif !@data[type].is_a?(Hash)
            error "Corrupted internal data structure in lookup module #{@name} for type #{type}"
            next
          end
          keys=k if k.is_a?(Array)
          keys=[k]
          keys.each do |key|
            result << @data[type][key]
          end
        end
        result=result.flatten.compact.uniq
        if result.empty?()
          return nil
        else
          return result
        end
      end

    private

      def store_by(type,key,value)
        @data[type]=Hash.new() unless @data.include?(type)
        if @multiple_values
          @data[type][key]=Array.new() unless @data[type].include?(key)
          @data[type][key] << value unless @data[type][key].include?(value)
        else
          if @data[type].include?(key) && @data[type][key]!=value
            warn "Lookup module #{@name} already has value for type #{type} and key #{key}"
            debug "Lookup module #{@name} already has value for type #{type} and key #{key}", "Old value: #{@data[type][key]}" "Ignored value #{value}"
          elsif @data[type].include?(key) && @data[type][key]==value
            debug "Duplicate value for type #{type} and key #{key} in lookup module #{@name}"
          else
            @data[type][key]=value
          end
        end
      end

      def init_data()
        raise Ghun::Base::AbstractClassError, "Implement 'init_data' to make use of class #{self.class}"
      end
    end
  end
end
