# encoding: utf-8
# license: gpl2p 

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST
module Iof
  module Lookup
    class AdministrativeDomain < Base
      Iof::Lookup::SELECTOR.register_member(self, :administrative_domain)
      def initialize(name)
        super(name,true)
        config.declare_dynamic_key("#{@config_base}database", :string)
#        @db_name=config[:"#{@config_base}database"]
#        @db=Ghun::Base::Blackboard.database.init_database(@db_name.intern)
#        @db.connect() unless @db.connected?()
      end

      def lookup_by_address(key)
        lookup_by({:address => key})
      end

      def lookup_by_device_name(key)
        lookup_by({:device_name => key})
      end

      def lookup_by_location(key)
        lookup_by({:location => key})
      end

      def lookup_by_label(key)
        lookup_by({:label => key})
      end

      def lookup_by_any(key)
        lookup_by({:address => key, :device_name => key, :location => key, :label => key})
      end

      def send_to_data_handler(data_handler)
        send_to_data_handler_helper(data_handler,[nil])
      end

    private

      def send_to_data_handler_helper(data_handler,subs)
        subs.each do |s|
          if @ad_tree.include?(s)
            @ad_tree[s][:ads].each do |ad|
              data_handler.get_administrative_domain_name(ad)
            end
            send_to_data_handler_helper(data_handler,@ad_tree[s][:sub_label]) unless @ad_tree[s][:sub_label].nil?()
          end
        end unless subs.nil?()
      end

      def add_ad(ad)
        new_ad=Hash.new()
        new_ad[:label]="__id_#{ad[:id]}".intern
        new_ad[:short_name]=ad[:shortname]
        new_ad[:long_name]=ad[:name]
        new_ad[:comment]=ad[:comment]
        new_ad[:super_label]=nil
        new_ad[:super_label]="__id_#{ad[:parent_administrativedomain_id]}".intern unless ad[:parent_administrativedomain_id].nil?()
        unless @ad_tree.include?(new_ad[:super_label])
          @ad_tree[new_ad[:super_label]]=Hash.new()
          @ad_tree[new_ad[:super_label]][:ads]=Array.new()
          @ad_tree[new_ad[:super_label]][:sub_label]=Array.new()
        end
        unless @ad_tree.include?(new_ad[:label])
          @ad_tree[new_ad[:label]]=Hash.new()
          @ad_tree[new_ad[:label]][:ads]=Array.new()
          @ad_tree[new_ad[:label]][:sub_label]=Array.new()
        end

        @ad_tree[new_ad[:label]][:ads] << new_ad unless @ad_tree[new_ad[:label]][:ads].include?(new_ad)
        @ad_tree[new_ad[:super_label]][:sub_label] << new_ad[:label] unless @ad_tree[new_ad[:super_label]][:sub_label].include?(new_ad[:label])
        store_by(:label,new_ad[:label],new_ad)
      end

      def location_label(location)
        new_location=Hash.new()
        new_location[:building]=location.building.shortname unless location.building_id.nil?() || location.building.shortname.nil?()
        new_location[:floor]=location.level.intern unless location.level.nil?()
        new_location[:door]=location.doornumber.intern unless location.doornumber.nil?()
        new_location[:id]=location.place.intern unless location.place.nil?()
        new_location[:label]="___b_#{new_location[:building]}_b_f_#{new_location[:floor]}_f_d_#{new_location[:door]}_d_i_#{new_location[:id]}_i_".intern
        return new_location[:label]
      end

      def init_data()
        @ad_tree=Hash.new()
        ::Administrativedomain.all.each do |ad|
          add_ad(ad) unless ad.nil?()
        end

        ::Location.all.each do |location|
          location.administrativedomains.each do |ad|
            label="__id_#{ad[:id]}".intern
            new_ad=lookup_by_label(label)
            store_by(:location, location_label(location), new_ad)
          end unless location.administrativedomains.nil?()
        end

        ::Switch.all.each do |switch|
          switch.location.administrativedomains.each do |ad|
            label="__id_#{ad[:id]}".intern
            new_ad=lookup_by_label(label)
            store_by(:device_name, switch.name, new_ad) unless switch.nil?() || switch.name.nil?() || switch.name==''
            store_by(:address, switch.ipv4address, new_ad) unless switch.nil?() || switch.ipv4address.nil?() || switch.ipv4address==''
          end unless switch.location_id.nil?()
        end
      end
    end
  end
end
