# encoding: utf-8
# license: gpl2p 

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST
module Iof
  module Lookup
    class AdministrativeDomainLabel < Base
      Iof::Lookup::SELECTOR.register_member(self, :administrative_domain_label)
      def initialize(name)
        super(name,false)
        config.declare_dynamic_key("#{@config_base}database", :string)
#        @db_name=config[:"#{@config_base}database"]
#        @db=Ghun::Base::Blackboard.database.init_database(@db_name.intern)
#        @db.connect() unless @db.connected?()
      end

      def lookup_by_device_name(key)
        lookup_by({:device_name => key})
      end

      def lookup_by_address(key)
        lookup_by({:address => key})
      end

      def lookup_by_any(key)
        lookup_by({:device_name => key, :address => key})
      end

    private

      def init_data()
        ::Switch.all.each do |switch|
          store_by(:device_name, switch.name, switch.administrativedomainlabel) unless switch.nil?() || switch.name.nil?() || switch.name==''
          store_by(:address, switch.ipv4address, switch.administrativedomainlabel) unless switch.nil?() || switch.ipv4address.nil?() || switch.ipv4address==''
        end
      end
    end
  end
end
