# encoding: utf-8
# license: gpl2p 

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST
module Iof
  module Lookup
    class Location < Base
      Iof::Lookup::SELECTOR.register_member(self, :location)
      def initialize(name)
        super(name,false)
        config.declare_dynamic_key("#{@config_base}database", :string)
#        @db_name=config[:"#{@config_base}database"]
#        @db=Ghun::Base::Blackboard.database.init_database(@db_name.intern)
#        @db.connect() unless @db.connected?()
      end

      def lookup_by_address(key)
        lookup_by({:address => key})
      end

      def lookup_by_device_name(key)
        lookup_by({:device_name => key})
      end

      def lookup_by_label(key)
        lookup_by({:label => key})
      end

      def lookup_by_any(key)
        lookup_by({:address => key, :device_name => key, :label => key})
      end

      def send_to_data_handler(data_handler)
        send_to_data_handler_helper(data_handler,[nil])
      end

    private

      def send_to_data_handler_helper(data_handler,subs)
        subs.each do |s|
          if @location_tree.include?(s)
            @location_tree[s][:locations].each do |l|
              next if l.nil?()
              unless l.include?(:administrative_domain)
                l[:administrative_domain_name]=Array.new()
                ads=Ghun::Base::Blackboard.lookup[:administrative_domain].lookup_by_location(l[:label])
                ads.each do |ad|
                  l[:administrative_domain_name] << data_handler.get_administrative_domain_name(ad)
                end unless ads.nil?()
              end
              data_handler.get_location_name(l)
            end
            send_to_data_handler_helper(data_handler,@location_tree[s][:sub_label]) unless @location_tree[s][:sub_label].nil?()
          end
        end unless subs.nil?()
      end

      def add_location(location)
        new_location=Hash.new()
        new_location[:iom_label]="__id_#{location.id}".intern
        new_location[:iom_super_label]=nil
        new_location[:iom_super_label]="__id_#{location.parent_location_id}".intern unless location.parent_location_id.nil?()
        new_location[:building]=location.building.shortname || location.building.internallabel unless location.building.nil?() || (location.building.shortname.nil?() && location.building.internallabel.nil?())
        new_location[:floor]=location.level.intern unless location.level.nil?()
        new_location[:door]=location.doornumber.intern unless location.doornumber.nil?()
        new_location[:id]=location.place.intern unless location.place.nil?()
        new_location[:label]="___b_#{new_location[:building]}_b_f_#{new_location[:floor]}_f_d_#{new_location[:door]}_d_i_#{new_location[:id]}_i_".intern
        return if new_location[:label]==:"___b__b_f__f_d__d_i__i_"
        unless new_location[:building].nil?()
          new_location[:building_long_name]=location.building.longname
          new_location[:building_short_name]=location.building.shortname || location.building.internallabel
          new_location[:building_label]="___b_#{new_location[:building]}_b_f__f_d__d_i__i_".intern
        end
        unless new_location[:floor].nil?()
          new_location[:floor_number]=location.level
          new_location[:floor_label]="___b_#{new_location[:building]}_b_f_#{new_location[:floor]}_f_d__d_i__i_".intern
        end
        unless new_location[:door].nil?()
          new_location[:door_number]=location.doornumber
          new_location[:door_label]="___b_#{new_location[:building]}_b_f_#{new_location[:floor]}_f_d_#{new_location[:door]}_d_i__i_".intern
        end
        unless new_location[:id].nil?()
          new_location[:id_value]=location.place
          new_location[:id_comment]="received from IO-M"
          new_location[:id_label]="___b_#{new_location[:building]}_b_f_#{new_location[:floor]}_f_d_#{new_location[:door]}_d_i_#{new_location[:id]}_i_".intern
        end

        unless @location_tree.include?(new_location[:iom_super_label])
          @location_tree[new_location[:iom_super_label]]=Hash.new()
          @location_tree[new_location[:iom_super_label]][:locations]=Array.new()
          @location_tree[new_location[:iom_super_label]][:sub_label]=Array.new()
        end
        unless @location_tree.include?(new_location[:iom_label])
          @location_tree[new_location[:iom_label]]=Hash.new()
          @location_tree[new_location[:iom_label]][:locations]=Array.new()
          @location_tree[new_location[:iom_label]][:sub_label]=Array.new()
        end

        @location_tree[new_location[:iom_label]][:locations] << new_location unless @location_tree[new_location[:iom_label]][:locations].include?(new_location)
        @location_tree[new_location[:iom_super_label]][:sub_label] << new_location[:iom_label] unless @location_tree[new_location[:iom_super_label]][:sub_label].include?(new_location[:iom_label])
        new_location.delete(:iom_label)
        new_location.delete(:iom_super_label)
        store_by(:label,new_location[:label],new_location)
      end



      def location_label(location)
        new_location=Hash.new()
        new_location[:building]=location.building.shortname unless location.building_id.nil?() || location.building.shortname.nil?()
        new_location[:floor]=location.level.intern unless location.level.nil?()
        new_location[:door]=location.doornumber.intern unless location.doornumber.nil?()
        new_location[:id]=location.place.intern unless location.place.nil?()
        new_location[:label]="___b_#{new_location[:building]}_b_f_#{new_location[:floor]}_f_d_#{new_location[:door]}_d_i_#{new_location[:id]}_i_".intern
        return new_location[:label]
      end


      def init_data()
        @location_tree=Hash.new()
        ::Location.all.each do |location|
          add_location(location) unless location.nil?()
        end

        ::Switch.all.each do |switch|
          unless switch.location_id.nil?()
            new_location=lookup_by_label(location_label(switch.location))
            store_by(:device_name, switch.name, new_location) unless switch.nil?() || switch.name.nil?() || switch.name==''
            store_by(:address, switch.ipv4address, new_location) unless switch.nil?() || switch.ipv4address.nil?() || switch.ipv4address==''
          end
        end
      end
    end
  end
end
