# encoding: utf-8
# license: gpl3p

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST
module Iof
  module Ontology
    class Base < Ghun::Base::StatefullConnection
      Ghun::Base::Blackboard.config.declare_key(:"ontology.namespace",:array)
      Ghun::Base::Blackboard.config.declare_key(:"ontology.default_namespace",:string)
      def initialize(name,type=:ontology)
        config.declare_dynamic_key(:"ontology.#{name.to_s}.readonly",:bool,false)
        config.declare_dynamic_key(:"ontology.#{name.to_s}.allow_async_access",:bool,false)
        @allow_async_mode=config[:"ontology.#{name.to_s}.allow_async_access"]
        mode=(@allow_async_mode)?(:combined):(:sync)
        super(mode,type,true,Ghun::Log::Source::ONTOLOGY)
        register()
        debug "Starting ontology #{name.to_s} in #{mode} mode"

        @readonly=config[:"ontology.#{name.to_s}.readonly"]
        @name=name

        @prefixes=Hash.new()
        @default_ns=nil
        @default_ns_url=nil
        reload_configuration()
      end
      attr_reader :default_ns, :default_ns_url, :prefixes

      def reload_configuration()
        @prefixes=Hash.new()
        load_prefixes()
      end

      def set_prefix(ns,url)
        if @prefixes.include?(ns.intern) then
          warn "Namespace '#{ns.to_s}' with url '#{url}' already known"
        else
          @prefixes[ns.intern]=url
        end
      end

      def remove_prefix(ns)
        if @prefixes.include?(ns.intern) then
          debug "Removing namespace '#{ns.to_s}' with url '#{@prefixes[ns.intern]}' already known"
          @prefixes.delete(ns.intern)
        else
          warn "Namespace '#{ns.to_s}' not known"
        end
      end

      def url_to_prefix(url)
        @prefixes.each do |prefix,u|
          return prefix if url==u
        end
        return nil
      end

      def create_individual(klass,individual,klass_ns,individual_ns)
        raise AbstractClassError, "Reimplement all methods raising this error in subclasses of Iof::Ontology::Base"
      end

      def exists_individual?(individual,individual_ns)
        raise AbstractClassError, "Reimplement all methods raising this error in subclasses of Iof::Ontology::Base"
      end

      def drop_individual(individual,individual_ns)
        raise AbstractClassError, "Reimplement all methods raising this error in subclasses of Iof::Ontology::Base"
      end

      def has_datatype_property?(individual,property,individual_ns,property_ns)
        raise AbstractClassError, "Reimplement all methods raising this error in subclasses of Iof::Ontology::Base"
      end

      def has_object_property?(individual,property,individual_ns,property_ns)
        raise AbstractClassError, "Reimplement all methods raising this error in subclasses of Iof::Ontology::Base"
      end

      def get_all_datatype_properties(individual,blacklist,individual_ns,list_namespaces,show_unknown_nodes)
        raise AbstractClassError, "Reimplement all methods raising this error in subclasses of Iof::Ontology::Base"
      end

      def get_all_object_properties(individual,blacklist,individual_ns,list_namespaces,show_unknown_nodes)
        raise AbstractClassError, "Reimplement all methods raising this error in subclasses of Iof::Ontology::Base"
      end

      def drop_all_properties(individual,individual_ns)
        raise AbstractClassError, "Reimplement all methods raising this error in subclasses of Iof::Ontology::Base"
      end

      def get_object_property(individual,property,individual_ns,property_ns,list_namespaces,show_unknown_nodes)
        raise AbstractClassError, "Reimplement all methods raising this error in subclasses of Iof::Ontology::Base"
      end

      def get_datatype_property(individual,property,individual_ns,property_ns)
        raise AbstractClassError, "Reimplement all methods raising this error in subclasses of Iof::Ontology::Base"
      end

      def drop_property(individual,property,individual_ns,property_ns)
        raise AbstractClassError, "Reimplement all methods raising this error in subclasses of Iof::Ontology::Base"
      end

      def drop_object_property(individual,property,individual_ns,property_ns)
        raise AbstractClassError, "Reimplement all methods raising this error in subclasses of Iof::Ontology::Base"
      end

      def drop_datatype_property(individual,property,individual_ns,property_ns)
        raise AbstractClassError, "Reimplement all methods raising this error in subclasses of Iof::Ontology::Base"
      end

      def create_object_property(individual,property,target,individual_ns,property_ns,target_ns)
        raise AbstractClassError, "Reimplement all methods raising this error in subclasses of Iof::Ontology::Base"
      end

      def create_datatype_property(individual,property,value,individual_ns,property_ns)
        raise AbstractClassError, "Reimplement all methods raising this error in subclasses of Iof::Ontology::Base"
      end

      def convert_result_to_table(input,remove_internal=true)
        header=Array.new()
        data=Array.new()
        header_to_column=Hash.new()
        input.each do |row|
          row.each do |key,value|
            next if remove_internal && key.to_s.match(/^__/)
            next if header.include?(key.to_s)
            header << key.to_s
            header_to_column[key]=header.length()-1
          end
        end
        input.each do |row|
          converted_row=Array.new(header.length())
          row.each do |key,value|
            next if remove_internal && key.to_s.match(/^__/)
            if remove_internal && !row["__unknown_#{key.to_s}".intern]
              #add prefix to value when removing internal columns
              v="#{row["__ns_#{key.to_s}".intern]}:#{value}"
            elsif remove_internal && row["__unknown_#{key.to_s}".intern]
              #value belongs to unknown namespace or is a literal value
              #value should be complete
              v=value
            else
              #When not removing internal columns value remain unchanged
              #user will be able to construct valid IRIs
              v=value
            end
            converted_row[header_to_column[key]]=v
          end
          data << converted_row
        end
        result={:header => header, :data => data}
        return result
      end

    private

      def load_prefixes()
        namespaces=config[:"ontology.namespace"]
        default=config[:"ontology.default_namespace"]
        namespaces.each do |ns|
          config.declare_dynamic_key("ontology.namespace.#{ns.to_s}".intern,:string)
          set_prefix(ns, config["ontology.namespace.#{ns.to_s}".intern])
        end
        @default_ns=default.intern
        @default_ns_url=@prefixes[default.intern]
      end

      def build_query(query)
        expanded_query=query.clone()
        @prefixes.each do |ns,url|
          expanded_query.gsub!(/#{ns.to_s()}:([^\.} ]*)/,"<#{url}"+'\1> ')
        end
        return expanded_query
      end

      def format_result(result_raw,list_namespaces,show_datatype_properties,show_anonymous_nodes)
        list_namespaces=@prefixes.keys if list_namespaces.nil?() || list_namespaces.empty?()
        return nil unless result_raw
        debug "Formatting result"
        result=Array.new()
        result_raw.each do |r|
          abort=false
          result_line=Hash.new
          r.each do |field,value|
            next if value.nil?()
            found=false
            @prefixes.each do |prefix,url|
              if value.match(/^#{url}/) then
                found=true
                if list_namespaces.include?(prefix) then
                  value.gsub!(/^#{url}/,'')
                  result_line[field]=value
                  result_line["__ns_#{field.to_s}".intern]=prefix
                  result_line["__unknown_#{field.to_s}".intern]=false
                else
                  debug "Value '#{prefix}:#{value}' matched by namespace filter"
                  abort=true
                  break
                end
              end
            end
            break if abort
            if show_datatype_properties || show_anonymous_nodes then
              #FIXME Implement proper anonymous and datatype handling
              debug "Adding result '#{value}' with unknown namespace to result"
              debug "Implement proper anonymous and datatype handling, example line: #{result_line}"
              result_line[field]=value
              result_line["__unknown_#{field.to_s}".intern]=true
            else
              debug "Result '#{value}' contains unknown namespace"
              abort=true
              break
            end unless found
          end
          next if abort
          result << result_line unless result_line.nil?() || result_line.empty?()
        end unless result_raw.nil?()
        return result
      end
    end
  end
end
