# encoding: utf-8
# license: gpl2p

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST
module Iof
  module Ontology
    class Handler < Ghun::Base::ConnectionHandler
    ENGINE_SELECTOR=Ghun::Base::Selector.new("OntologyEngine",[:engine],false,Ghun::Log::Source::ONTOLOGY,Ghun::Log::Type::BASE)
      def initialize()
        super(Ghun::Log::Source::ONTOLOGY)
      end

      def init_ontology(name)
        #ontologies are always started in combined mode
        unless self[name.intern].nil?()
          return self[name.intern]
        end
        config.declare_dynamic_key("ontology.#{name.to_s}.engine".intern,:string)
        engine=config["ontology.#{name.to_s}.engine".intern]
        ontology_class=ENGINE_SELECTOR.select_member(engine.intern)
        raise UnknownEngineError, "Unknown ontology backend #{engine}" if ontology_class.nil?()
        ontology=ontology_class.new(name.intern)
        self.register_member(name.intern, ontology)
        ontology.connect unless ontology.connected?()
        return ontology
      rescue => e
        error "Failed to get engine for ontology with name '#{name.to_s}'", e
        raise
      end

      def destroy_ontology(name)
        if @members.include?(name.intern) && !@members[name.intern].nil?()
          @members[name.intern].disconnect() if @members[name.intern].connected?()
          @members[name.intern].stop_connection if @members[name.intern].async_mode
          @members.delete(name.intern)
        end
      end

      def get_ontology(name)
        self[name.intern]
      end

      def self.register_instance()
        Ghun::Base::Blackboard.ontology=Iof::Ontology::Handler.new() if Ghun::Base::Blackboard.ontology.nil?()
      end
    end
  end
end
Iof::Ontology::Handler.register_instance()
