# encoding: utf-8
# license: gpl2p

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST
module Iof
  module Parser
    SELECTOR=Ghun::Base::Selector.new("Parser",[:vendor,:type,:connection_type,:connection_version],true,Ghun::Log::Source::PARSER)
    class Base < Ghun::Base::Module

        @@l2eth_suffix="eth"
        @@l3v4_suffix="ipv4"
        @@l3v6_suffix="ipv6"


      def initialize(target,target_handler)
        super(Ghun::Log::Source::PARSER)
        @target=target
        @data_handler=nil
        @target_handler=target_handler
      end

      #step is one of :preparse, :parse, :postparse
      def parse_command(label,step)
        l=label.intern
        c=@target.commands[l]
        r=@target.results[l]
        m="parse_#{l.to_s}".intern
        raise UnexpectedResultError, "No command or no result with label #{l} found" if c.nil?() || r.nil?()
        self.send(m,l,c,r,step)
      end

      def preparse()
        debug "#{self.class}: Preparsing target #{@target.description()}"
        return true
      end

      def parse(data_handler)
        @data_handler=data_handler
        debug "#{self.class}: Parsing target #{@target.description()}"
        return true
      end

      def postparse()
        debug "#{self.class}: Postparsing target #{@target.description()}"
        prepare_location()
        prepare_administrative_domain()
        return true
      end

      def prepare_location()
        @target.special_mutex.synchronize {
          @target.special[:fallback_location]=nil unless @target.special.include?(:fallback_location)
          iom_old_label=nil
          @target.names.each do |n|
            l=Ghun::Base::Blackboard.lookup[:location_label].lookup_by_device_name(n)
            next if l.nil?()
            if iom_old_label.nil?()
              iom_old_label=l
            elsif !iom_old_label.nil?() && iom_old_label!=l
              warn "Got conflicting old location labels '#{l}' and #{iom_old_label} for target #{description}"
            end
          end
          @target.ipv4_addresses.each do |a|
            l=Ghun::Base::Blackboard.lookup[:location_label].lookup_by_address(a)
            next if l.nil?()
            if iom_old_label.nil?()
              iom_old_label=l
            elsif !iom_old_label.nil?() && iom_old_label!=l
              warn "Got conflicting old location labels '#{l}' and #{iom_old_label} for target #{description}"
            end
          end
          @target.ipv6_addresses.each do |a|
            l=Ghun::Base::Blackboard.lookup[:location_label].lookup_by_address(a)
            next if l.nil?()
            if iom_old_label.nil?()
              iom_old_label=l
            elsif !iom_old_label.nil?() && iom_old_label!=l
              warn "Got conflicting old location labels '#{l}' and #{iom_old_label} for target #{description}"
            end
          end
          iom_location=nil
          @target.names.each do |n|
            l=Ghun::Base::Blackboard.lookup[:location].lookup_by_device_name(n)
            next if l.nil?()
            if iom_location.nil?()
              iom_location=l
            elsif !iom_location.nil?() && iom_location!=iom_location
              warn "Got conflicting locations '#{l}' and #{iom_location} for target #{description}"
            end
          end
          @target.ipv4_addresses.each do |a|
            l=Ghun::Base::Blackboard.lookup[:location].lookup_by_device_name(a)
            next if l.nil?()
            if iom_location.nil?()
              iom_location=l
            elsif !iom_location.nil?() && iom_location!=iom_location
              warn "Got conflicting locations '#{l}' and #{iom_location} for target #{description}"
            end
          end
          @target.ipv6_addresses.each do |a|
            l=Ghun::Base::Blackboard.lookup[:location].lookup_by_device_name(a)
            next if l.nil?()
            if iom_location.nil?()
              iom_location=l
            elsif !iom_location.nil?() && iom_location!=iom_location
              warn "Got conflicting locations '#{l}' and #{iom_location} for target #{description}"
            end
          end
          if  @target.special[:fallback_location].nil?()
            if !iom_old_label.nil?() && !iom_location.nil?()
              @target.special[:location]=iom_location
              @target.special[:location_old_label]=iom_old_label
            end
          elsif iom_old_label.nil?() && iom_location.nil?()
            #no auto generated label and no location; maybe new device
            @target.special[:location]=@target.special[:fallback_location]
            @target.special[:location_old_label]=@target.special[:fallback_location][:label]
          elsif !iom_old_label.nil?() && iom_location.nil?()
            #auto generated label but no location; that should not happen; reset location
            @target.special[:location]=@target.special[:fallback_location]
            @target.special[:location_old_label]=@target.special[:fallback_location][:label]
          elsif iom_old_label.nil?() && !iom_location.nil?()
            #no auto generated label but user assigned location; assuming label belongs to location
            @target.special[:location]=iom_location
            @target.special[:location_old_label]=@target.special[:fallback_location][:label]
         elsif !iom_old_label.nil?() && !iom_location.nil?() && iom_old_label!=@target.special[:fallback_location][:label]
            #device has old label and location, but old label and new label differ, maybe renamed device or location change
            @target.special[:location]=@target.special[:fallback_location]
            @target.special[:location_old_label]=@target.special[:fallback_location][:label]
          elsif !iom_old_label.nil?() && !iom_location.nil?() && iom_old_label==@target.special[:fallback_location][:label]
            #device has old label and location and nothing changed
            @target.special[:location]=iom_location
            @target.special[:location_old_label]=iom_old_label
          end
          @target.special[:location_name]=@data_handler.get_location_name(@target.special[:location]) if @target.special.include?(:location)
        }
      end

      def prepare_administrative_domain()
        @target.special_mutex.synchronize {
          @target.special[:fallback_administrative_domomain]=nil unless @target.special.include?(:fallback_administrative_domain)
          iom_old_label=nil
          @target.names.each do |n|
            l=Ghun::Base::Blackboard.lookup[:administrative_domain_label].lookup_by_device_name(n)
            next if l.nil?()
            if iom_old_label.nil?()
              iom_old_label=l
            elsif !iom_old_label.nil?() && iom_old_label!=l
              warn "Got conflicting old administrative domain labels '#{l}' and #{iom_old_label} for target #{description}"
            end
          end
          @target.ipv4_addresses.each do |a|
            l=Ghun::Base::Blackboard.lookup[:administrative_domain_label].lookup_by_address(a)
            next if l.nil?()
            if iom_old_label.nil?()
              iom_old_label=l
            elsif !iom_old_label.nil?() && iom_old_label!=l
              warn "Got conflicting old administrative domain labels '#{l}' and #{iom_old_label} for target #{description}"
            end
          end
          @target.ipv6_addresses.each do |a|
            l=Ghun::Base::Blackboard.lookup[:administrative_domain_label].lookup_by_address(a)
            next if l.nil?()
            if iom_old_label.nil?()
              iom_old_label=l
            elsif !iom_old_label.nil?() && iom_old_label!=l
              warn "Got conflicting old administrative domain labels '#{l}' and #{iom_old_label} for target #{description}"
            end
          end
          iom_administrative_domain=nil
          @target.names.each do |n|
            l=Ghun::Base::Blackboard.lookup[:administrative_domain].lookup_by_device_name(n)
            next if l.nil?()
            if iom_administrative_domain.nil?()
              iom_administrative_domain=l
            elsif !iom_administrative_domain.nil?() && iom_administrative_domain!=iom_administrative_domain
              warn "Got conflicting administrative domains '#{l}' and #{iom_administrative_domain} for target #{description}"
            end
          end
          @target.ipv4_addresses.each do |a|
            l=Ghun::Base::Blackboard.lookup[:administrative_domain].lookup_by_device_name(a)
            next if l.nil?()
            if iom_administrative_domain.nil?()
              iom_administrative_domain=l
            elsif !iom_administrative_domain.nil?() && iom_administrative_domain!=iom_administrative_domain
              warn "Got conflicting administrative_domains '#{l}' and #{iom_administrative_domain} for target #{description}"
            end
          end
          @target.ipv6_addresses.each do |a|
            l=Ghun::Base::Blackboard.lookup[:administrative_domain].lookup_by_device_name(a)
            next if l.nil?()
            if iom_administrative_domain.nil?()
              iom_administrative_domain=l
            elsif !iom_administrative_domain.nil?() && iom_administrative_domain!=iom_administrative_domain
              warn "Got conflicting administrative_domains '#{l}' and #{iom_administrative_domain} for target #{description}"
            end
          end
          if  @target.special[:fallback_administrative_domain].nil?()
            if !iom_old_label.nil?() && !iom_administrative_domain.nil?()
              @target.special[:administrative_domain]=iom_administrative_domain
              @target.special[:administrative_domain_old_label]=iom_old_label
            end
          elsif iom_old_label.nil?() && iom_administrative_domain.nil?()
            #no auto generated label and no administrative_domain; maybe new device
            @target.special[:administrative_domain]=@target.special[:fallback_administrative_domain]
            @target.special[:administrative_domain_old_label]=@target.special[:fallback_administrative_domain][:label]
          elsif !iom_old_label.nil?() && iom_administrative_domain.nil?()
            #auto generated label but no administrative domain; that should not happen; reset administrative domain
            @target.special[:administrative_domain]=@target.special[:fallback_administrative_domain]
            @target.special[:administrative_domain_old_label]=@target.special[:fallback_administrative_domain][:label]
          elsif iom_old_label.nil?() && !iom_administrative_domain.nil?()
            #no auto generated label but user assigned administrative_domain; assuming label belongs to administrative_domain
            @target.special[:administrative_domain]=iom_administrative_domain
            @target.special[:administrative_domain_old_label]=@target.special[:fallback_administrative_domain][:label]
          elsif !iom_old_label.nil?() && !iom_administrative_domain.nil?() && iom_old_label!=@target.special[:fallback_administrative_domain][:label]
            #device has old label and administrative_domain, but old label and new label differ, maybe renamed device or administrative_domain change
            @target.special[:administrative_domain]=@target.special[:fallback_administrative_domain]
            @target.special[:administrative_domain_old_label]=@target.special[:fallback_administrative_domain][:label]
          elsif !iom_old_label.nil?() && !iom_administrative_domain.nil?() && iom_old_label==@target.special[:fallback_administrative_domain][:label]
            #device has old label and administrative_domain and nothing changed
            @target.special[:administrative_domain]=iom_administrative_domain
            @target.special[:administrative_domain_old_label]=iom_old_label
          end
          @target.special[:administrative_domain_name]=@data_handler.get_administrative_domain_name(@target.special[:administrative_domain]) if @target.special.include?(:administrative_domain)
        }
      end

    end

    class CLIBase < Base
      def initialize(target,target_handler)
        super(target,target_handler)
      end
    end

  end
end
