# encoding: utf-8
# license: gpl2p

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST

module Iof
  module Parser

   class CDPBase < Base
      Iof::Parser::SELECTOR.register_member(self,[:cisco,:cdp_ap,:none,nil])
      Iof::Parser::SELECTOR.register_member(self,[:cisco,:cdp_phone,:none,nil])
      Iof::Parser::SELECTOR.register_member(self,[:cisco,:cdp_switch,:none,nil])
      Iof::Parser::SELECTOR.register_member(self,[:mikrotik,:cdp_switch,:none,nil])
      def initialize(target,target_handler)
        super(target,target_handler)
        @components=Array.new()
        @neighbors=Array.new()
        @connections=Array.new()
        @interfaces=Array.new()
        @downstream_name=nil

      end

      def preparse()
        unless super()
          @target.status_preparse=false
          return false
        end
      rescue => e
        error "Failed to preparse target #{@target.description()}", e
        @target.status_preparse=false
        return false
      end

      def parse(data_handler)
        unless super(data_handler)
          @target.status_parse=false
          return false
        end
        case @target.device_type
        when :cdp_ap
          handle_ap(:parse)
        when :cdp_switch
          handle_switch(:parse)
        when :cdp_phone
          handle_phone(:parse)
        end
        return true
      rescue => e
        error "Failed to parse target #{@target.description()}", e
        @target.status_preparse=false
        return false
      end

      def postparse()
        unless super()
          @target.status_postparse=false
          return false
        end
        @store_mac_neighbors=false
        handle_incoming_macs()
        handle_incoming_power()

        @components[0][:no_old_administrative_domain_internal_label]=@target.special[:administrative_domain_old_label]
        @components[0][:no_assigned_administrative_domain]=@target.special[:administrative_domain_name]
        @components[0][:no_old_location_internal_label]=@target.special[:location_old_label]
        @components[0][:no_physical_location]=@target.special[:location_name]

        send_results()
        return true
      rescue => e
        error "Failed to postparse target #{@target.description()}", e
        @target.status_parse=false
        return false
      end

    private

      def handle_switch(step)
        #handle mac based neighbors for switches
        @store_mac_neighbors=true
        component=Iof::Data::NO::ManagedNetworkComponent.new()
        component.category=1
        @components[0]=component
        component.name=@target.name
        component[:no_identifier]=@target.identifier
        component[:no_vendor_name]=@target.device_vendor if @target.device_vendor
        component[:no_switch]=true
        l1_v=Iof::Data::NO::Layer1Interface.new()
        l1_v.name="l1_virt"
        l1_v[:no_interface_type]=:virtual
        l2_v=Iof::Data::NO::EthernetInterface.new()
        l2_v.name="l2_eth_virt"
        l1_v[:no_ethernet_interface]=l2_v
        l3_v4=Iof::Data::NO::IPv4Interface.new()
        l3_v4.name="l3_ipv4_virt"
        l3_v6=Iof::Data::NO::IPv6Interface.new()
        l3_v6.name="l3_ipv6_virt"
        with_v4=false
        with_v6=false

        @target.mac_addresses.each do |a|
          l2_v[:no_mac_address]=@data_handler.get_mac_address_name(a)
        end
        @target.ipv4_addresses.each do |a|
          with_v4=true
          l3_v4[:no_ipv4_address]=@data_handler.get_ipv4_address_name(a)
        end
        @target.ipv6_addresses.each do |a|
          with_v6=true
          l3_v6[:no_ipv6_address]=@data_handler.get_ipv6_address_name(a)
        end
        if with_v4  || with_v6
          component[:no_simple_layer1_interface]=l1_v
          l2_v[:no_ipv4_interface]=l3_v4 if with_v4
          l2_v[:no_ipv6_interface]=l3_v6 if with_v6
          @interfaces << l1_v.name.intern
        end

        #TODO handle propagated vlans
        @target.special[:cdp_sightings].each do |neighbor,sightings|
          sightings.each do |sighting|
            l1=Iof::Data::NO::Layer1Interface.new()
            l1.name=sighting[:interface]
            l1[:no_interface_type]=:physical
            l2=Iof::Data::NO::EthernetInterface.new()
            l2.name="l2_eth"
            l1[:no_ethernet_interface]=l2
            unless @interfaces.include?(l1.name.intern)
              component[:no_simple_layer1_interface]=l1
              @interfaces << l1.name.intern
            end
          end unless sightings.nil?()
        end

        l1=Iof::Data::NO::Layer1Interface.new()
        l1.name="downstream"
        l1[:no_interface_type]=:physical
        l2=Iof::Data::NO::EthernetInterface.new()
        l2.name="l2_eth"
        l1[:no_ethernet_interface]=l2
        unless @interfaces.include?(l1.name.intern)
          component[:no_simple_layer1_interface]=l1
          @interfaces << l1.name.intern
        end
        @downstream_name="#{component.name}___#{l1.name}"
      end

      def handle_ap(step)
        #ignore mac neighbors for access point as the tend to change ap assosiationoften during snapshot
        @store_mac_neighbors=false
        component=Iof::Data::NO::ManagedNetworkComponent.new()
        component.category=1
        @components[0]=component
        component.name=@target.name
        component[:no_identifier]=@target.identifier
        component[:no_vendor_name]=@target.device_vendor if @target.device_vendor
        component[:no_access_point]=true
        l1_v=Iof::Data::NO::Layer1Interface.new()
        l1_v.name="l1_virt"
        l1_v[:no_interface_type]=:virtual
        l2_v=Iof::Data::NO::EthernetInterface.new()
        l2_v.name="l2_eth_virt"
        l1_v[:no_ethernet_interface]=l2_v
        l3_v4=Iof::Data::NO::IPv4Interface.new()
        l3_v4.name="l3_ipv4_virt"
        l3_v6=Iof::Data::NO::IPv6Interface.new()
        l3_v6.name="l3_ipv6_virt"
        with_v4=false
        with_v6=false

        @target.mac_addresses.each do |a|
          l2_v[:no_mac_address]=@data_handler.get_mac_address_name(a)
        end
        @target.ipv4_addresses.each do |a|
          with_v4=true
          l3_v4[:no_ipv4_address]=@data_handler.get_ipv4_address_name(a)
        end
        @target.ipv6_addresses.each do |a|
          with_v6=true
          l3_v6[:no_ipv6_address]=@data_handler.get_ipv6_address_name(a)
        end
        if with_v4  || with_v6
          component[:no_simple_layer1_interface]=l1_v
          l2_v[:no_ipv4_interface]=l3_v4 if with_v4
          l2_v[:no_ipv6_interface]=l3_v6 if with_v6
          @interfaces << l1_v.name.intern
        end

        #TODO handle propagated vlans
        @target.special[:cdp_sightings].each do |neighbor,sightings|
          sightings.each do |sighting|
            l1=Iof::Data::NO::Layer1Interface.new()
            l1.name=sighting[:interface]
            l1[:no_interface_type]=:physical
            l2=Iof::Data::NO::EthernetInterface.new()
            l2.name="l2_eth"
            l1[:no_ethernet_interface]=l2
            unless @interfaces.include?(l1.name.intern)
              component[:no_simple_layer1_interface]=l1
              @interfaces << l1.name.intern
            end
          end unless sightings.nil?()
        end

        l1=Iof::Data::NO::Layer1Interface.new()
        l1.name="WiFi"
        l1[:no_interface_type]=:physical
        l2=Iof::Data::NO::EthernetInterface.new()
        l2.name="l2_eth"
        l1[:no_ethernet_interface]=l2
        unless @interfaces.include?(l1.name.intern)
          component[:no_simple_layer1_interface]=l1
          @interfaces << l1.name.intern
        end
        @downstream_name="#{component.name}___#{l1.name}"
      end

      def handle_phone(step)
        #handle mac based neighbors for VoIP phones
        @store_mac_neighbors=true
        component=Iof::Data::NO::ManagedNetworkComponent.new()
        component.category=1
        @components[0]=component
        component.name=@target.name
        component[:no_identifier]=@target.identifier
        component[:no_vendor_name]=@target.device_vendor if @target.device_vendor
        component[:no_phone]=true
        l1_v=Iof::Data::NO::Layer1Interface.new()
        l1_v.name="l1_virt"
        l1_v[:no_interface_type]=:virtual
        l2_v=Iof::Data::NO::EthernetInterface.new()
        l2_v.name="l2_eth_virt"
        l1_v[:no_ethernet_interface]=l2_v
        l3_v4=Iof::Data::NO::IPv4Interface.new()
        l3_v4.name="l3_ipv4_virt"
        l3_v6=Iof::Data::NO::IPv6Interface.new()
        l3_v6.name="l3_ipv6_virt"
        with_v4=false
        with_v6=false

        @target.mac_addresses.each do |a|
          l2_v[:no_mac_address]=@data_handler.get_mac_address_name(a)
        end
        @target.ipv4_addresses.each do |a|
          with_v4=true
          l3_v4[:no_ipv4_address]=@data_handler.get_ipv4_address_name(a)
        end
        @target.ipv6_addresses.each do |a|
          with_v6=true
          l3_v6[:no_ipv6_address]=@data_handler.get_ipv6_address_name(a)
        end
        if with_v4  || with_v6
          component[:no_simple_layer1_interface]=l1_v
          l2_v[:no_ipv4_interface]=l3_v4 if with_v4
          l2_v[:no_ipv6_interface]=l3_v6 if with_v6
          @interfaces << l1_v.name.intern
        end

        #TODO handle propagated vlans
        @target.special[:cdp_sightings].each do |neighbor,sightings|
          sightings.each do |sighting|
            l1=Iof::Data::NO::Layer1Interface.new()
            l1.name=sighting[:interface]
            l1[:no_interface_type]=:physical
            l2=Iof::Data::NO::EthernetInterface.new()
            l2.name="l2_eth"
            l1[:no_ethernet_interface]=l2
            unless @interfaces.include?(l1.name.intern)
              component[:no_simple_layer1_interface]=l1
              @interfaces << l1.name.intern
            end
          end unless sightings.nil?()
        end

        l1=Iof::Data::NO::Layer1Interface.new()
        l1.name="Port2"
        l1[:no_interface_type]=:physical
        l2=Iof::Data::NO::EthernetInterface.new()
        l2.name="l2_eth"
        l1[:no_ethernet_interface]=l2
        unless @interfaces.include?(l1.name.intern)
          component[:no_simple_layer1_interface]=l1
          @interfaces << l1.name.intern
        end
        @downstream_name="#{component.name}___#{l1.name}"
      end

      def handle_incoming_macs()
        if @store_mac_neighbors
          debug "Storing mac neighbors for #{@target.description}"
        else
          debug "Not storing mac neighbors for #{@target.description}"
          return nil
        end
        macs=@target.special[:mac_addresses]
        macs=macs.uniq.compact.sort() unless macs.nil?()
        return if macs.nil?() || macs.empty?()
        #create neighbors and connections for mac only neighbors
        if macs.nil?() || macs.size() <= 0
          debug "No mac neighbors to create at interface on device #{@target.description()}"
        elsif macs.size==1
          #direct connection
          mac=macs[0]
          me=@downstream_name
          neighbor=Iof::Data::NO::ManagedNetworkComponent.new()
          neighbor.category=3
          neighbor.name="host_#{mac.to_s}"
          l2=Iof::Data::NO::EthernetInterface.new()
          l2.name="l2_eth"
          l2[:no_mac_address]=@data_handler.get_mac_address_name(mac.to_s)
          neighbor[:no_endpoint]=true
          #FIXME check for safety via @target_handler
          neighbor[:no_identifier]=mac

          #TODO handle vlans
          l1=Iof::Data::NO::Layer1Interface.new()
          l1.name="l1"
          l1[:no_interface_type]=:physical
          l1[:no_ethernet_interface]=l2
          neighbor[:no_simple_layer1_interface]=l1
          @neighbors << neighbor
          connection=Iof::Data::NO::IsConnectedTo.new()
          connection.subject=me.clone()
          connection.object="#{neighbor.name}___#{l1.name}"
          @connections << connection
        else
          #create unmanaged switch and connect mac neighbors
          me=@downstream_name
          switch=Iof::Data::NO::UnmanagedNetworkComponent.new()
          neighbor.category=2
          switch.name="umnc_at_#{me.sub(/___/,'_')}"
          switch[:no_switch]=true
          l1=Iof::Data::NO::Layer1Interface.new()
          l1[:no_interface_type]=:physical
          l1.name="upstream"
          switch[:no_simple_layer1_interface]=l1
          @components << switch
          connection=Iof::Data::NO::IsConnectedTo.new()
          connection.subject=me.clone()
          connection.object="#{switch.name}___#{l1.name}"
          @connections << connection
          macs.each do |m|
            l1_sw=Iof::Data::NO::Layer1Interface.new()
            l1_sw[:no_interface_type]=:physical
            l1_sw.name="l1_to_#{m}"
            switch[:no_simple_layer1_interface]=l1_sw
            sw="#{switch.name}___#{l1_sw.name}"

            neighbor=Iof::Data::NO::ManagedNetworkComponent.new()
            neighbor.category=3
            neighbor.name="host_#{m.to_s}"
            l2=Iof::Data::NO::EthernetInterface.new()
            l2.name="l2_eth"
            l2[:no_mac_address]=@data_handler.get_mac_address_name(m.to_s)
            neighbor[:no_endpoint]=true
            #FIXME check for safety via @target_handler
            neighbor[:no_identifier]=m

            #TODO handle vlans

            l1=Iof::Data::NO::Layer1Interface.new()
            l1.name="l1"
            l1[:no_interface_type]=:physical
            l1[:no_ethernet_interface]=l2
            neighbor[:no_simple_layer1_interface]=l1
            @neighbors << neighbor
            connection=Iof::Data::NO::IsConnectedTo.new()
            connection.subject=sw
            connection.object="#{neighbor.name}___#{l1.name}"
            @connections << connection
          end
        end
      end

      def handle_incoming_power()
        c=@components[0]
        @target.special_mutex.synchronize {
          c[:no_poe_capable]=@target.special[:poe_capable] if @target.special[:poe_capable]
          c[:no_poe_powered]=@target.special[:poe_powered] if @target.special[:poe_powered]
          c[:no_poe_power_consumption]=@target.special[:poe_power_consumption] if @target.special[:poe_power_consumption]
          c[:no_poe_powered_by]=@target.special[:poe_powered_by] if @target.special[:poe_powered_by]
        }
     end

      def send_results
        debug "Sending results to data handler"
        @components.each do |c|
          debug "Sending component #{c.name}"
          @data_handler.set_component(c,c.category)
        end
        @neighbors.each do |n|
          debug "Sending neighbor #{n.name}"
          @data_handler.set_component(n,n.category)
        end
        @connections.each do |c|
          debug "Sending connection #{c.subject}<->#{c.object}"
          @data_handler.set_connection(c)
        end
        @components=nil
        @neighbors=nil
        @connections=nil
      end
    end
  end
end
