# encoding: utf-8
# license: gpl2p

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST
module Iof
  module Query
    class Base < Ghun::Base::Module
      @@ontology_mutex=Monitor.new()

      #FIXME remove ontology_file
      def initialize(name,required_tables,with_mapping=false,ontology_file=nil)
        super(Ghun::Log::Source::QUERY)
        @timer=Ghun::Timing::Timer.new(Ghun::Log::Source::QUERY)
        @name=name
        @required_tables=required_tables
        @with_mapping=with_mapping
        start_ontology()
      end
      attr_reader :ontology, :mapper, :lookup

      def start_ontology()
        @timer.register(:reasoner,"Reasoner startup")
        @timer.start(:reasoner)
        @ontology=Ghun::Base::Blackboard.ontology.init_ontology(:query)
        @ns=@ontology.default_ns
        @ns_url=@ontology.default_ns_url
        @mapper=nil
        if @with_mapping then
          raise "Mapping is currently not supported"
       end
        @timer.stop(:reasoner)
        @timer.output(:reasoner)
        #TODO migrate to singleton like behavior
        @lookup=Iof::Query::Lookup.new(@ontology)
        @lookup.register_query_module(@name, @required_tables)
        @lookup.generate_lookup_tables()
      end

      def restart_ontology()
        finish()
        start_ontology
      end

      def finish()
        Ghun::Base::Blackboard.ontology.destroy_ontology(@name)
        @ontology=nil
        @ns=nil
        @ns_url=nil
        @lookup=nil
      end
    end
  end
end
