# encoding: utf-8
# license: gpl2p 

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST
require 'graphviz'

module Iof
  module Query
    class Graphviz < Base
      def initialize()
        super(:graphviz_visualizer,[])
        @output_dir=File.join(Ghun::Base::Blackboard.local.data_path,"graphviz")
        @output_format=[:dot,:eps,:png,:svg]
        #@output_engine=[:dot,:twopi,:circo,:neato,:fdp,:sfdp]
        #sfdp needs graphviz with triangulation
        @output_engine=[:dot]#,:twopi,:circo,:neato,:fdp]
      end

      def query(component,mode,file_base=File.join(@output_dir,component),opts=nil)
        if opts.nil?() then
          options=Hash.new()
        else
          options=opts
        end
        [:stop,:hide,:show_components,:depth].each do |o|
          case o
          when :depth
            options[o]=-1
          when :stop
            if mode==:component_full_detail then
              options[o]=[:isConnectedTo,:hasLayer1Connection]
            else
              options[o]=[]
            end
          when :hide
            options[o]=[]
          when :show_components
            options[o]=[:Switch]
          end if options[o].nil?()
        end
        graph=Hash.new()
        puts "Got options #{options.inspect}"
        case mode
        when :component_full_detail
          graph[:default]=::GraphViz.new(component)
          query_component_full_detail(graph[:default],component,options[:stop],options[:hide])
        when :component_map_with_interfaces
          graph[:default]=::GraphViz.new(component, :type => "graph" )
          query_component_map_with_interfaces(graph[:default],component,options[:stop],options[:hide],options[:show_components],options[:depth])
        when :component_map_with_interfaces_splitted_v
          graph[:default]=::GraphViz.new(component, :type => "graph" )
          query_component_map_with_interfaces_splitted_v(graph[:default],component,options[:stop],options[:hide],options[:show_components],options[:depth])
        when :component_map
          graph[:default]=::GraphViz.new("#{component}_simple", :type => "graph" )
          query_component_map(graph[:default],component,options[:stop],options[:hide],options[:show_components],options[:depth],:hasLayer1Connection)
          graph[:simple]=::GraphViz.new("#{component}_simple", :type => "graph" )
          query_component_map(graph[:simple],component,options[:stop],options[:hide],options[:show_components],options[:depth],:hasSimpleLayer1Connection)
          graph[:mc]=::GraphViz.new("#{component}_mc", :type => "graph" )
          query_component_map(graph[:mc],component,options[:stop],options[:hide],options[:show_components],options[:depth],:hasMultiChassisLayer1Connection)
        end

        graph.each do |label,g|
          write_files(g,"#{file_base}_#{label}")
        end
      end


    private

      NODE_COMPONENT_STYLE={ :shape => "box", :fontsize => 10 }
      NODE_COMPONENT_WITH_INTERFACE_STYLE={ :shape => "record", :fontsize => 10 }
      NODE_OP_STYLE={}
      NODE_DP_STYLE={}


      EDGE_CONNECTION_NONE_DETAIL_STYLE={:dir => "none"}
      EDGE_CONNECTION_INTERFACES_DETAIL_STYLE={:dir => "none"}

      EDGE_CONNECTION_FULL_DETAIL_STYLE=EDGE_CONNECTION_INTERFACES_DETAIL_STYLE

      EDGE_OP_STYLE={}
      EDGE_DP_STYLE={}

      def add_node(graph,name,klass,description,style)
        n=name
        if name.nil?() && description.nil?() && (klass.nil?() || klass.empty?()) then
          error "Could not create node without name and description"
          return
        end
        n=Java::Util::UUID.randomUUID.to_string() if n.nil?()
        d=description
        if d.nil?() && !klass.nil?() && !klass.empty?()then
          if name.nil?() then
            d=klass.join("; ")
          else
            d="#{n}\\n#{klass.join("; ")}"
          end
        elsif !d.nil?() && !klass.nil?() && !klass.empty?() then
            d+="\\n#{klass.join("; ")}"
        end
        s=style.dup
        s[:label]=d unless d.nil?()
        graph.add_nodes(name,s)
        return n
      end

      def add_edge(graph,src,dst,description,style)
        s=style.dup
        s[:label]=description unless description.nil?()
        graph.add_edges(src,dst,s)
      end

      def add_record_node(graph,name,ports,description,style)
        s=style.dup
        s[:label]="{#{(description.nil?())?(name):(description)} |{ "
        first=true
        ports.each do |p|
          s[:label]+="|" unless first
          s[:label]+="<#{p.gsub(/\//,'_')}> #{p}"
          first=false
        end
        s[:label]+="}}"
        graph.add_nodes(name,s)
      end

      def add_record_edge(graph,src_node,src_port,dst_node,dst_port,description,style)
        s=style.dup
        s[:label]=description unless description.nil?()
        graph.add_edges({src_node => src_port.gsub(/\//,'_')},{dst_node => dst_port.gsub(/\//,'_')},s)
      end

      def sanitize_port_name(name)
        n=name.dup
        n.gsub!(/^.*___/,'')
        n.gsub!(/ /,'_')
        n.gsub!(/TenGigabitEthernet/,"Te")
        n.gsub!(/GigabitEthernet/,"Gi")
        n.gsub!(/FastEthernet/,"Fa")
        n="xx#{n}" if n.match(/^[0-9]/)
        return n
      end

      def query_component_map(graph,component,stop_properties,hide_properties,show_components,depth,property)
        add_node(graph,component,nil,nil,NODE_COMPONENT_STYLE)
        return if hide_properties.include?(:isConnectedTo) || hide_properties.include?(:hasLayer1Connection)

        nodes=Array.new()
        edges=Hash.new()
        todo=Array.new()
        todo << component.intern

        edges[component.intern]=Array.new()
        edges[component.intern] << component.intern
        nodes << component.intern

        done=todo.empty?()
        until done do
          todo_new=Array.new()
          todo.each do |t|
            results=Array.new()
            #FIXME use class instead of data property
            show_components.each do |c|
              case c
                when :Switch then
                  results << @ontology.query("SELECT ?c WHERE { <#{@ns_url}#{t.to_s}> no:#{property} ?c . ?c a no:#{c.to_s} }")
                when :ManagedNetworkComponent then
                  results << @ontology.query("SELECT ?c WHERE { <#{@ns_url}#{t.to_s}> no:#{property} ?c }")
                else
                  results << @ontology.query("SELECT ?c WHERE { <#{@ns_url}#{t.to_s}> no:#{property} ?c . ?c no:is#{c.to_s} \"true\" }")
              end
            end
            neighbors=Array.new()
            results.each do |res|
              res.each do |r|
                neighbors << r[:c].intern unless neighbors.include?(r[:c].intern)
              end
            end

            neighbors.each do |name|
              todo_new << name unless todo.include?(name) || todo_new.include?(name) || nodes.include?(name)
              unless nodes.include?(name) then
                add_node(graph, name.to_s, nil, nil, NODE_COMPONENT_STYLE)
                nodes << name
              end
              unless edges.include?(name) then
                edges[name]=Array.new
                edges[name] << name
              end
              unless edges.include?(t) then
                edges[t]=Array.new
                edges[t] << t
              end
              if edges[t].include?(name) && !edges[name].include?(t) then
                edges[name] << t
              elsif !edges[t].include?(name) && edges[name].include?(t) then
                edges[t] << name
              elsif !edges[t].include?(name) && !edges[name].include?(t)
                edges[t] << name
                edges[name] << t
                add_edge(graph, t.to_s, name.to_s, nil, EDGE_CONNECTION_NONE_DETAIL_STYLE)
              end
            end
          end
          todo=todo_new
          done=todo.empty?() || stop_properties.include?(:isConnectedTo) || stop_properties.include?(:hasLayer1Connection) || depth==0
          depth-=1
        end
      end

      def query_component_map_with_interfaces_splitted_v(graph,component,stop_properties,hide_properties,show_components,stop_components)
        if hide_properties.include?(:isConnectedTo) || hide_properties.include?(:hasLayer1Connection) then
          add_node(graph,component,nil,nil,NODE_COMPONENT_STYLE)
          return
        end

        nodes=Array.new()
        edges=Hash.new()
        todo=Array.new()
        seen=Array.new()
        neighbors=Hash.new()
        todo << component.intern

        done=todo.empty?()
        until done do
          todo_new=Array.new()
          todo.each do |t|
            results=Array.new()
            #FIXME use class instead of data property
            show_components.each do |c|
              case c
                when :Switch then
                  results << @ontology.query("SELECT ?c ?t_l1 ?c_l1 WHERE { <#{@ns}#{t.to_s}> no:hasLayer1Connection ?c . ?c a no:#{c.to_s} . <#{@ns}#{t.to_s}> no:hasLayer1Interface ?t_l1 . ?c no:hasLayer1Interface ?c_l1 . ?t_l1 no:isConnectedTo ?c_l1 }")
                when :ManagedNetworkComponent then
                  results << @ontology.query("SELECT ?c ?t_l1 ?c_l1 WHERE { <#{@ns}#{t.to_s}> no:hasLayer1Connection ?c . <#{@ns}#{t.to_s}> no:hasLayer1Interface ?t_l1 . ?c no:hasLayer1Interface ?c_l1 . ?t_l1 no:isConnectedTo ?c_l1 }")
                else
                  results << @ontology.query("SELECT ?c ?t_l1 ?c_l1 WHERE { <#{@ns}#{t.to_s}> no:hasLayer1Connection ?c . ?c no:is#{c.to_s} \"true\" . <#{@ns}#{t.to_s}> no:hasLayer1Interface ?t_l1 . ?c no:hasLayer1Interface ?c_l1 . ?t_l1 no:isConnectedTo ?c_l1 }")
              end
            end
            results.each do |res|
              res.each do |r|
                r[:t]=t
                todo_new << r[:c].intern unless todo.include?(r[:c].intern) || todo_new.include?(r[:c].intern) || seen.include?(r[:c].intern)
                seen << r[:c].intern
                src_port=(sanitize_port_name(r[:t_l1])).intern
                dst_port=(sanitize_port_name(r[:c_l1])).intern
                neighbors[t]=Hash.new() unless neighbors.include?(t)
                neighbors[t][src_port]=Array.new() unless neighbors[t].include?(src_port)
                neighbors[t][src_port] << {:c => r[:c].intern, :c_l1 => dst_port}

                neighbors[r[:c].intern]=Hash.new() unless neighbors.include?(r[:c].intern)
                neighbors[r[:c].intern][dst_port]=Array.new() unless neighbors[r[:c].intern].include?(dst_port)
                neighbors[r[:c].intern][dst_port] << {:c => r[:t].intern, :c_l1 => src_port}
              end
            end
          end
          todo=todo_new
          done=todo.empty?() || stop_properties.include?(:isConnectedTo) || stop_properties.include?(:hasLayer1Connection)
        end
        neighbors.each do |node,interfaces|
          ports=Array.new
          interfaces.keys.sort.each do |i|
            ports << i.to_s
          end
          add_record_node(graph, node.to_s, ports, nil, NODE_COMPONENT_WITH_INTERFACE_STYLE)
          nodes << node
          interfaces.each do |i,n|
            n.each do |neighbor|
              src="#{node.to_s}:#{i.to_s}".intern
              dst="#{neighbor[:c].to_s}:#{neighbor[:c_l1].to_s}".intern
              unless edges.include?(src) then
                edges[src]=Array.new
                edges[src] << src
              end
              unless edges.include?(dst) then
                edges[dst]=Array.new
                edges[dst] << dst
              end
              if edges[dst].include?(src) && !edges[src].include?(dst) then
                edges[src] << dst
              elsif !edges[dst].include?(src) && edges[src].include?(dst) then
                edges[dst] << src
              elsif !edges[dst].include?(src) && !edges[src].include?(dst) then
                edges[dst] << src
                edges[src] << dst
                add_record_edge(graph, node.to_s, i.to_s, neighbor[:c].to_s, neighbor[:c_l1].to_s, nil, EDGE_CONNECTION_INTERFACES_DETAIL_STYLE)
              end
            end
          end
        end
      end


      def query_component_map_with_interfaces(graph,component,stop_properties,hide_properties,show_components,stop_components)
        if hide_properties.include?(:isConnectedTo) || hide_properties.include?(:hasLayer1Connection) then
          add_node(graph,component,nil,nil,NODE_COMPONENT_STYLE)
          return
        end

        nodes=Array.new()
        edges=Hash.new()
        todo=Array.new()
        seen=Array.new()
        neighbors=Hash.new()
        todo << component.intern

        done=todo.empty?()
        until done do
          todo_new=Array.new()
          todo.each do |t|
            results=Array.new()
            #FIXME use class instead of data property
            show_components.each do |c|
              case c
                when :Switch then
                  results << @ontology.query("SELECT ?c ?t_l1 ?c_l1 WHERE { <#{@ns}#{t.to_s}> no:hasLayer1Connection ?c . ?c a no:#{c.to_s} . <#{@ns}#{t.to_s}> no:hasLayer1Interface ?t_l1 . ?c no:hasLayer1Interface ?c_l1 . ?t_l1 no:isConnectedTo ?c_l1 }")
                when :ManagedNetworkComponent then
                  results << @ontology.query("SELECT ?c ?t_l1 ?c_l1 WHERE { <#{@ns}#{t.to_s}> no:hasLayer1Connection ?c . <#{@ns}#{t.to_s}> no:hasLayer1Interface ?t_l1 . ?c no:hasLayer1Interface ?c_l1 . ?t_l1 no:isConnectedTo ?c_l1 }")
                else
                  results << @ontology.query("SELECT ?c ?t_l1 ?c_l1 WHERE { <#{@ns}#{t.to_s}> no:hasLayer1Connection ?c . ?c no:is#{c.to_s} \"true\" . <#{@ns}#{t.to_s}> no:hasLayer1Interface ?t_l1 . ?c no:hasLayer1Interface ?c_l1 . ?t_l1 no:isConnectedTo ?c_l1 }")
              end
            end
            results.each do |res|
              res.each do |r|
                r[:t]=t
                todo_new << r[:c].intern unless todo.include?(r[:c].intern) || todo_new.include?(r[:c].intern) || seen.include?(r[:c].intern)
                seen << r[:c].intern
                src_port=(sanitize_port_name(r[:t_l1])).intern
                dst_port=(sanitize_port_name(r[:c_l1])).intern
                neighbors[t]=Hash.new() unless neighbors.include?(t)
                neighbors[t][src_port]=Array.new() unless neighbors[t].include?(src_port)
                neighbors[t][src_port] << {:c => r[:c].intern, :c_l1 => dst_port}

                neighbors[r[:c].intern]=Hash.new() unless neighbors.include?(r[:c].intern)
                neighbors[r[:c].intern][dst_port]=Array.new() unless neighbors[r[:c].intern].include?(dst_port)
                neighbors[r[:c].intern][dst_port] << {:c => r[:t].intern, :c_l1 => src_port}
              end
            end
          end
          todo=todo_new
          done=todo.empty?() || stop_properties.include?(:isConnectedTo) || stop_properties.include?(:hasLayer1Connection)
        end
        neighbors.each do |node,interfaces|
          ports=Array.new
          interfaces.keys.sort.each do |i|
            ports << i.to_s
          end
          add_record_node(graph, node.to_s, ports, nil, NODE_COMPONENT_WITH_INTERFACE_STYLE)
          nodes << node
          interfaces.each do |i,n|
            n.each do |neighbor|
              src="#{node.to_s}:#{i.to_s}".intern
              dst="#{neighbor[:c].to_s}:#{neighbor[:c_l1].to_s}".intern
              unless edges.include?(src) then
                edges[src]=Array.new
                edges[src] << src
              end
              unless edges.include?(dst) then
                edges[dst]=Array.new
                edges[dst] << dst
              end
              if edges[dst].include?(src) && !edges[src].include?(dst) then
                edges[src] << dst
              elsif !edges[dst].include?(src) && edges[src].include?(dst) then
                edges[dst] << src
              elsif !edges[dst].include?(src) && !edges[src].include?(dst) then
                edges[dst] << src
                edges[src] << dst
                add_record_edge(graph, node.to_s, i.to_s, neighbor[:c].to_s, neighbor[:c_l1].to_s, nil, EDGE_CONNECTION_INTERFACES_DETAIL_STYLE)
              end
            end
          end
        end
      end

      def query_component_full_detail(graph,component,stop_properties,hide_properties,show_components)
        error "Implement me"
      end

      def write_files(graph,file_base)
        FileUtils.mkdir_p(@output_dir)
        @output_format.each do |f|
          if f==:dot then
            File.open("#{file_base}.#{f.to_s}", 'w') {|file| file.write(graph.to_s) }
          else
            @output_engine.each do |engine|
              begin
                graph.output(f => "#{file_base}_#{engine.to_s}.#{f.to_s}", :use => engine.to_s)
              rescue => e
                error "Failed to generate #{f.to_s} image file with #{engine.to_s}", e
              end
            end
          end
          puts "Use generate_graphviz.sh to compile dot files"
        end
      end
    end
  end
end
