# encoding: utf-8
# license: gpl2p 

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST
module Iof
  module Query
    class Nagios < Base

      Entry=Struct.new(:parent,:snippet,:host_data,:query_result,:blacklisted,:whitelisted)
      HostData=Struct.new(:name,:alias,:address,:contact,:template)

      def initialize()
        super(:nagios_structure,[:switches,:layer1_connections],File.join(Ghun::Base::Blackboard.local.data_path,'ontologies','network.owl'))
        @output_file=File.join(Ghun::Base::Blackboard.local.data_path,"nagios.cfg")
        #add to whitelist to enable output; no output without whitelisting
        @whitelist=["0.0.0.0/0"]
        #add to blacklist to block output; blacklist wins
        @blacklist=[]
        @blacklist_ip=[]
        @whitelist_ip=[]
        @blacklist.each do |b|
          @blacklist_ip << IPAddress::IPv4.new(b)
        end unless @blacklist.nil?()
        @whitelist.each do |w|
          @whitelist_ip << IPAddress::IPv4.new(w)
        end unless @whitelist.nil?()

      end

      def query(root_component)
        @nagios=Array.new()
        root=Iof::Data::Base.sanitize_name(root_component)
        entries=collect_nagios_data(root)
        generate_nagios_snippets(entries)
        write_configuration(entries)
      end



    private

      def collect_nagios_data(root_component)
        entries=Array.new()
        switches=@lookup.get_lookup_table(:switches)
        switches.each do |s|
          entry=Entry.new()
          entry.host_data=HostData.new()
          entry.host_data.name=s
          entries << entry
        end
        entries.each do |entry|
          path=@lookup.get_lookup_table(:layer1_connections,root_component.intern,entry.host_data.name.intern)
          path.path.each do |p|
            next if p.component==entry.host_data.name
            entry.parent=p.component
          end unless path.nil?()
          #FIXME get class from ontology
          entry.host_data.template="generic-switch"
          #FIXME get contactgroup from ontolgoy
          result=@ontology.query("SELECT DISTINCT ?address WHERE { <#{@ns_url}#{entry.host_data.name}> no:hasManagementAddress ?m . ?m no:hasIPv4AddressValue ?address }",true)
          entry.host_data.address=result[0][:address] unless result.nil?() || result.empty?() || result[0].nil?() || result[0][:address].nil?()
          if entry.host_data.address.nil?() || entry.host_data.address==""
            result=@ontology.query("SELECT DISTINCT ?c ?l1 ?l2 ?l3 ?address WHERE { <#{@ns_url}#{entry.host_data.name}> no:hasLayer1Interface ?l1 . ?l1 no:hasLayer2Interface ?l2 . ?l2 no:hasLayer3Interface ?l3 . ?l3 no:isManagementInterface 'true' . ?l3 no:hasIPv4Address ?l3a . ?l3a no:hasIPv4AddressValue ?address}",true)
            entry.host_data.address=result[0][:address] unless result.nil?() || result.empty?() || result[0].nil?() || result[0][:address].nil?()
          end
          if entry.host_data.address.nil?() || entry.host_data.address=="" then
            result=@ontology.query("SELECT DISTINCT ?c ?l1 ?l2 ?l3 ?address WHERE { <#{@ns_url}#{entry.host_data.name}> no:hasLayer1Interface ?l1 . ?l1 no:hasLayer2Interface ?l2 . ?l2 no:hasLayer3Interface ?l3 . ?l3 no:hasIPv4Address ?l3a . ?l3a no:hasIPv4AddressValue ?address}",true)
            entry.host_data.address=result[0][:address] unless result.nil?() || result.empty?() || result[0].nil?() || result[0][:address].nil?()
          end
          @blacklist_ip.each do |b|
            entry.blacklisted ||= b.include?(::IPAddress::IPv4.new(entry.host_data.address)) unless entry.host_data.address.nil?() || entry.host_data.address==""
          end
          @whitelist_ip.each do |w|
            entry.whitelisted ||= w.include?(::IPAddress::IPv4.new(entry.host_data.address)) unless entry.host_data.address.nil?() || entry.host_data.address==""
          end
        end
      end

      def generate_nagios_snippets(entries)
        entries.each do |entry|
          entry.snippet="define host{\n"
          if entry.host_data.template.nil?() then
            entry.snippet+="\tuse generic\n"
          else
            entry.snippet+="\tuse #{entry.host_data.template}\n"
          end
          if entry.host_data.name.nil?() then
            error "Got no hostname for entry #{entry.to_s}"
            entry.snippet=nil
            next
          else
            entry.snippet+="\thost_name #{entry.host_data.name}\n"
          end
          entry.snippet+="\talias #{entry.host_data.name}\n" unless entry.host_data.alias.nil?()
          if entry.host_data.address.nil?() then
            entry.snippet=nil
            error "Got no address for entry #{entry.to_s}"
            next
          else
            entry.snippet+="\taddress #{entry.host_data.address}\n"
          end
          if entry.host_data.contact.nil?() then
            entry.snippet+="\tcontact_groups IofTestGroup\n"
          else
            entry.snippet+="\tcontact_groups #{entry.host_data.contact}\n"
          end
          if entry.parent.nil?() then
            error "Got no parent for entry #{entry.to_s}"
          else
            entry.snippet+="\tparents #{entry.parent}\n"
          end
          entry.snippet+="}\n\n"
        end
      end

      def write_configuration(entries)
        f=STDOUT
        f=File.open(@output_file,'w') unless @output_file.nil?()
        entries.each do |entry|
          if entry.snippet.nil?() then
            warn "Got no configuration snippet for host '#{entry.host_data.name}'"
          else
            if entry.whitelisted && !entry.blacklisted then
              f << entry.snippet
            elsif entry.whitelisted && entry.blacklisted then
              info "Host '#{entry.host_data.name}' is included in whitelisted but also listed in blacklist"
            elsif !entry.whitelisted then
              info "Host '#{entry.host_data.name}' is not included in whitelisted"
            end
          end
        end
        f.close() unless @output_file.nil?() || f.closed?()
      end

    end
  end
end
