# encoding: utf-8
# license: gpl2p

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST
module Iof
  module Query
    Ghun::Log::Source.register_log_source("QUERY")

    Layer1Interface=Struct.new(:component,:layer1_interface)
    Layer2Interface=Struct.new(:component,:layer1_interface,:layer2_interface)
    Layer3Interface=Struct.new(:component,:layer1_interface,:layer2_interface,:layer3_interface)

    class PathEntry
      def initialize(component=nil,interface=nil)
        @component=component
        @interface=interface
      end

      def clone()
        Iof::Query::PathEntry.new(@component,@interface)
      end

      def ==(other)
        @component==other.component #&& @interface==other.interface
      end
      attr_accessor :component, :interface
    end

    class Path
      def initialize
        @path=[]
        @unchanged=true
      end

      attr_reader :path

      def unchanged?()
        @unchanged
      end

      def <<(arg)
        return if arg.nil?()
        @unchanged=false
        if arg.is_a?(Iof::Query::PathEntry) then
          @path << arg
        elsif arg.is_a?(Iof::Query::Path) then
          @path.concat(arg.path)
        elsif arg.is_a?(Array) then
          @path.concat(arg)
        end
      end

      def include?(component,interface=nil,skip=0)
        remaining=skip
        @path.each do |p|
          remaining-=1
          next unless remaining <0
          return true if p.component==component && (interface.nil?() || p.interface==interface)
        end
        return false
      end

      def empty?()
        @path.empty?
      end

      def reverse()
        new_path=Iof::Query::Path.new()
        new_path << @path.reverse
        new_path
      end

      def reverse!()
        @unchanged=false
        @path.reverse!
        self
      end

      def clone()
        p=Iof::Query::Path.new()
        @path.each do |entry|
          p << entry.clone
        end
        p
      end

      def ==(other)
        raise ArgumentError unless other.is_a?(Iof::Query::Path)
        return false if (@path.nil?() && !other.path.nil?()) || (!@path.nil?() && other.path.nil?())
        return true if @path.nil?() && other.path.nil?()
        return false unless @path.size() == other.path.size()
        for i in (0..(@path.size()-1))
          return false unless @path[i]==other.path[i]
        end
        return true
      end
    end

  end
end
