# encoding: utf-8
# license: gpl2p 

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST
module Iof
  module Query
    class QueryServer #< Base

      require 'socket'
      require 'digest'

      def initialize(port, ontology = 'network.owl')
        @handler=Ghun::Base::Blackboard.ontology
        @ontology=@handler.init_ontology(:query)

        @port = port.to_i

        @queries = Hash.new
      end

      def start()
        @server = TCPServer.open @port

        loop do
          next_client = @server.accept
          client_connection = ClientConnection.new('client connection', next_client, self)
          client_connection.start
        end
      end

      def query_count()
        @ontology.request_queue_length
      end

      def query_add(client_id, q, sync = false)
        starttime = Time.now.to_i
        q_id = Digest::SHA256.hexdigest("#{client_id}#{q}#{starttime}#{rand(1024)}")

        if sync
          r = @ontology.query(q)

          return { value: r }
        end

        @ontology.enqueue_query(q_id, q)

        { query_id: q_id, time: starttime }
      end

      def query_status(q_id)
        @ontology.request_state(q_id)
      end

      def query_pos(q_id)
        @ontology.requests_before(q_id)
      end

      def query_result(q_id)
        r = @ontology.get_response_by_id_non_blocking(q_id)
        if r.is_a?(Java::ComHpHplJenaQuery::QueryParseException)
          r = nil
        else
          r = @ontology.convert_result_to_table(r)
        end
        r
      end

      def query_abort(q_id)
        @ontology.abort_request(q_id)
      end

    end

    class ClientConnection < Ghun::Base::Thread

      def initialize(name, socket, server)
        super(name)
        @socket = socket
        @server = server

        #@remote_addr = @socket.addr(false)[3]
        @remote_addr = '127.0.0.1'
      end

      def write(data)
        @socket.write(CBOR.encode(data) do |buffer|
           @socket.write(buffer)
           @socket.flush
        end)
        @socket.flush
      end

      def read
        data_start = @socket.read(1)
        data = nil
        if data_start
          data = CBOR.decode(data_start) do |num_bytes|
            @socket.read(num_bytes)
          end
        end

        data
      end # read

      def client_id(data)
        "#{data[:client_id]}#{@remote_addr}"
      end

      def run
        loop do
          data = read
          if data && data.is_a?(Hash)
            case data[:type]
            when :query
              sync = (data[:sync] or false)

              q = @server.query_add(client_id(data), data[:query], sync)

              if !sync
                write({ type: :querywait}.merge(q))
              else
                write({ type: :queryresult}.merge(q))
              end
            when :querystatus
              status = @server.query_status(data[:query_id])

              write({ type: :querystatus, value: status })
            when :queryresult
              result = @server.query_result(data[:query_id])

              write({ type: :queryresult, value: result })
            when :querycount
              result = @server.query_count()

              write({ type: :querycount, value: result })
            when :queryabort
              result = @server.query_abort(data[:query_id])

              write({ type: :queryabort, value: result })
            when :querypos
              result = @server.query_pos(data[:query_id])

              write({ type: :querypos, value: result })
            end
          else
            break
          end
        end

        @socket.close
      end # run

    end # ClientConnection

  end
end
