# encoding: utf-8
# license: gpl2p

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST

require 'date'
module Iof
  module Runner
    class Base < Ghun::Base::Module
      #TODO: implement documented mode behavior
      #done for target_items and target_soures
      #undone for lockup module
      #
      #possible modes
      # :execute_and_store_or_read: fetch data from remote connection and store through output module or read through output module in case of an error
      # :execute_and_store: fetch data from remote connection and store through output module
      # :execute: fetch data from remote connection
      # :read: load data through output module
      # :execute_or_read:  fetch data from remote connection or load through output module in case of error
      # :read_or_execute:  read through output module or fetch from remote connection if not data present
      # :read_or_execute_and_store: read through output module or fetch from remote connection and store through output module if not data present

      #possible values for last_step
      # :prepare  : collect targets, run identify and prepare
      # :collect  : prepare  + run collect; after this step raw data from all targets should be retrieved
      #               but the content is not searched for further targets
      # :preparse : collect  + run preparse; after this step further target could be detected;
      #               sends first data pieces like MAC<->IPV4 to data_handler
      # :parse    : preparse + run parse; main parsing but not postprocessing
      # :postparse: parse    + run postparse; drops intermediate results in parser; sends parser results to data_handler
      # :cleanup  : parse    + run cleanup; drops raw data from target items
      # :store    : cleanup  + store data sent to data_handler in storage backend
      Ghun::Base::Blackboard.config.declare_key(:"runner.max_parser_threads", :uint, 8)
      #read_timestamp will only be used with mode==:read
      #for all other modes it is assumed that the user wants the most recent data
      Ghun::Base::Blackboard.config.declare_key(:"runner.read_timestamp", :string, "current")
      Ghun::Base::Blackboard.config.declare_key(:"runner.sleeping_thread_compensation_factor", :uint, 8)
      def initialize(last_step=:store,mode=:execute_and_store,force_unthreaded_collecting=false,force_unthreaded_parsing=true)
        super(Ghun::Log::Source::RUNNER)
        @max_threads=Hash.new()
        @real_min_threads=Hash.new()
        @real_max_threads=Hash.new()
        @max_threads_mutex=Monitor.new()
        @max_parser_threads=config[:"runner.max_parser_threads"]
        read_timestamp=config[:"runner.read_timestamp"]
        @sleeping_thread_compensation_factor=config[:"runner.sleeping_thread_compensation_factor"]
        @write_timestamp=Ghun::Output::TimeStamp.create_global_timestamp(:collect)

        #identify and prepare should always be run together
        last_step=:prepare if last_step==:identify
        found_last=false
        [:identify,:prepare,:collect,:preparse,:parse,:postparse,:cleanup,:store].each do |step|
          self.instance_variable_set("@#{step.to_s}".intern,!found_last)
          found_last=(last_step==step) unless found_last
        end

        @read_timestamp=Ghun::Output::TimeStamp.new()
        @read_timestamp.special=:current
        begin
          @read_timestamp.time=DateTime.parse(read_timestamp).to_time
          @read_timestamp.special=false
        rescue => e
          error "Failed to parse timestamp #{read_timestamp}, using current", e
        end if mode==:read && read_timestamp.downcase()!="current"

        @mode=mode

        @force_unthreaded_collecting=force_unthreaded_collecting
        @force_unthreaded_parsing=force_unthreaded_parsing
        @target_handler=Iof::Target::Handler.new(@mode,@write_timestamp,@read_timestamp)
        @auth_handler=Ghun::Auth::Handler.new()

        if @parse
          Ghun::Base::Blackboard.lookup.enable_all()
          Iof::Data::Mapper.instance()
          @data_handler=Iof::Data::Handler.new()
          Ghun::Output::Distributed.new('poe_aps',['poe','accesspoints'])
          Ghun::Output::Distributed.new('poe_phones',['poe','phones'])
          headline=Hash.new()
          headline[:device]="Switch"
          headline[:interface]="Interface"
          headline[:is_poe_capable]="Interface is PoE capable"
          headline[:powers_device]="Interface powers device"
          headline[:power_device_type]="Device type via power inline"
          headline[:reports_power]="Connected device reports power consumption"
          headline[:non_zero_power]="Switch reports non zero power request level"
          headline[:cdp_device_type]="Device name via CDP"
          headline[:cdp_device_name]="Device type via CDP"
          Ghun::Output::DISTRIBUTED_HANDLER[:'poe_aps'].headline=headline.clone()
          Ghun::Output::DISTRIBUTED_HANDLER[:'poe_phones'].headline=headline.clone()
          Ghun::Output::Distributed.new('etherchannels',['status','etherchannel'])
          headline=Hash.new()
          headline[:switch]="Switch"
          headline[:channel]="Port-channel name"
          headline[:channel_flags]="Port-channel flags"
          headline[:channel_layer]="Port-channel layer"
          headline[:channel_protocol]="Port-channel protocol"
          headline[:number_active]="Number of active interfaces"
          headline[:active]="Active interfaces"
          headline[:number_inactive]="Number of inactive interfaces"
          headline[:inactive]="Inactive interfaces"
          Ghun::Output::DISTRIBUTED_HANDLER[:'etherchannels'].headline=headline.clone()
        else
          @data_handler=nil
        end

        init_filter if self.respond_to?(:init_filter, :true)
      end

      def read_timestamp=(ts)
        old_ts=@read_timestamp
        @read_timestamp=Ghun::Output::TimeStamp.new()
        @read_timestamp.special=:current
        begin
          @read_timestamp.time=DateTime.parse(ts).to_time
          @read_timestamp.special=false
        rescue => e
          error "Failed to parse timestamp #{ts}, using old timestamp", e
          @read_timestamp=old_ts
        end if @mode==:read && ts.downcase()!="current"
        @read_timestamp
      end

      def write_timestamp=(ts)
        old_ts=@write_timestamp
        @write_timestamp=Ghun::Output::TimeStamp.new()
        begin
          @write_timestamp.time=DateTime.parse(ts).to_time
          @write_timestamp.special=false
        rescue => e
          error "Failed to parse timestamp #{ts}, using old timestamp", e
          @write_timestamp=old_ts
        end
        @write_timestamp
      end

      attr_reader :read_timestamp, :write_timestamp

      def report_thread_sleep(duration,connection_type)
        return unless start_new_thread?(duration)
        @max_threads_mutex.synchronize {
          if @max_threads.include?(connection_type) && !@max_threads[connection_type].nil?()
            @max_threads[connection_type]+=1 unless @max_threads[connection_type]==@real_max_threads[connection_type]
            debug "Changed maximum number of threads for #{connection_type.to_s} connections to #{@max_threads[connection_type]}"
          end
        }
      end

      def report_thread_wakeup(duration,connection_type)
        return unless start_new_thread?(duration)
        @max_threads_mutex.synchronize {
          if @max_threads.include?(connection_type) && !@max_threads[connection_type].nil?()
            @max_threads[connection_type]-=1 unless @max_threads[connection_type]==@real_min_threads[connection_type]
            debug "Changed maximum number of threads for #{connection_type.to_s} connections to #{@max_threads[connection_type]}"
          end
        }
      end

      def report_thread_longexec_start(connection_type)
        @max_threads_mutex.synchronize {
          if @max_threads.include?(connection_type) && !@max_threads[connection_type].nil?()
            @max_threads[connection_type]+=1 unless @max_threads[connection_type]==@real_max_threads[connection_type]
            debug "Changed maximum number of threads for #{connection_type.to_s} connections to #{@max_threads[connection_type]}"
          end
        }
      end

      def report_thread_longexec_stop(connection_type)
        @max_threads_mutex.synchronize {
          if @max_threads.include?(connection_type) && !@max_threads[connection_type].nil?()
            @max_threads[connection_type]-=1 unless @max_threads[connection_type]==@real_min_threads[connection_type]
            debug "Changed maximum number of threads for #{connection_type.to_s} connections to #{@max_threads[connection_type]}"
          end
        }
      end


      def start_new_thread?(duration)
        duration >= 5
      end
      private(:start_new_thread?)

      def run()
        while @target_handler.has_not_preparsed_targets?()
          puts "Identification and preparation"
          @target_handler.each do |target|
            next if target.filtered?()
            next if target.status_identify && target.status_prepare
            if target.special[:filtered_by_runner]
              target.filtered=true if target.special[:filtered_by_runner]
              next
            elsif !target.special[:filter_protected_by_cdp]
              target.special[:filtered_by_runner]=false
              #May be useful for evaluation or debugging scenarios
              #Just add a filtered_by_runner? method to make use of this
              target.special[:filtered_by_runner]||= filtered_by_runner?(target) if self.respond_to?(:filtered_by_runner?, :true)
              target.filtered=true if target.special[:filtered_by_runner]
            end
            next if target.filtered?()
            begin
              debug "Got target #{target.description()} for identification"
              target.identify(@mode)
            rescue => e
              target.status_identify=false
              error "Failure while identifying target #{target.description()}", e
            end if @identify && target.status_identify.nil?()
            begin
              debug "Got target #{target.description()} for preparation"
              target.prepare(@auth_handler)
            rescue => e
              target.status_prepare=false
              error "Failure while preparing target #{target.description()}", e
            end if @prepare && target.status_identify && target.status_prepare.nil?()
          end if @identify || @prepare
          running=Hash.new()
          th_size=@target_handler.size()
          th_count=0

          puts "Collection and preparsing"
          @target_handler.each do |target|
            th_count+=1
            next if target.filtered?()
            next if target.special[:filtered_by_runner]
            next unless target.status_prepare
            next unless target.status_collect.nil?()
            next if target.status_collect && target.status_preparse

            type=target.connection_type
            type="#{type.to_s}_v#{target.connection_version}".intern unless target.connection_version.nil?()
            threadable=!@force_unthreaded_collecting && ((target.connection_class==:none_connection)?(true):(target.connection_class.max_concurrent_connections()>1))

            debug "Collecting #{target.description},#{target.device_vendor},#{target.device_type} (threadable: #{threadable}) (#{th_count}/#{th_size})"
            if threadable then
              debug "Threading supported for target #{target.description()}"
              @max_threads_mutex.synchronize {
                if target.connection_class==:none_connection
                  @max_threads[type]=8
                  @real_min_threads[type]=8
                  @real_max_threads[type]=8*@sleeping_thread_compensation_factor
                else
                  @max_threads[type]=target.connection_class.max_concurrent_connections
                  @real_min_threads[type]=target.connection_class.max_concurrent_connections
                  @real_max_threads[type]=target.connection_class.max_concurrent_connections()*@sleeping_thread_compensation_factor
                end unless @max_threads.include?(type)
              }
              running[type]=Array.new() unless running.include?(type)
              started=false
              until started
                max=nil
                @max_threads_mutex.synchronize {
                  max=@max_threads[type]
                }
                if running[type].size() < max then
                  thread={:target=>target, :thread=>nil}
                  thread[:thread]=Ghun::Base::Thread.run("Collecting thread for #{target.description()}",0,Ghun::Log::Source::RUNNER) do
                    begin
                      debug "Got target #{target.description()} for data collection"
                      target.collect(self,@mode)
                    rescue => e
                      target.status_collect=false
                      error "Failure while collecting data for target #{target.description()}", e
                    end if @collect && target.status_prepare && target.status_collect.nil?()
                    begin
                      debug "Got target #{target.description()} for preparsing"
                      target.preparse(@target_handler)
                    rescue => e
                      target.status_preparse=false
                      error "Failure while preparsing target #{target.description()}", e
                    end if @preparse && target.status_collect && target.status_preparse.nil?()
                  end
                  running[type] << thread
                  started=true
                else
                  tmp=Array.new()
                  running[type].each do |t|
                    tmp << t if t[:thread].status
                  end
                  running[type]=tmp
                end
              end
            else
              debug "Threading not supported for target #{target.description()}"
              debug "Waiting for threads to terminate"
              all_done=false
              until all_done
                running.each do |ctype,targets|
                  if targets.empty?
                    running.delete(ctype)
                  else
                    tmp=Array.new()
                    running[ctype].each do |t|
                      tmp << t if t[:thread].status
                    end
                    running[ctype]=tmp
                    running.delete(ctype) if tmp.empty?
                  end
                end
                all_done=running.empty?
                sleep 0.5 unless all_done
              end
              debug "All running threads terminated"
              begin
                debug "Got target #{target.description()} for data collection"
                target.collect(self,@mode)
              rescue => e
                target.status_collect=false
                error "Failure while collecting data for target #{target.description()}", e
              end if @collect && target.status_prepare && target.status_collect.nil?()
              begin
                debug "Got target #{target.description()} for preparsing"
                target.preparse(@target_handler)
              rescue => e
                target.status_preparse=false
                error "Failure while preparsing target #{target.description()}", e
              end if @preparse && target.status_collect && target.status_preparse.nil?()
            end
          end if @collect || @preparse
          all_done=false
          until all_done
            running.each do |ctype,targets|
              if targets.empty?
                running.delete(ctype)
              else
                tmp=Array.new()
                running[ctype].each do |t|
                  tmp << t if t[:thread].status
                end
                running[ctype]=tmp
                running.delete(ctype) if tmp.empty?
              end
            end
            all_done=running.empty?
            sleep 0.5 unless all_done
          end if @collect || @preparse
        end
        running=Array.new()

        threaded_parsing=!(@force_unthreaded_collecting  || @force_unthreaded_parsing)
        if  threaded_parsing
          debug "Threaded parsing is enabled by user"
        else
          debug "Threaded parsing is disabled by user"
        end

        while @target_handler.has_not_parsed_targets?()
          th_size=@target_handler.size()
          th_count=0
          puts "Parsing"
          @target_handler.each do |target|
            th_count+=1
            next if target.filtered?()
            next if target.special[:filtered_by_runner]
            next unless target.status_preparse
            next if target.status_parse
            next if target.status_cleanup

            debug "Parsing #{target.description} (threaded: #{threaded_parsing}) (#{th_count}/#{th_size})"
            if threaded_parsing
              started=false
              until started
                if running.size() < @max_parser_threads
                  thread={:target=>target, :thread=>nil}
                  thread[:thread]=Ghun::Base::Thread.run("Parsing thread for #{target.description()}",0,Ghun::Log::Source::RUNNER) do
                    begin
                      debug "Got target #{target.description()} for parsing"
                      target.parse(@data_handler)
                    rescue => e
                      target.status_parse=false
                      error "Failure while parsing target #{target.description()}", e
                    end if target.status_preparse && target.status_parse.nil?()
                  end
                  running << thread
                  started=true
                else
                  tmp=Array.new()
                  running.each do |t|
                    tmp << t if t[:thread].status
                  end
                  running=tmp
                  sleep 0.5 unless running.empty?()
                end
              end
            else
              #No need to wait for running parser threads; threaded_parsing will not change
              begin
                debug "Got target #{target.description()} for parsing"
                target.parse(@data_handler)
              rescue => e
                target.status_parse=false
                error "Failure while parsing target #{target.description()}", e
              end if target.status_preparse && target.status_parse.nil?()
            end
          end
          until running.empty?()
            tmp=Array.new()
            running.each do |t|
              tmp << t if t[:thread].status
            end
            running=tmp
            sleep 0.5 unless running.empty?()
          end if threaded_parsing
        end if @parse

        if @postparse || @cleanup
          running=Array.new()
          th_size=@target_handler.size()
          th_count=0
          puts "Postparsing and cleaning"
          @target_handler.each do |target|
            th_count+=1
            next if target.filtered?()
            next if target.special[:filtered_by_runner]
            next unless target.status_preparse
            next if target.status_cleanup
            next if target.status_postparse

            debug "Postparsing #{target.description} (threaded: #{threaded_parsing}) (#{th_count}/#{th_size})"
            if threaded_parsing
              started=false
              until started
                if running.size() < @max_parser_threads
                  thread={:target=>target, :thread=>nil}
                  thread[:thread]=Ghun::Base::Thread.run("Postparsing thread for #{target.description()}",0,Ghun::Log::Source::RUNNER) do
                    begin
                      debug "Got target #{target.description()} for postparsing"
                      target.postparse()
                    rescue => e
                      target.status_postparse=false
                      error "Failure while postparsing target #{target.description()}", e
                    end if @postparse && target.status_parse && target.status_postparse.nil?()
                    begin
                      debug "Got target #{target.description()} for cleaning up"
                      target.cleanup()
                    rescue => e
                      target.status_cleanup=false
                      error "Failure while cleaning up target #{target.description()}", e
                    end if @cleanup && target.status_postparse && target.status_cleanup.nil?()
                  end
                  running << thread
                  started=true
                else
                  tmp=Array.new()
                  running.each do |t|
                    tmp << t if t[:thread].status
                  end
                  running=tmp
                  sleep 0.5 unless running.empty?()
                end
              end
            else
              #No need to wait for running parser threads; threaded_parsing will not change
              begin
                debug "Got target #{target.description()} for postparsing"
                target.postparse()
              rescue => e
                target.status_postparse=false
                error "Failure while postparsing target #{target.description()}", e
              end if @postparse && target.status_parse && target.status_postparse.nil?()
              begin
                debug "Got target #{target.description()} for cleaning up"
                target.cleanup()
              rescue => e
                target.status_cleanup=false
                error "Failure while cleaning up target #{target.description()}", e
              end if @cleanup && target.status_postparse && target.status_cleanup.nil?()
            end
          end
          until running.empty?()
            tmp=Array.new()
            running.each do |t|
              tmp << t if t[:thread].status
            end
            running=tmp
            sleep 0.5 unless running.empty?()
          end if threaded_parsing
          running=nil
        end

        if @store
          puts "Global postprocessing"
          @target_handler.generate_vlan_distribution_report()
          @target_handler.generate_vlan_distribution_report(true)
          if @parse
            Ghun::Base::Blackboard.lookup.members.keys.each do |lm|
              if Ghun::Base::Blackboard.lookup[lm].respond_to?(:send_to_data_handler)
                debug "Sending data from lookup module #{lm} to data_handler"
                Ghun::Base::Blackboard.lookup[lm].send_to_data_handler(@data_handler)
              else
                debug "Lookup module #{lm} has no data for data_handler"
              end
            end
          end
          begin
            puts "Storing"
            @data_handler.write_changes
            Ghun::Output::DISTRIBUTED_HANDLER[:'poe_aps'].write_data()
            Ghun::Output::DISTRIBUTED_HANDLER[:'poe_phones'].write_data()
            Ghun::Output::DISTRIBUTED_HANDLER[:'etherchannels'].write_data()
          rescue => e
            error "Failed to store data in storage backend", e
          end
        end
      end
    end
  end
end
