# encoding: utf-8
# license: gpl2p

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST
module Iof
  module Target
    COMMAND_SELECTOR=Ghun::Base::Selector.new("Commands",[:vendor,:type,:connection,:version],true,Ghun::Log::Source::TARGET,Ghun::Log::Type::BASE)
    CONNECTION_SELECTOR=Ghun::Base::Selector.new("Connection",[:vendor,:type],true,Ghun::Log::Source::TARGET,Ghun::Log::Type::BASE)
    CONNECTION_SELECTOR.register_member([:ssh,2], [nil,nil])
    RECONNECT_SELECTOR=Ghun::Base::Selector.new("Reconnect",[:vendor,:type,:connection,:version],true,Ghun::Log::Source::TARGET,Ghun::Log::Type::BASE)
    RECONNECT_SELECTOR.register_member(false, [nil,nil,nil,nil])


    cisco_generic_constraints=Hash.new()
    cisco_generic_constraints[:check_stdout]=true
    cisco_generic_constraints[:expect_empty_stdout]=false
    cisco_generic_constraints[:expect_nonempty_stdout]=true
    cisco_generic_constraints[:check_stderr]=true
    cisco_generic_constraints[:expect_empty_stderr]=true
    cisco_generic_constraints[:expect_nonempty_stderr]=false
    cisco_generic_constraints[:check_exit_code]=true
    cisco_generic_constraints[:expect_exit_code]=0
    cisco_generic_constraints[:check_signal]=true
    cisco_generic_constraints[:expect_signal]=nil
    cisco_generic_constraints[:failed_output_stdout]=[/^% Authorization failed/, /Line has invalid autocommand/]
    cisco_generic_constraints[:failed_output_stderr]=[/^% Authorization failed/, /Line has invalid autocommand/]

    allow_empty_result_constraints=Hash.new()
    allow_empty_result_constraints[:check_stdout]=false
    allow_empty_result_constraints[:expect_empty_stdout]=false
    allow_empty_result_constraints[:expect_nonempty_stdout]=true
    allow_empty_result_constraints[:check_stderr]=true
    allow_empty_result_constraints[:expect_empty_stderr]=true
    allow_empty_result_constraints[:expect_nonempty_stderr]=false
    allow_empty_result_constraints[:check_exit_code]=true
    allow_empty_result_constraints[:expect_exit_code]=0
    allow_empty_result_constraints[:check_signal]=true
    allow_empty_result_constraints[:expect_signal]=nil
    allow_empty_result_constraints[:failed_output_stdout]=[/^% Authorization failed/, /Line has invalid autocommand/]
    allow_empty_result_constraints[:failed_output_stderr]=[/^% Authorization failed/, /Line has invalid autocommand/]

    dont_care_constraints=Hash.new()
    dont_care_constraints[:check_stdout]=false
    dont_care_constraints[:expect_empty_stdout]=nil
    dont_care_constraints[:expect_nonempty_stdout]=nil
    dont_care_constraints[:check_stderr]=false
    dont_care_constraints[:expect_empty_stderr]=nil
    dont_care_constraints[:expect_nonempty_stderr]=nil
    dont_care_constraints[:check_exit_code]=false
    dont_care_constraints[:expect_exit_code]=nil
    dont_care_constraints[:check_signal]=false
    dont_care_constraints[:expect_signal]=nil
    dont_care_constraints[:failed_output_stdout]=[/^% Authorization failed/]
    dont_care_constraints[:failed_output_stderr]=[/^% Authorization failed/]

    cisco_generic=Hash.new()
    cisco_generic[:cdp_neighbors]={:command => 'show cdp neighbors detail', :constraints => cisco_generic_constraints }
    cisco_generic[:hosts]={:command => 'show hosts', :constraints => cisco_generic_constraints }
    cisco_generic[:version]={:command => 'show version', :constraints => cisco_generic_constraints }
    cisco_generic[:power]={:command => 'show power inline', :constraints => dont_care_constraints }
    cisco_generic[:module]={:command => 'show module', :constraints => dont_care_constraints }
    cisco_generic[:cdp_interfaces]={:command => 'show cdp interface', :constraints => cisco_generic_constraints }
    cisco_generic[:configuration]={:command => 'show running-config', :constraints => cisco_generic_constraints }
    cisco_generic[:vlan]={:command => 'show vlan brief', :constraints => cisco_generic_constraints }
    cisco_generic[:ipv4]={:command => 'show ip int brief', :constraints => cisco_generic_constraints }
    cisco_generic[:ipv6]={:command => 'show ipv6 int brief', :constraints => dont_care_constraints }
    cisco_generic[:arp]={:command => 'show arp', :constraints => cisco_generic_constraints }
    cisco_generic[:mac_addresses]={:command => 'show mac address-table dynamic', :constraints => cisco_generic_constraints }
    cisco_generic[:etherchannel]={:command => 'show etherchannel summary', :constraints => dont_care_constraints }
    cisco_generic[:interfaces_trunk]={:command => 'show interfaces trunk', :constraints => allow_empty_result_constraints}
    cisco_generic[:redundancy]={:command => 'show redundancy', :constraints => dont_care_constraints }
    cisco_generic[:switch]={:command => 'show switch', :constraints => dont_care_constraints }
    cisco_generic[:vtp_status]={:command => 'show vtp status', :constraints => cisco_generic_constraints }
    cisco_generic[:vtp_devices]={:command => 'show vtp devices', :constraints => dont_care_constraints }

    cisco_6=cisco_generic.clone()
    cisco_6[:mac_addresses]={:command => 'show mac-address-table dynamic', :constraints => cisco_generic_constraints }
    cisco_6[:module_all]={:command => 'show module switch all', :constraints => dont_care_constraints }

#dir /all slavedisk2:
#show rsp chassis-info
#dir /all sec-slot2:
#show diag
#dir /all disk1:
#show gsr chassis
#dir /all sec-nvram:
#show diag chassis-info
#dir /all disk2:
#dir /all sec-bootflash:
#show spe version
#dir /all slaveslot2:
#dir /all disk0:
#show install active
#show bootvar
#dir /all slaveslot0:
#dir /all sec-slot1:
#dir /all harddiska:
#dir /all slavenvram:
#show flash
#dir /all sec-disk2:
#dir /all slavesup-bootflash:
#dir /all sec-disk0:
#dir /all harddiskb:
#show variables boot
#show boot
#show inventory raw
#dir /all slavedisk1:
#show env all
#show module
#show controllers
#show diagbus
#more system:running-config
#dir /all slavedisk0:
#show debug
#show idprom backplane
#dir /all bootflash:
#dir /all sec-slot0:
#dir /all sec-disk1:
#write term
#show vtp status
#dir /all sup-bootflash:
#dir /all slot2:
#dir /all harddisk:
#dir /all slot0:
#dir /all sup-microcode:
#show vlan
#dir /all slavebootflash:
#show controllers cbus
#dir /all slaveslot1:
#dir /all nvram:
#show version
#show vlan-switch
#show redundancy secondary
#show running-config
#show c7200
#dir /all slot1

    COMMAND_SELECTOR.register_member(cisco_generic, [:cisco,nil,:ssh,nil])
    COMMAND_SELECTOR.register_member(cisco_generic, [:cisco,:generic,:ssh,nil])
    COMMAND_SELECTOR.register_member(cisco_6, [:cisco,:"6000",:ssh,nil])
    COMMAND_SELECTOR.register_member(cisco_6, [:cisco,:"6500",:ssh,nil])
    COMMAND_SELECTOR.register_member(cisco_6, [:cisco,:cigesm,:ssh,nil])
    COMMAND_SELECTOR.register_member({}, [:cisco,:cdp_ap,:none,nil])
    COMMAND_SELECTOR.register_member({}, [:cisco,:cdp_phone,:none,nil])
    COMMAND_SELECTOR.register_member({}, [:cisco,:cdp_switch,:none,nil])

    CONNECTION_SELECTOR.register_member([:ssh,2],[:cisco,nil])
    CONNECTION_SELECTOR.register_member([:none,nil],[:cisco,:cdp_ap])
    CONNECTION_SELECTOR.register_member([:none,nil],[:cisco,:cdp_phone])

  end
end
