# encoding: utf-8
# license: gpl2p

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST
module Iof
  module Target
    class TargetSourceDNS < TargetSource
      Iof::Target::Handler::SELECTOR.register_member(self,:dns)
      def initialize(name)
        super(name)
        config.declare_dynamic_key(:"target.source.#{@name}.zone", :string)
      end

      def filter_target_by_name(names)
        return false
      end

      def filter_target_by_ipv4(addresses)
        return false
      end

      def filter_target_by_ipv6(addresses)
        return false
      end

      def load_targets(handler,mode,output)
        return unless enabled?()
        zone_name=config[:"target.source.#{@name}.zone"]
        debug "#{self.class} loading targets in #{mode} mode"
        zone=nil
        case mode
        when :execute
          dns=Ghun::Dns::Resolver.new()
          zone=dns.zone_transfer(zone_name)
        when :read, :read_and_store
          zone=output.send(mode,['target.source',@name])
        when :execute_or_read, :execute_and_store_or_read, :execute_and_store, :read_or_execute, :read_or_execute_and_store
          zone=output.send(mode,['target.source',@name]) {
            dns=Ghun::Dns::Resolver.new()
            dns.zone_transfer(zone_name)
          }
        end
        zone.each do |rr|
          if (rr.type=="NS" || rr.type=="CNAME") then
            debug "Skipping entry #{rr.to_s}"
            next
          end
          item=Item.new()
          if rr.type=="A" then
            item.add_ipv4(handler,rr.address,:primary)
            item.add_ipv4(handler,rr.address,:dns)
          elsif rr.type=="AAAA" then
            item.add_ipv6(handler,rr.address,:primary)
            item.add_ipv6(handler,rr.address,:dns)
          end
          item.add_name(handler,rr.name,:primary)
          item.add_name(handler,rr.name,:dns)
          debug "Added item #{item.description(:full)}"
        end unless zone.nil?()
      rescue => e
        error "Failed to retrieve target list via DNS", e
        raise
      end
    end
  end
end
