# encoding: utf-8
# license: gpl2p

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST
module Iof
  module Target
    class TargetSourceMultiConfig < TargetSource
      Iof::Target::Handler::SELECTOR.register_member(self,:mconfig)
      def initialize(name)
        super(name)
        config.declare_dynamic_key(:"target.source.#{@name}.vendor", :array)
        config.declare_dynamic_key(:"target.source.#{@name}.type", :array)
        config.declare_dynamic_key(:"target.source.#{@name}.ipv4", :array,nil,false)
        config.declare_dynamic_key(:"target.source.#{@name}.ipv6", :array,nil,false)
        config.declare_dynamic_key(:"target.source.#{@name}.name", :array,nil,false)
        config.declare_dynamic_key(:"target.source.#{@name}.auth_name", :array,nil,false)
      end

      def load_targets(handler,mode,output)
        return unless enabled?()
        debug "#{self.class} loading targets in #{mode} mode"
        result=nil
        case mode
        when :execute
          result=load_from_config()
        when :read, :read_and_store
          result=output.send(mode,['target.source',@name])
        when :execute_or_read, :execute_and_store_or_read, :execute_and_store, :read_or_execute, :read_or_execute_and_store
          result=output.send(mode,['target.source',@name]) { load_from_config() }
        end
        size=0
        if !result[:ipv4].nil?()
          size=result[:ipv4].size
        elsif !result[:ipv6].nil?()
          size=result[:ipv6].size
        elsif !result[:name].nil?()
          size=result[:name].size
        end
        (0..(size-1)).each do |i|
          begin
            item=Item.new()
            raise "Missing identifier for target" if (result[:ipv4].nil?() || result[:ipv4][i].nil?()) && (result[:ipv6].nil?() || result[:ipv6][i].nil?()) && (result[:name].nil?() || result[:name][i].nil?())
            item.add_ipv4(handler,result[:ipv4][i]) unless result[:ipv4].nil?() || result[:ipv4][i].nil?()
            item.add_ipv6(handler,result[:ipv6][i]) unless result[:ipv6].nil?() || result[:ipv6][i].nil?()
            item.add_name(handler,result[:name][i]) unless result[:name].nil?() || result[:name][i].nil?()
            item.device_vendor=result[:vendor][i] unless result[:vendor].nil?() || result[:vendor][i].nil?()
            item.device_type=result[:type][i] unless result[:type].nil?() || result[:type][i].nil?()
            item.auth_name=result[:auth_name][i].intern unless result[:auth_name].nil?() || result[:auth_name][i].nil?()
            debug "Loaded new target #{item.description()} from config"
          rescue => e
            error "Invalid config structure for target source multi config", e
          end
        end
      rescue => e
        error "Failed to load target from configuration", e
      end

    private
      def load_from_config()
        result=Hash.new()
        result[:vendor]=config[:"target.source.#{@name}.vendor"]
        result[:type]=config[:"target.source.#{@name}.type"]
        result[:ipv4]=config[:"target.source.#{@name}.ipv4"]
        result[:ipv6]=config[:"target.source.#{@name}.ipv6"]
        result[:name]=config[:"target.source.#{@name}.name"]
        result[:auth_name]=config[:"target.source.#{@name}.auth_name"]
        return result
      end


    end
  end
end
