# encoding: utf-8
# license: gpl2p 

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST
module Iof
  module Data
    class Base
      class << self
        def plantuml_hierarchy(with_namespaces=false)
          result=""
          @subs.each do |ns,members|
            members.values.each do |sub|
              next unless sub.direct_super==self
              if with_namespaces then
                result+="#{self.ns.to_s}.#{@ontology_name} <|-- #{sub.ns.to_s}.#{sub.ontology_name}\n"
              else
                result+="#{@ontology_name} <|-- #{sub.ontology_name}\n"
              end
              result+=sub.plantuml_hierarchy(with_namespaces)
            end
          end
          return result
        end
      end
    end
  end
end

module Iof
  module Data
    class BaseClass < Base
      class << self
        def parse_plantuml_class_details_options(opts,depth)
          options=Hash.new()
          [:with_namespaces,:with_datatype_properties,:with_object_properties,:with_reasoning_results,:compact,:compact_mode,:with_association,:with_association_label].each do |key|
            if opts.include?(key) && (opts[key].is_a?(TrueClass) || opts[key].is_a?(FalseClass))
              options[key]=opts[key]
            elsif key==:compact_mode && options[:compact] && (opts[key]==:less_detailed || opts[key]==:more_detailed)
              options[key]=opts[key]
            elsif key==:compact_mode && options[:compact] && !opts[key]==:less_detailed && !opts[key]==:more_detailed
              options[:compact]=false
            elsif key==:compact_mode && !options[:compact]
              next
            else
              options[key]=false
            end
          end
          if depth <= 0
            options[:with_association]=false
          end
          unless options[:with_association]
            options[:with_association_label]=false
          end
          return options
        end

        def plantuml_class_details(depth,options,handled_classes=[])
          opts=parse_plantuml_class_details_options(options,depth)
          result=""
          return result if handled_classes.include?(self)

          handled_classes << self
          associations=Array.new() if opts[:with_association]
          fields=Array.new() if opts[:with_datatype_properties] || opts[:with_object_properties]

          in_domain_and_range_of=@in_domain_of & @in_range_of

          in_domain_and_range_of.each do |property|
            begin
              p=Iof::Data.namespace_to_module(property[:ns]).const_get(property[:name])
              next if p.options[:force_disable_mapping] || (p < BaseAnnotationProperty) || (p.options[:reasoning_result] && !opts[:with_reasoning_results])
              fields << p if (opts[:with_datatype_properties] && p < BaseDatatypeProperty) || (opts[:with_object_properties] && p < BaseObjectProperty)

              p.range.each do |klass|
                next if klass[:ns].nil?()
                c=Iof::Data.namespace_to_module(klass[:ns]).const_get(klass[:name])
                unless c.options[:force_disable_mapping]
                  a=Hash.new()
                  a[:klass] = c
                  a[:property] = p
                  a[:direction] = :both
                  associations << a
                end
              end if opts[:with_association] && p < BaseObjectProperty
            rescue => e
              error "Failed to get data for property #{property[:ns].to_s}.#{property[:name]}",e
            end
          end if (opts[:with_datatype_properties] || opts[:with_object_properties] || opts[:with_association])

          @in_domain_of.each do |property|
            begin
              next if in_domain_and_range_of.include?(property)
              p=Iof::Data.namespace_to_module(property[:ns]).const_get(property[:name])
              next if p.options[:force_disable_mapping] || (p < BaseAnnotationProperty) || (p.options[:reasoning_result] && !opts[:with_reasoning_results])
              fields << p if (opts[:with_datatype_properties] && p < BaseDatatypeProperty) || (opts[:with_object_properties] && p < BaseObjectProperty)

              p.range.each do |klass|
                next if klass[:ns].nil?()
                c=Iof::Data.namespace_to_module(klass[:ns]).const_get(klass[:name])
                unless c.options[:force_disable_mapping]
                  a=Hash.new()
                  a[:klass] = c
                  a[:property] = p
                  a[:direction] = :from
                  associations << a
                end
              end if opts[:with_association] && p < BaseObjectProperty
            rescue => e
              error "Failed to get data for property #{property[:ns].to_s}.#{property[:name]}",e
            end
          end if (opts[:with_datatype_properties] || opts[:with_object_properties] || opts[:with_association])

          @in_range_of.each do |property|
            begin
              next if in_domain_and_range_of.include?(property)
              p=Iof::Data.namespace_to_module(property[:ns]).const_get(property[:name])
              next if p.options[:force_disable_mapping] || (p < BaseAnnotationProperty) || (p.options[:reasoning_result] && !opts[:with_reasoning_results])
              fields << p if (opts[:with_datatype_properties] && p < BaseDatatypeProperty) || (opts[:with_object_properties] && p < BaseObjectProperty)

              p.domain.each do |klass|
                next if klass[:ns].nil?()
                c=Iof::Data.namespace_to_module(klass[:ns]).const_get(klass[:name])
                unless c.options[:force_disable_mapping]
                  a=Hash.new()
                  a[:klass] = c
                  a[:property] = p
                  a[:direction] = :to
                  associations << a
                end
              end if opts[:with_association] && p < BaseObjectProperty
            rescue => e
              error "Failed to get data for property #{property[:ns].to_s}.#{property[:name]}",e
            end
          end if (opts[:with_datatype_properties] || opts[:with_object_properties] || opts[:with_association])

          result+=plantuml_field_helper(fields,opts) if opts[:with_datatype_properties] || opts[:with_object_properties]
          shown_classes,tmp_result=plantuml_association_helper(associations,opts,handled_classes) if opts[:with_association]

          result+=tmp_result unless tmp_result.nil?()

          shown_classes.each do |c|
            result+=c[:klass].plantuml_class_details(depth-1, options, handled_classes)
          end if opts[:with_association] && depth>0

          if opts[:with_namespaces] then
            result+="class #{self.ns.to_s}.#{@ontology_name}\n"
          else
            result+="class #{@ontology_name}\n"
          end if result=="" || result.nil?()

          return result
        end

      private

        def plantuml_compact_class_hierarchy(associations,opts,handled_classes)
          if opts[:compact]
            compacted=Array.new()
            associations.each do |outer_a|
              keep=true
              associations.each do |inner_a|
                if opts[:compact_mode]==:less_detailed
                  #outer_a's class is subclass of inner_a's class
                  keep=false if !(outer_a[:klass] <=> inner_a[:klass]).nil?() && (outer_a[:klass] <=> inner_a[:klass]) < 0
                  #outer_a's property is subclass of inner_a's property
                  keep=false if !(outer_a[:property] <=> inner_a[:property]).nil?() && (outer_a[:property] <=> inner_a[:property]) < 0
                elsif opts[:compact_mode]==:more_detailed
                  #inner_a's class is subclass of outer_a's class
                  keep=false if !(outer_a[:klass] <=> inner_a[:klass]).nil?() && (outer_a[:klass] <=> inner_a[:klass]) > 0
                  #inner_a's property is subclass of outer_a's property
                  keep=false if !(outer_a[:property] <=> inner_a[:property]).nil?() && (outer_a[:property] <=> inner_a[:property]) > 0
                end
              end
              compacted << outer_a if keep || handled_classes.include?(outer_a[:klass])
            end
            return compacted
          else
            return associations.uniq()
          end
        end

        def plantuml_compact_property_hierarchy(properties,opts)
          if opts[:compact]
            compacted=Array.new()
            properties.each do |outer_p|
              keep=true
              properties.each do |inner_p|
                #IRB.start_session(binding)
                if opts[:compact_mode]==:less_detailed
                  #outer_p is subproperty of inner_p
                  keep=false if !(outer_p <=> inner_p).nil?() && (outer_p <=> inner_p) < 0
                elsif opts[:compact_mode]==:more_detailed
                  #inner_p is subproperty of outer_p
                  keep=false if !(outer_p <=> inner_p).nil?() && (outer_p <=> inner_p) > 0
                end
              end
              compacted << outer_p if keep
            end
            return compacted
          else
            return properties.uniq()
          end
        end

        def plantuml_field_helper(fields,opts)
          result=""
          fields_compact=plantuml_compact_property_hierarchy(fields, opts)
          fields_compact.each do |f|
            additional=""
            if f < BaseDatatypeProperty
              additional+=" (data)"
            elsif f < BaseObjectProperty
              additional+=" (object)"
            end
            if opts[:with_namespaces] then
              result+="#{self.ns.to_s}.#{@ontology_name} : #{f.ns.to_s}.#{f.ontology_name} #{additional}\n"
            else
              result+="#{@ontology_name} : #{f.ontology_name} #{additional}\n"
            end
          end
          return result
        end

        def plantuml_association_helper(associations,opts,handled_classes)
          #IRB.start_session(binding)
          result=""
          shown_classes=Array.new()
          associations_compact=plantuml_compact_class_hierarchy(associations,opts,handled_classes)
          associations_compact.each do |a|
            shown_classes << a
            label=""
            arrow="--"
            if a.include?(:direction) && a[:direction]==:to
              arrow="<--"
            elsif a.include?(:direction) && a[:direction]==:from
              arrow="-->"
            elsif a.include?(:direction) && a[:direction]==:both
              arrow="<-->"
            end
            if opts[:with_association_label]
              if opts[:with_namespaces] then
                label=" : #{a[:property].ns.to_s}.#{a[:property].ontology_name}"
              else
                label=" : #{a[:property].ontology_name}"
              end
            end
            if opts[:with_namespaces] then
              result+="#{self.ns.to_s}.#{@ontology_name} #{arrow} #{a[:klass].ns.to_s}.#{a[:klass].ontology_name}#{label}\n"
            else
              result+="#{@ontology_name} #{arrow} #{a[:klass].ontology_name}#{label}\n"
            end
          end
          return shown_classes.uniq,result
        end
      end
    end
  end
end


module Iof
  module Query
    class UML < Ghun::Base::Module
      def initialize()
        super(Ghun::Log::Source::QUERY)
        Iof::Data::Mapper.instance()
        @formats=[:svg,:png]
        @output_dir=File.join(Ghun::Base::Blackboard.application.data_path,'uml')
      end

      #@query.query_all_uml()
      def query_all_uml()
        query_class_hierarchy
        query_object_property_hierarchy
        query_datatype_property_hierarchy
        query_annotation_property_hierarchy
        query_class_details
      end

      def query_class_hierarchy(starting_class=Iof::Data::OWL::Thing,with_namespaces=false)
        write_files(@output_dir, 'classes', starting_class.plantuml_hierarchy(with_namespaces))
      end

      def query_object_property_hierarchy(starting_property=Iof::Data::OWL::TopObjectProperty,with_namespaces=false)
        write_files(@output_dir, 'object_properties', starting_property.plantuml_hierarchy(with_namespaces))
      end

      def query_datatype_property_hierarchy(starting_property=Iof::Data::OWL::TopDataProperty,with_namespaces=false)
        write_files(@output_dir, 'datatype_properties', starting_property.plantuml_hierarchy(with_namespaces))
      end

      def query_annotation_property_hierarchy(starting_property=Iof::Data::NO::TopAnnotationProperty,with_namespaces=false)
        write_files(@output_dir, 'annotation_properties', starting_property.plantuml_hierarchy(with_namespaces))
      end

      def query_class_details(klass=nil,with_namespaces=false)
        less_no_assoc_options={:with_namespaces => false,:with_datatype_properties => true,:with_object_properties => true, :with_reasoning_results => false, :compact => true, :compact_mode => :less_detailed, :with_association => false, :with_association_label => false}
        more_no_assoc_options={:with_namespaces => false,:with_datatype_properties => true,:with_object_properties => true, :with_reasoning_results => false, :compact => true, :compact_mode => :more_detailed, :with_association => false, :with_association_label => false}
        full_no_assoc_options={:with_namespaces => false,:with_datatype_properties => true,:with_object_properties => true, :with_reasoning_results => false, :compact => false, :compact_mode => false, :with_association => false, :with_association_label => false}
        less_assoc_options={:with_namespaces => false,:with_datatype_properties => true,:with_object_properties => false, :with_reasoning_results => true, :compact => true, :compact_mode => :less_detailed, :with_association => true, :with_association_label => true}
        more_assoc_options={:with_namespaces => false,:with_datatype_properties => true,:with_object_properties => false, :with_reasoning_results => true, :compact => true, :compact_mode => :more_detailed, :with_association => true, :with_association_label => true}
        full_assoc_options={:with_namespaces => false,:with_datatype_properties => true,:with_object_properties => false, :with_reasoning_results => true, :compact => false, :compact_mode => false, :with_association => true, :with_association_label => true}

        unless klass.nil?() then
          write_files(@output_dir, "#{klass.ontology_name}_no_assoc_less", klass.plantuml_class_details(0,less_no_assoc_options))
          write_files(@output_dir, "#{klass.ontology_name}_no_assoc_more", klass.plantuml_class_details(0,more_no_assoc_options))
          write_files(@output_dir, "#{klass.ontology_name}_no_assoc_full", klass.plantuml_class_details(0,full_no_assoc_options))
          write_files(@output_dir, "#{klass.ontology_name}_assoc_less", klass.plantuml_class_details(1,less_assoc_options))
          write_files(@output_dir, "#{klass.ontology_name}_assoc_more", klass.plantuml_class_details(1,more_assoc_options))
          write_files(@output_dir, "#{klass.ontology_name}_assoc_full", klass.plantuml_class_details(1,full_assoc_options))
        else
          klass=Iof::Data::NO::Switch
          puts "Creating Switch complete overview"
          write_files(@output_dir, "#{klass.ontology_name}_assoc_less_all", klass.plantuml_class_details(1000,less_assoc_options))
#          write_files(@output_dir, "#{klass.ontology_name}_assoc_more_all", klass.plantuml_class_details(1000,more_assoc_options))
#          write_files(@output_dir, "#{klass.ontology_name}_assoc_full_all", klass.plantuml_class_details(1000,full_assoc_options))
          namespaces=Iof::Data::OWL::Thing.subs.values
          namespaces.each do |klasses|
            klasses.values.each do |k|
              puts "Creating #{k.to_s}"
              query_class_details(k,with_namespaces)
            end
          end
        end
      end

    private
      def open_diagram(filename,extension,sub_dir=nil)
        return "@startuml #{File.join(sub_dir,"#{filename}.#{extension}")}\n" unless sub_dir.nil?() || sub_dir==''
        return "@startuml #{File.join(extension,"#{filename}.#{extension}")}\n" if sub_dir.nil?()
        return "@startuml #{filename}.#{extension}\n"
      end

      def close_diagram()
        return "@enduml\n"
      end

      def include_file(base_name,extension)
        return "!include #{base_name}.#{extension}\n"
      end

      def write_files(output_dir,base_name,content)
        FileUtils.mkdir_p(output_dir)
        file_name=File.join(output_dir,"#{base_name}.iuml")
        File.open(file_name,'w') { |f| f.write(content)}
        @formats.each do |format|
          file_name=File.join(output_dir,"#{base_name}_#{format.to_s}.uml")
          File.open(file_name,'w') do |f|
            FileUtils.mkdir_p(File.join(output_dir,format.to_s))
            f.write(open_diagram(base_name,format.to_s))
            f.write(include_file(base_name,'iuml'))
            f.write(close_diagram)
          end
          compile_file(file_name,format.to_s)
        end
      end

      def compile_file(file_name,file_format)
        system("/usr/local/bin/plantuml -t#{file_format} #{file_name}")
      end
    end
  end
end
