# encoding: utf-8
# license: gpl2p 

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST
Encoding.default_internal="UTF-8"
Encoding.default_external="UTF-8"

path=File.expand_path(File.join(File.dirname(__FILE__),'..'))
require File.join(path,"lib","common","base","blackboard.inc.rb")

Ghun::Base::Blackboard.create_sub(:framework)
Ghun::Base::Blackboard.create_sub(:application)
Ghun::Base::Blackboard.create_sub(:local)
Ghun::Base::Blackboard.create_sub(:component)

Ghun::Base::Blackboard.framework.base_path=path

Ghun::Base::Blackboard.known_ruby_engines=[:ruby,:jruby,:unknown]
if RUBY_ENGINE=="ruby" then
  Ghun::Base::Blackboard.ruby_engine=:ruby
elsif RUBY_ENGINE=="jruby" then
  Ghun::Base::Blackboard.ruby_engine=:jruby
else
  Ghun::Base::Blackboard.ruby_engine=:unknown
end

if Ghun::Base::Blackboard.framework.base_path.nil?() || Ghun::Base::Blackboard.framework.base_path.empty?() || Ghun::Base::Blackboard.framework.base_path=='.' then
  $stderr.puts "Unable to detect full application path"
  $stderr.puts "Assuming the current working directory"
  Ghun::Base::Blackboard.framework.base_path="."
end

Ghun::Base::Blackboard.base_path=File.expand_path(File.join(Ghun::Base::Blackboard.framework.base_path,'..'))
Ghun::Base::Blackboard.data_path=File.join(Ghun::Base::Blackboard.base_path,'data')
Ghun::Base::Blackboard.log_path=File.join(Ghun::Base::Blackboard.base_path,'log')

Ghun::Base::Blackboard.framework.lib_path=File.join(Ghun::Base::Blackboard.framework.base_path,'lib')
Ghun::Base::Blackboard.framework.lib_common_path=File.join(Ghun::Base::Blackboard.framework.lib_path,'common')
Ghun::Base::Blackboard.framework.lib_shared_path=File.join(Ghun::Base::Blackboard.framework.lib_path,'shared')
Ghun::Base::Blackboard.framework.bin_path=File.join(Ghun::Base::Blackboard.framework.base_path,'bin')
Ghun::Base::Blackboard.framework.config_path=File.join(Ghun::Base::Blackboard.framework.base_path,'config')
Ghun::Base::Blackboard.framework.data_path=File.join(Ghun::Base::Blackboard.data_path,'ghun')

Ghun::Base::Blackboard.application.base_path=File.join(Ghun::Base::Blackboard.framework.base_path,'app')
Ghun::Base::Blackboard.application.lib_path=File.join(Ghun::Base::Blackboard.application.base_path,'lib')
Ghun::Base::Blackboard.application.lib_common_path=File.join(Ghun::Base::Blackboard.application.lib_path,'common')
Ghun::Base::Blackboard.application.lib_shared_path=File.join(Ghun::Base::Blackboard.application.lib_path,'shared')
Ghun::Base::Blackboard.application.bin_path=File.join(Ghun::Base::Blackboard.application.base_path,'bin')
Ghun::Base::Blackboard.application.config_path=File.join(Ghun::Base::Blackboard.application.base_path,'config')
Ghun::Base::Blackboard.application.data_path=File.join(Ghun::Base::Blackboard.data_path,'app')

Ghun::Base::Blackboard.local.base_path=File.join(Ghun::Base::Blackboard.framework.base_path,'local')
Ghun::Base::Blackboard.local.lib_path=File.join(Ghun::Base::Blackboard.local.base_path,'lib')
Ghun::Base::Blackboard.local.lib_common_path=File.join(Ghun::Base::Blackboard.local.lib_path,'common')
Ghun::Base::Blackboard.local.lib_shared_path=File.join(Ghun::Base::Blackboard.local.lib_path,'shared')
Ghun::Base::Blackboard.local.bin_path=File.join(Ghun::Base::Blackboard.local.base_path,'bin')
Ghun::Base::Blackboard.local.config_path=File.join(Ghun::Base::Blackboard.local.base_path,'config')
Ghun::Base::Blackboard.local.data_path=File.join(Ghun::Base::Blackboard.data_path,'local')

Ghun::Base::Blackboard.log_path=File.join(Ghun::Base::Blackboard.base_path,'log')

Ghun::Base::Blackboard.load_common_modules=[]
Ghun::Base::Blackboard.load_shared_modules=[]
Ghun::Base::Blackboard.load_common_modules_for_component=[]
Ghun::Base::Blackboard.load_shared_modules_for_component=[]
Ghun::Base::Blackboard.load_component_modules=['*']
Ghun::Base::Blackboard.loaded_modules=Array.new()

Ghun::Base::Blackboard.framework.long_name="Ghun application framework"
Ghun::Base::Blackboard.framework.short_name="Ghun"
Ghun::Base::Blackboard.framework.version="0.9"

if ARGV.size() == 0 || ARGV[0].downcase=="base" then
  $stderr.puts "Nothing to do"
  exit
else
  Ghun::Base::Blackboard.component.internal_name=ARGV.shift.downcase
  Ghun::Base::Blackboard.component.create_sub(:application)
  Ghun::Base::Blackboard.component.create_sub(:local)
  Ghun::Base::Blackboard.component.application.lib_path=File.join(Ghun::Base::Blackboard.application.lib_path,Ghun::Base::Blackboard.component.internal_name)
  Ghun::Base::Blackboard.component.local.lib_path=File.join(Ghun::Base::Blackboard.local.lib_path,Ghun::Base::Blackboard.component.internal_name)

  Ghun::Base::Blackboard.component.application.setup_file=File.join(Ghun::Base::Blackboard.component.application.lib_path,"setup.inc.rb")
  Ghun::Base::Blackboard.component.application.run_file=File.join(Ghun::Base::Blackboard.component.application.lib_path,"run.inc.rb")
  Ghun::Base::Blackboard.component.application.shutdown_file=File.join(Ghun::Base::Blackboard.component.application.lib_path,"shutdown.inc.rb")

  Ghun::Base::Blackboard.component.local.setup_file=File.join(Ghun::Base::Blackboard.component.local.lib_path,"setup.inc.rb")
  Ghun::Base::Blackboard.component.local.run_file=File.join(Ghun::Base::Blackboard.component.local.lib_path,"run.inc.rb")
  Ghun::Base::Blackboard.component.local.shutdown_file=File.join(Ghun::Base::Blackboard.component.local.lib_path,"shutdown.inc.rb")

  unless Dir.exists?(Ghun::Base::Blackboard.component.application.lib_path) || Dir.exists?(Ghun::Base::Blackboard.component.local.lib_path)
    raise "Could not find path for component #{Ghun::Base::Blackboard.internal_name}"
    exit
  end
end

require File.join(Ghun::Base::Blackboard.application.base_path,"hook.inc.rb") if File.exist?(File.join(Ghun::Base::Blackboard.application.base_path,"hook.inc.rb"))
require File.join(Ghun::Base::Blackboard.local.base_path,"hook.inc.rb") if File.exist?(File.join(Ghun::Base::Blackboard.local.base_path,"hook.inc.rb"))
require File.join(Ghun::Base::Blackboard.framework.lib_path,"common","setup.inc.rb")

begin
  if Ghun::Base::Blackboard.logger.is_threaded?() then
    log_thread=Ghun::Log::Writer.new()
    log_thread.start()
    if File.exists?(Ghun::Base::Blackboard.component.local.run_file)
      $stderr.puts "Found conflicting run.inc.rb files for component #{Ghun::Base::Blackboard.component.internal_name}; using local run.inc.rb" if File.exists?(Ghun::Base::Blackboard.component.application.run_file)
      require Ghun::Base::Blackboard.component.local.run_file
    elsif File.exists?(Ghun::Base::Blackboard.component.application.run_file)
      require Ghun::Base::Blackboard.component.application.run_file
    else
      $stderr.puts "Found no run file; nothing to do"
    end
    sleep 0.5
    log_thread.polite_exit()
    log_thread.join()
    Ghun::Base::Blackboard.logger.log_all_messages_non_blocking
  else
    if File.exists?(Ghun::Base::Blackboard.component.local.run_file)
      $stderr.puts "Found conflicting run.inc.rb files for component #{Ghun::Base::Blackboard.component.internal_name}; using local run.inc.rb" if File.exists?(Ghun::Base::Blackboard.component.application.run_file)
      require Ghun::Base::Blackboard.component.local.run_file
    elsif File.exists?(Ghun::Base::Blackboard.component.application.run_file)
      require Ghun::Base::Blackboard.component.application.run_file
    else
      $stderr.puts "Found no run file; nothing to do"
    end
  end
rescue => e
  $stderr.puts "#{Ghun::Base::Blackboard.component.internal_name} terminated with an error"
  $stderr.puts "Error: #{e.class}"
  $stderr.puts e.message
  $stderr.puts e.backtrace
rescue Exception => e
  $stderr.puts "#{Ghun::Base::Blackboard.component.internal_name} terminated with an exception"
  $stderr.puts "Exception: #{e.class}"
  $stderr.puts e.message
  $stderr.puts e.backtrace
end
begin
  Ghun::Base::require_if_exists(File.join(Ghun::Base::Blackboard.framework.lib_common_path,'shutdown.inc.rb'))
rescue => e
  $stderr.puts "Shutdown of #{Ghun::Base::Blackboard.component.internal_name} terminated with an error"
  $stderr.puts "Error: #{e.class}"
  $stderr.puts e.message
  $stderr.puts e.backtrace
rescue Exception => e
  $stderr.puts "Shutdown of #{Ghun::Base::Blackboard.component.internal_name} terminated with an exception"
  $stderr.puts "Exception: #{e.class}"
  $stderr.puts e.message
  $stderr.puts e.backtrace
end
