# encoding: utf-8
# license: gpl2p 

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST

module Ghun
  module Base
    class Blackboard
      def initialize()
        @state=Hash.new()
      end
      attr_reader :state

      def print(prefix=nil)
        result=""
        @state.each do |key,value|
          if value.is_a?(Ghun::Config::Handler) || value.is_a?(Ghun::Log::Handler) || value.is_a?(Ghun::Base::Module)
            if prefix.nil?()
              result+="#{key.to_s} => #{value.class} with id #{value.__id__}\n"
            else
              result+="#{prefix.to_s}.#{key.to_s} => #{value.class} with id #{value.__id__}\n"
            end
           elsif value.is_a?(Ghun::Base::Blackboard)
            if prefix.nil?()
              result+="#{key.to_s} => {\n"
              result+=value.print(key.to_s)
              result+="#{key.to_s} => }\n"
            else
              result+="#{prefix.to_s}.#{key.to_s} => {\n"
              result+=value.print("#{prefix.to_s}.#{key.to_s}")
              result+="#{prefix.to_s}.#{key.to_s} => }\n"
            end
          else
            if prefix.nil?()
              result+="#{key.to_s} => #{value.inspect}\n"
            else
              result+="#{prefix.to_s}.#{key.to_s} => #{value.inspect}\n"
            end
          end
        end unless @state.nil?()
        return result
      end

      def create_sub(key)
        sub=@state[check_key(key)]
        if sub.nil?()
          @state[check_key(key)]=Ghun::Base::Blackboard.new()
        elsif !sub.is_a?(Ghun::Base::Blackboard)
          raise "Value #{head.to_s} can not contain sub values"
        end
      end

      def set_key(key,value)
        key_s=key.to_s
        if key_s.match(/\./)
          head=key_s.split('.')[0]
          tail=key_s.split('.')[1..-1].join('.')
          sub=@state[check_key(head)]
          if sub.nil?()
            @state[check_key(head)]=Ghun::Base::Blackboard.new()
            @state[check_key(head)].set_key(tail,value)
          elsif !sub.is_a?(Ghun::Base::Blackboard)
            raise "Value #{head.to_s} can not contain sub values"
          else
            sub.set_key(tail,value)
          end
        else
          @state[check_key(key)]=value
        end
      end
      alias_method :[]=, :set_key

      def get_key(key)
        key_s=key.to_s
        if key_s.match(/\./)
          head=key_s.split('.')[0]
          tail=key_s.split('.')[1..-1].join('.')
          sub=@state[check_key(head)]
          if sub.nil?() || !sub.is_a?(Ghun::Base::Blackboard)
            raise "Value #{head.to_s} has no sub values"
          else
            sub.get_key(tail)
          end
        else
          @state[check_key(key)] unless @state.nil?()
        end
      end
      alias_method :[], :get_key

      def add_key(key)
        set_key(key,nil)
      end

      def del_key(key)
        raise ArgumentError, "Key must be a string or symbol" unless key.is_a?(String) || key.is_a?(Symbol)
        key_s=key.to_s
        if key_s.match(/\./)
          head=key_s.split('.')[0]
          @state.delete(check_key(head)) unless @state.nil?()
        else
          @state.delete(check_key(key)) unless @state.nil?()
        end

      end
      alias_method :delete_key, :del_key

      def method_missing(method,*args)
        if method.match(/.*=$/) then
          set_key(method[0..-2],args[0])
        else
          get_key(method)
        end
      end

      def check_key(key)
        raise ArgumentError, "Key must be a string or symbol" unless key.is_a?(String) || key.is_a?(Symbol)
        raise ArgumentError, "'#{key}' is not a valid key name" unless key.match(/^[_A-Za-z][_a-zA-Z0-9]*$/)
        key.intern
      end

      class << self
        @state=Blackboard.new()

        def method_missing(method,*args)
          @state=Blackboard.new() if !defined?(@state) || @state.nil?()
          @state.send(method,*args)
        end

        attr_reader :state
      end
    end
  end
end
