# encoding: utf-8
# license: gpl2p 

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST
module Ghun
  module Base
    class ClassHierarchy

      def self.print_hierarchy(root)
        ch=self.new(root)
        puts ch.to_s
      end

      def initialize(root)
        @root = root
        @parent = @root.superclass
        @tree = {}
        generate_tree
      end

      def to_s
        @tree.collect { |class_name, subclasses| branch_to_s class_name, subclasses }.join
      end

    private

      def generate_tree
        subclasses.each { |subclass| subclass.insert_into_tree @tree, @parent }
      end

      def subclasses
        @subclasses ||= all_classes.select { |klass| klass < @root }.collect { |klass| ClassHierarchy::Subclass.new klass }
      end

      def all_classes
        @all_classes ||= ObjectSpace.each_object(::Class)
      end

      def branch_to_s(class_name, subclasses, indent=0)
        string = (" " * indent)
        string << class_name
        string << "\n"
        string << subclasses.collect { |subclass_name, subsubclasses| branch_to_s subclass_name, subsubclasses, indent + 2 }.join
      end

      class Subclass < Struct.new(:subclass)

        def superclasses
          @superclasses ||= subclass.ancestors - subclass.included_modules
        end

        def insert_into_tree(tree, root_class)
          classes = superclasses.take_while { |klass| klass != root_class }
          classes.reverse.collect(&:name).compact.inject(tree) { |memo,name| memo[name] ||= {} }
        end

      end
    end
  end
end
