# encoding: utf-8
# license: gpl2p

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST

module Ghun
  module Base
    class SimpleHandler < Ghun::Base::Module
      def initialize(log_source=Ghun::Log::Source::BASE,log_type=Ghun::Log::Type::BASE)
        super(log_source,log_type)
        @members=Hash.new()
      end

      def register_member(name,member)
        if @members.include?(name.intern) && ! @members[name.intern].nil?()
          error "Member '#{name}' already registered for handler #{self} ##{self.__id__}"
        else
          @members[name.intern]=member
        end
      end

      def unregister_member(name)
        if @members.include?(name.intern)
          @members.delete(name)
        else
          error "Member '#{name}' unknown for handler #{self} ##{self.__id__}"
        end
      end

      def [](name)
        @members[name.intern]
      end
    end

    class AutoloadingHandler < Ghun::Base::SimpleHandler
      include Ghun::Base::Logging
      def initialize(log_source=Log::Source::BASE,log_type=Log::Type::BASE)
        init_logging(log_source,log_type)
        register
        @members=Hash.new()
        @member_list=Array.new()
        @initialized=false
      end
      attr_reader :members

      def destroy
        unregister
        @members.values.each do |member|
          member.destroy if member.respond_to?(:destroy)
        end
      end

      def enable_all
        _init_member_list() unless @initialized
        @members.each do |name,member|
          member.enable if member.respond_to?(:enable)
        end
      end

      def reload_config
        debug "Restarting members"
        init_member_list
        if @member_list.nil?() || @member_list.empty?() then
          member_list=Array.new()
          @members.each do |name,member|
            member_list << name
          end unless @members.nil?
        else
          member_list=@member_list
        end

        members_old=@members
        @members=Hash.new()
        members_old.each do |name,member|
          unless member_list.include?(name) then
            member.disable() if member.respond_to?(:disable)
            member.destroy() if member.respond_to?(:destroy)
          else
            member._reload_configuration() if member.respond_to?(:_reload_configuration)
            @members[name]=member unless @members.include?(name)
          end
        end unless @members.nil?
        members_old=nil
        member_list.each do |name|
          self.enable(name) unless @members.include?(name)
        end
        debug "Restarting members done"
      end

      def enable(name)
        _init_member_list() unless @initialized
        member=self[name]
        member.enable if !member.nil?() && member.respond_to?(:enable)
      end

      def disable(name)
        return nil unless @initialized
        member=self[name]
        member.disable if !member.nil?() && member.respond_to?(:disable)
      end

    private

      def _init_member_list()
        init_member_list
        @initialized=true
        @member_list.each do |name|
          member_class=member_class(member_type(name))
          if member_class.nil?
            raise AbstractClassError, "No member class defined"
          else
            register_member(name,member_class.new(name))
          end
        end
      end

      def init_member_list
      raise AbstractClassError, "init_member_list needs to be redefined"
      end

      def member_class(type)
       raise AbstractClassError, "No member class defined"
      end

      #FIXME deprecated?
      def member_type(name)
        name
      end
    end
  end
end
