# encoding: utf-8
# license: gpl2p

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST

module Ghun
  module Base
    def self.recursive_require(suffix="",component="common",mod="*")
      files_raw=Array.new()
      files_raw+=Dir.glob(File.join(Ghun::Base::Blackboard.framework.lib_path,component,mod,"*#{suffix}.inc.rb")).sort if Dir.exists?(File.join(Ghun::Base::Blackboard.framework.lib_path,component,mod)) || mod=='*'
      files_raw+=Dir.glob(File.join(Ghun::Base::Blackboard.application.lib_path,component,mod,"*#{suffix}.inc.rb")).sort if Dir.exists?(File.join(Ghun::Base::Blackboard.application.lib_path,component,mod)) || mod=='*'
      files_raw+=Dir.glob(File.join(Ghun::Base::Blackboard.local.lib_path,component,mod,"*#{suffix}.inc.rb")).sort if Dir.exists?(File.join(Ghun::Base::Blackboard.local.lib_path,component,mod)) || mod=='*'
      files=Array.new
      files_raw.each do |f|
        files << [File.basename(File.dirname(File.dirname(f))),File.basename(File.dirname(f)),File.basename(f).sub(/\..*/,'')]
      end
      files.uniq! { |a| a[2]}

      files.each do |f|
        require_correct_file(f[2], File.join(Ghun::Base::Blackboard.framework.lib_path,f[0],f[1]), File.join(Ghun::Base::Blackboard.application.lib_path,f[0],f[1]), File.join(Ghun::Base::Blackboard.local.lib_path,f[0],f[1]))
      end
    end

    def self.load_modules(component,mod=['*'])
      if mod.is_a?(Array)
        if mod.include?('*')
          Ghun::Base.load_modules(component,'*')
        else
          mod.each do |m|
            Ghun::Base.load_modules(component,m)
          end
        end
      else
        mods_raw=Array.new()
        mods_raw+=Dir.glob(File.join(Ghun::Base::Blackboard.framework.lib_path,component,mod.to_s)).sort if Dir.exists?(File.join(Ghun::Base::Blackboard.framework.lib_path,component))
        mods_raw+=Dir.glob(File.join(Ghun::Base::Blackboard.application.lib_path,component,mod.to_s)).sort if Dir.exists?(File.join(Ghun::Base::Blackboard.application.lib_path,component))
        mods_raw+=Dir.glob(File.join(Ghun::Base::Blackboard.local.lib_path,component,mod.to_s)).sort if Dir.exists?(File.join(Ghun::Base::Blackboard.local.lib_path,component))
        mods=Array.new
        mods_raw.each do |m|
          next unless File.directory?(m)
          mods << File.basename(m)
        end
        mods.uniq!
        mods.compact!
        STDERR.puts "Nothing to load for #{component}/#{mod}" if mods.empty?()
        STDERR.puts "Found modules #{mods} for #{component}/#{mod}" if mods.size()>1
        mods.each do |m|
          auto_load_module(component, m)
        end
      end unless mod.nil?()
    end

    def self.java_require(mod)
      require_correct_file("#{mod}",File.join(Ghun::Base::Blackboard.framework.java_path,mod),File.join(Ghun::Base::Blackboard.application.java_path,mod),File.join(Ghun::Base::Blackboard.local.java_path,mod))
    end

    def self.require_correct_file(file_base_name,framework_path,application_path,local_path)
      framework=File.exists?(File.join(framework_path,"#{file_base_name}.inc.rb"))
      application=File.exists?(File.join(application_path,"#{file_base_name}.inc.rb"))
      application_add=File.exists?(File.join(application_path,"#{file_base_name}.add.inc.rb"))
      local=File.exists?(File.join(local_path,"#{file_base_name}.inc.rb"))
      local_add=File.exists?(File.join(local_path,"#{file_base_name}.add.inc.rb"))
      if local then
        require File.join(local_path,"#{file_base_name}.inc.rb")
        return true
      elsif application
        require File.join(application_path,"#{file_base_name}.inc.rb")
        require File.join(local_path,"#{file_base_name}.add.inc.rb") if local_add
        return true
      elsif framework
        require File.join(framework_path,"#{file_base_name}.inc.rb")
        require File.join(application_path,"#{file_base_name}.add.inc.rb") if application_add
        require File.join(local_path,"#{file_base_name}.add.inc.rb") if local_add
        return true
      end
      return false
    end

    def self.require_if_exists(file)
      if File.exist?(file)
        require file if File.exist?(file)
      else
        STDERR.puts("Required file #{file} does not exist")
      end
    end

    def self.relative_require_if_exists(base,file)
      if Dir.exists?(base)
        require_if_exists(File.join(base,file))
      elsif File.exists?(base)
        require_if_exists(File.join(File.dirname(base),file))
      end
    end

    def self.auto_load_module(component,mod)
      return if Ghun::Base::Blackboard.loaded_modules.include?("#{component}/#{mod}".intern)
      if require_correct_file(mod, File.join(Ghun::Base::Blackboard.framework.lib_path,component,mod), File.join(Ghun::Base::Blackboard.application.lib_path,component,mod), File.join(Ghun::Base::Blackboard.local.lib_path,component,mod))
        # #{mod}.inc.rb file was found, this file loads all needed files
        Ghun::Base::Blackboard.loaded_modules << "#{component}/#{mod}".intern
        return nil
      else
        # no #{mod}.inc.rb file was found loading all files
        files_raw=Array.new()
        files_raw+=Dir.glob(File.join(Ghun::Base::Blackboard.framework.lib_path,component,mod,"*.inc.rb")).sort if Dir.exists?(File.join(Ghun::Base::Blackboard.framework.lib_path,component,mod))
        files_raw+=Dir.glob(File.join(Ghun::Base::Blackboard.application.lib_path,component,mod,"*.inc.rb")).sort if Dir.exists?(File.join(Ghun::Base::Blackboard.application.lib_path,component,mod))
        files_raw+=Dir.glob(File.join(Ghun::Base::Blackboard.local.lib_path,component,mod,"*.inc.rb")).sort if Dir.exists?(File.join(Ghun::Base::Blackboard.local.lib_path,component,mod))
        files=Array.new
        files_raw.each do |f|
          files << File.basename(f).sub(/\..*/,'')
        end
        files.uniq!
        files.compact!
        STDERR.puts "No files to load for #{component}/#{mod}" if files.empty?()
        files.each do |f|
          next if f.match(/_types$/)
          next if f.match(/_errors$/)
          require_correct_file(f, File.join(Ghun::Base::Blackboard.framework.lib_path,component,mod), File.join(Ghun::Base::Blackboard.application.lib_path,component,mod), File.join(Ghun::Base::Blackboard.local.lib_path,component,mod))
        end
        Ghun::Base::Blackboard.loaded_modules << "#{component}/#{mod}".intern
      end
    end
  end
end
