# encoding: utf-8
# license: gpl2p 

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST

module Ghun
  module Base
    class Member
      include Ghun::Base::Logging
      include Ghun::Base::Configuration

      def initialize(parent,name,log_source=Log::Source::BASE,log_type=Log::Type::BASE)
        init_logging(log_source,log_type)
        init_configuration()
        @config_base="#{parent}.#{name}."
        config.declare_dynamic_key("#{@config_base}enabled".intern, :bool,false)
        @enabled_by_config=config["#{@config_base}enabled".intern]
        @enabled=false
        @name=name.to_s
      end

      def destroy
      end

      def enabled?
        @enabled
      end

      def enable
        #if module is disabled by the configuration never enable module
        @enabled=@enabled_by_config
      end

      def disable
        @enabled=false
      end
    end
  end
end
