# encoding: utf-8
# license: gpl2p

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST

module Ghun
  module Base
    module Logging
      def init_logging(log_source=Log::Source::BASE,log_type=Log::Type::BASE)
        @__log_source=log_source
        @__log_type=log_type
      end
      private :init_logging

      def thread_local_logger?()
        return !::Thread.current[:logger].nil?()
      end

      def thread_local_logger()
        return ::Thread.current[:logger]
      end

      def global_logger?()
        return !Ghun::Base::Blackboard.logger.nil?()
      end

      def global_logger()
        return Ghun::Base::Blackboard.logger
      end

      def early_logger()
        Ghun::Base::Blackboard.early_logger
      end

      def debug(log_type=@__log_type,*messages)
        log(Ghun::Log::Level::DEBUG,@__log_source,log_type,messages)
      end
      private :debug

      def info(log_type=@__log_type,*messages)
        log(Ghun::Log::Level::INFO,@__log_source,log_type,messages)
      end
      private :info

      def warn(log_type=@__log_type,*messages)
        log(Ghun::Log::Level::WARN,@__log_source,log_type,messages)
      end
      private :warn

      def error(log_type=@__log_type,*messages)
        log(Ghun::Log::Level::ERROR,@__log_source,log_type,messages)
      end
      private :error

      def fatal(log_type=@__log_type,*messages)
        log(Ghun::Log::Level::FATAL,@__log_source,log_type,messages)
      end
      private :fatal

      def log(log_level, log_source, log_type,messages)
        message=nil
        if log_type.is_a?(Fixnum)
          message=Ghun::Log::Message.new(log_level,log_source,log_type,messages)
        else
          message=Ghun::Log::Message.new(log_level,log_source,@__log_type,[log_type].concat(messages))
        end
        if thread_local_logger?() || global_logger?() then
          log_helper(thread_local_logger(),message) if thread_local_logger?()
          log_helper(global_logger(),message) if global_logger?()
        else
          log_helper(early_logger(),message)
        end
      end

      def log_helper(logger,message)
        case message[:log_level]
        when Ghun::Log::Level::FATAL
          logger.fatal(message)
        when Ghun::Log::Level::ERROR
          logger.error(message)
        when Ghun::Log::Level::WARN
          logger.warn(message)
        when Ghun::Log::Level::INFO
          logger.info(message)
        when Ghun::Log::Level::DEBUG
          logger.debug(message)
        else
          logger.info(message)
        end
      end
      private :log_helper
    end

    module Configuration
      def init_configuration
        return true
      end
      private :init_configuration

      def config
        Ghun::Base::Blackboard.config
      end

      def _reload_configuration
        self.reload_configuration if self.respond_to?(:reload_configuration, true)
      end

      def register
        config.register(self) unless config.nil?()
      end
      private :register

      def unregister
        config.unregister(self) unless config.nil?()
      end
      private :unregister
    end
  end
end
