# encoding: utf-8
# license: gpl2p 

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST

module Ghun
  module Base
    class Selector
      include Ghun::Base::Logging
      include Ghun::Base::Configuration
      def initialize(domain,selection_keys,handle_nil_as_wildcard,log_source=Log::Source::BASE,log_type=Log::Type::BASE)
        init_logging(log_source,log_type)
        init_configuration()
        register
        @domain=domain
        @selection_keys=selection_keys
        @handle_nil_as_wildcard=handle_nil_as_wildcard
        @sorted_members=Hash.new()
        @members=Hash.new()
        @values=Array.new()
      end
      attr_reader :members

      def register_member(member,values)
#        IRB.start_session(binding)
        prepared_values=prepare_values(values)
        return if prepared_values.nil?()
        if @members.include?(member.__id__) then
          unless @members[member.__id__][:values].include?(prepared_values) then
            @members[member.__id__][:values] << prepared_values
            @members[member.__id__][:ref_count]+=1
          end
        else
          @members[member.__id__]={:id => member.__id__, :values => [prepared_values], :member => member, :ref_count => 1}
        end
        @values << prepared_values
        register_helper(member.__id__,prepared_values,:add)
      end

      def unregister_member(member,values=nil)
        return unless @members.include?(member.__id__)
        m=@members[member.__id__]
        all_values=nil
        if values.nil?() then
          all_values=m[:values]
        else
          all_values=[values]
        end
        all_values.each do |v|
          register_helper(m[:id], v, :remove)
          @values.delete(prepare_values(v))
          m[:ref_count]-=1
          m[:values].delete(v)
        end
        @members.delete(m[:id]) if m[:ref_count]<=0 || values.nil?()
      end

      def select_member(values)
        prepared_values=prepare_values(values)
        return if prepared_values.nil?()
        members=register_helper(nil, prepared_values, :get)
        if members.nil?() || members.empty?() then
          return nil unless @handle_nil_as_wildcard
        elsif members.size()==1 then
          return @members[members[0]][:member]
        else
          warn "Ambigous values for selection keys given; using first member"
          return @members[members[0]][:member]
        end
        if @handle_nil_as_wildcard
          debug "#{@domain}: Trying to select by wildcard search for values #{prepared_values}"
          best_match=nil
          best_number_of_matches=0
          best_number_of_wildcards=prepared_values.size()+1
          @values.each do |existing|
            failed=false
            matches=0
            wildcards=0
            debug "#{@domain}: Comparing #{existing} with #{prepared_values}"
            (0..(existing.size()-1)).each do |index|
              failed||=(!existing[index].nil?() && !prepared_values[index].nil?() && existing[index]!=prepared_values[index])
              matches+=1 if (existing[index]==prepared_values[index])
              wildcards+=1 if ((existing[index].nil?() || prepared_values[index].nil?()) && existing[index]!=prepared_values[index])
            end
            next if failed
            debug "#{@domain}: Got no failure"
            if matches > best_number_of_matches
              debug "#{@domain}: Found better (#{matches} matches; #{wildcards} wildcards) match #{existing}"
              best_match=existing
              best_number_of_matches=matches
              best_number_of_wildcards=wildcards
            elsif matches == best_number_of_matches && wildcards < best_number_of_wildcards
              debug "#{@domain}: Found match with less wildcards (#{matches} matches; #{wildcards} wildcards) #{existing}"
              best_match=existing
              best_number_of_matches=matches
              best_number_of_wildcards=wildcards
            elsif matches < best_number_of_matches || best_number_of_wildcards < wildcards
              debug "#{@domain}: #{existing} is not a better match (#{matches} matches; #{wildcards} wildcards)"
            end
          end
          if best_match.nil?()
            error "#{@domain}: Found no match for #{prepared_values}"
            return nil
          else
            debug "#{@domain}: Selecting by best match #{best_match}"
            return select_member(best_match)
          end
        end
      end

      def each_member
        @members.values.each do |member|
          yield member[:member]
        end
      end

    private

      def prepare_values(values)
        prepared_values=nil
        if values.is_a?(Array) then
          prepared_values=values.clone()
        elsif values.is_a?(Hash)
          prepared_values=Array.new()
          @selection_keys.each do |key|
            prepared_values << values[key]
          end
        else
          prepared_values=[values]
        end
        if prepared_values.size() < @selection_keys.size() then
          (@selection_keys.size() - prepared_values.size()).times do
            prepared_values << nil
          end
        elsif prepared_values.size() > @selection_keys.size() then
          prepared_values=prepared_values[0..(@selection_keys.size()-1)]
        end unless prepared_values.nil?()
        return prepared_values
      end

      def register_helper(id,values,action)
        step=@sorted_members
        last_hash=nil
        values.each do |key|
          break if step.nil?()
          last_hash=step
          step[key]=Hash.new() if action==:add && !step.include?(key)
          step=step[key]
        end
        if action==:add then
          if step.nil?() || step.empty?() then
            last_hash[values[-1]]=[id]
          elsif step.is_a?(Array) && !step.include?(id) then
            step << id
          end
        elsif action==:remove then
          step.delete(id) if step.is_a?(Array) && step.include?(id)
        elsif action==:get then
          return step
        end
      end
    end
  end
end
