# encoding: utf-8
# license: gpl2p 

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST
module Ghun
  module Config
    ENGINE_SELECTOR=Ghun::Base::Selector.new("Configuration",[:engine_type],false,Log::Source::CONFIG,Log::Type::BASE)
    class StorageBase
      include Ghun::Base::Logging
      def initialize()
        init_logging(Log::Source::CONFIG)
      end

      def load_config(key)
        config=load_config_helper()
        config.each do |name,value|
          if key.include?(name) then
            TypeChecker.check_and_set_key(key[name],value)
          else
            debug "Key #{name.to_s} with value '#{value.inspect} in source #{self.class} not declared yet"
          end
        end unless config.nil?()
        if config.nil?() then
          return {}
        else
          return config
        end
      end

    private
      def load_config_helper()
        raise AbstractClassError, "load_config needs to be overwriten"
      end
    end
  end
end
