# encoding: utf-8
# license: gpl2p 

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST
module Ghun
  module Config
    class StorageInternal < StorageBase
      Ghun::Config::ENGINE_SELECTOR.register_member(self,:internal)
      def initialize()
        super()
      end

      def load_config_helper()
        config=Hash.new()
        load File.join(Ghun::Base::Blackboard.framework.config_path,"common.conf.rb") if File.exist?(File.join(Ghun::Base::Blackboard.framework.config_path,"common.conf.rb"))
        load File.join(Ghun::Base::Blackboard.application.config_path,"common.conf.rb") if File.exist?(File.join(Ghun::Base::Blackboard.application.config_path,"common.conf.rb"))
        load File.join(Ghun::Base::Blackboard.local.config_path,"common.conf.rb") if File.exist?(File.join(Ghun::Base::Blackboard.local.config_path,"common.conf.rb"))
        load File.join(Ghun::Base::Blackboard.framework.config_path,"shared.conf.rb") if File.exist?(File.join(Ghun::Base::Blackboard.framework.config_path,"shared.conf.rb"))
        load File.join(Ghun::Base::Blackboard.application.config_path,"shared.conf.rb") if File.exist?(File.join(Ghun::Base::Blackboard.application.config_path,"shared.conf.rb"))
        load File.join(Ghun::Base::Blackboard.local.config_path,"shared.conf.rb") if File.exist?(File.join(Ghun::Base::Blackboard.local.config_path,"shared.conf.rb"))
        load File.join(Ghun::Base::Blackboard.framework.config_path,"#{Ghun::Base::Blackboard.component.internal_name}.conf.rb") if File.exist?(File.join(Ghun::Base::Blackboard.framework.config_path,"#{Ghun::Base::Blackboard.component.internal_name}.conf.rb"))
        load File.join(Ghun::Base::Blackboard.application.config_path,"#{Ghun::Base::Blackboard.component.internal_name}.conf.rb") if File.exist?(File.join(Ghun::Base::Blackboard.application.config_path,"#{Ghun::Base::Blackboard.component.internal_name}.conf.rb"))
        load File.join(Ghun::Base::Blackboard.local.config_path,"#{Ghun::Base::Blackboard.component.internal_name}.conf.rb") if File.exist?(File.join(Ghun::Base::Blackboard.local.config_path,"#{Ghun::Base::Blackboard.component.internal_name}.conf.rb"))
        if Object.constants.include?(:Configuration)
          ::Configuration.constants.each { |c|
            conf=Configuration.const_get(c)
            if conf.is_a? Hash then
              conf.each do |key,value|
                config[key]=value
              end
            else
              warn Log::Type::READ, "Unknown internal storage format '#{conf.class}' for '#{c.to_s}'"
            end
          }
          Object.send(:remove_const, :Configuration)
        else
          error "No configuration found"
        end
        return config
      rescue => e
        error "Failed to load configuration with storage engine 'INTERNAL'", e
        return nil
      end
    end
  end
end


