# encoding: utf-8
# license: gpl2p

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST
module Ghun
  module Log
    class Queue
      include Ghun::Base::Configuration
      def initialize(name)
        init_configuration()
        @name=name
        @enabled=config[:"log.queue.#{name}.enabled"]
        @only_developer=config[:"log.queue.#{name}.only_developer"]
        @loglevel=config[:"log.queue.#{name}.loglevel"]
        @log_source=config[:"log.queue.#{name}.logsource"]
        @log_type=config[:"log.queue.#{name}.logtype"]
        @storage=Array.new()
        storage=config[:"log.queue.#{name}.storage"]
        storage.each do |s|
          @storage << s.intern
        end unless storage.nil?
        @developer=config[:"log.developer_mode"]
        @enabled = @enabled && ( @developer || !@only_developer )
        @global_logger=nil
      end
      attr_reader :name

      def retrieve_global_logger(handler)
        @global_logger=handler.create_global_logger(@name,@storage)
      end

      def enabled?
        @enabled
      end

      def disable
        @enabled=false
      end

      def enable
        @enabled=( @developer || !@only_developer )
      end

      def appropriate_queue?(message)
        @enabled && !@global_logger.nil?() && (@loglevel <= message.log_level) && ((message.log_source & @log_source)!=0) && ((message.log_type & @log_type)!=0)
      end

      def log(message)
        case message.log_level
        when Ghun::Log::Level::FATAL
          @global_logger.fatal(message)
        when Ghun::Log::Level::ERROR
          @global_logger.error(message)
        when Ghun::Log::Level::WARN
          @global_logger.warn(message)
        when Ghun::Log::Level::INFO
          @global_logger.info(message)
        when Ghun::Log::Level::DEBUG
          @global_logger.debug(message)
        else
          @global_logger.info(message)
        end
      end
    end
  end
end
