# encoding: utf-8
# license: gpl2p

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST
module Ghun
  module Log

    module Level
      def self.is_log_level?(value)
        Ghun::Config::TypeChecker::is_uint_range?(value,Log::Level::ALL,Log::Level::OFF)
      end

      def self.to_log_level(value)
        Ghun::Config::TypeChecker::to_uint_range(value,Log::Level::ALL,Log::Level::OFF,true)
      end

      Ghun::Config::TypeChecker.register_type(:"log_level",self.method(:"is_log_level?"),self.method(:"to_log_level"))
    end


    module Source
      def self.is_log_source?(value)
        Ghun::Config::TypeChecker::is_uint_range?(value,@@none,@@all)
      end

      def self.to_log_source(value)
        Ghun::Config::TypeChecker::to_uint_range(value,@@none,@@all,false)
      end

      Ghun::Config::TypeChecker.register_type(:"log_source",self.method(:"is_log_source?"),self.method(:"to_log_source"))
    end


    module Type
      def self.is_log_type?(value)
        Ghun::Config::TypeChecker::is_uint_range?(value,@@none,@@all)
      end

      def self.to_log_type(value)
        Ghun::Config::TypeChecker::to_uint_range(value,@@none,@@all,false)
      end

      Ghun::Config::TypeChecker.register_type(:"log_type",self.method(:"is_log_type?"),self.method(:"to_log_type"))
    end
  end
end
