# encoding: utf-8
# license: gpl2p

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST
module Ghun
  module Log
    class CompatibleLogger

      DEBUG = Ghun::Log::Level::DEBUG
      INFO = Ghun::Log::Level::INFO
      WARN = Ghun::Log::Level::WARN
      ERROR = Ghun::Log::Level::ERROR
      FATAL = Ghun::Log::Level::FATAL

      attr_accessor :log_source, :log_type

      def initialize(caller,log_source=Ghun::Log::Source::BASE,log_type=Ghun::Log::Type::BASE,offset=0)
        @caller=caller
        @log_source=log_source
        @log_type=log_type
        @offset=offset
        @send_via_caller=!(@caller.is_a?(Ghun::Log::Handler))
        end

      def debug(message)
        log(Ghun::Log::Level::DEBUG,message)
      end

      def info(message)
        log(Ghun::Log::Level::INFO,message)
      end

      def warn(message)
        log(Ghun::Log::Level::WARN,message)
      end
      alias :warning :warn

      def error(message)
        log(Ghun::Log::Level::ERROR,message)
      end

      def fatal(message)
        log(Ghun::Log::Level::FATAL,message)
      end

      def unknown(message)
        log(Ghun::Log::Level::WARN,message)
      end

      def log(log_level,message)
        if @send_via_caller
          @caller.log(log_level+@offset,@log_source,@log_type,message)
        else
          @caller.log(Ghun::Log::Message.new(log_level+@offset,@log_source,@log_type,message))
          log_helper(::Thread.current[:logger],Ghun::Log::Message.new(log_level+@offset,@log_source,@log_type,message)) unless ::Thread.current[:logger].nil?()
        end
      end

      def log_helper(logger,message)
        case message[:log_level]
        when Ghun::Log::Level::FATAL
          logger.fatal(message)
        when Ghun::Log::Level::ERROR
          logger.error(message)
        when Ghun::Log::Level::WARN
          logger.warn(message)
        when Ghun::Log::Level::INFO
          logger.info(message)
        when Ghun::Log::Level::DEBUG
          logger.debug(message)
        else
          logger.info(message)
        end
      end



      def is_enabled?(unused=0)
        true
      end

      def is_enabled(unused=0)
        true
      end

      def debug?
        true
      end

      def info?
        true
      end

      def warn?
        true
      end
      alias :warning? :warn?

      def error?
        true
      end

      def fatal?
        true
      end

      def add(level,_unused,_facility)
        message=yield
        log(level,message)
      end

      def level=(l)
      end
    end
  end
end
