# encoding: utf-8
# license: gpl2p

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST

require 'monitor'

if Ghun::Base::Blackboard.ruby_engine==:jruby
  Ghun::Base::Blackboard.framework.java_path=File.join(Ghun::Base::Blackboard.framework.base_path,'java')
  Ghun::Base::Blackboard.application.java_path=File.join(Ghun::Base::Blackboard.application.base_path,'java')
  Ghun::Base::Blackboard.local.java_path=File.join(Ghun::Base::Blackboard.local.base_path,'java')

  require File.join(Ghun::Base::Blackboard.framework.java_path,"setup.inc.rb") if File.exists?(File.join(Ghun::Base::Blackboard.framework.java_path,"setup.inc.rb"))
  require File.join(Ghun::Base::Blackboard.application.java_path,"setup.inc.rb") if File.exists?(File.join(Ghun::Base::Blackboard.application.java_path,"setup.inc.rb"))
  require File.join(Ghun::Base::Blackboard.local.java_path,"setup.inc.rb") if File.exists?(File.join(Ghun::Base::Blackboard.local.java_path,"setup.inc.rb"))
end

require File.join(Ghun::Base::Blackboard.framework.lib_common_path,'base','base.inc.rb')


Ghun::Base.load_modules('common', 'config')
Ghun::Base::Blackboard.config=Ghun::Config::Handler.new()

Ghun::Base.load_modules('common', 'log')
Ghun::Base::Blackboard.logger=Ghun::Log::Handler.new()
Ghun::Base::Blackboard.logger.log(Ghun::Log::Message.new(Ghun::Log::Level::INFO, Ghun::Log::Source::BASE, Ghun::Log::Type::BASE, "#{Ghun::Base::Blackboard.framework.short_name} bootstrap done"))

require File.join(Ghun::Base::Blackboard.framework.lib_common_path,'base','base_late.inc.rb')

Ghun::Base.require_if_exists(Ghun::Base::Blackboard.component.application.setup_file)
Ghun::Base.require_if_exists(Ghun::Base::Blackboard.component.local.setup_file)

Ghun::Base.load_modules("common",Ghun::Base::Blackboard.load_common_modules)
Ghun::Base.load_modules("common",Ghun::Base::Blackboard.load_common_modules_for_component)
Ghun::Base::Blackboard.logger.log(Ghun::Log::Message.new(Ghun::Log::Level::INFO, Ghun::Log::Source::BASE, Ghun::Log::Source::BASE, "Loading common modules done"))

Ghun::Base.load_modules("shared",Ghun::Base::Blackboard.load_shared_modules)
Ghun::Base.load_modules("shared",Ghun::Base::Blackboard.load_shared_modules_for_component)
Ghun::Base::Blackboard.logger.log(Ghun::Log::Message.new(Ghun::Log::Level::INFO, Ghun::Log::Source::BASE, Ghun::Log::Source::BASE, "Loading shared modules done"))

Ghun::Base.load_modules(Ghun::Base::Blackboard.component.internal_name,Ghun::Base::Blackboard.load_component_modules)
Ghun::Base::Blackboard.logger.log(Ghun::Log::Message.new(Ghun::Log::Level::INFO, Ghun::Log::Source::BASE, Ghun::Log::Source::BASE, "Loading component modules done"))
Ghun::Base::Blackboard.logger.log(Ghun::Log::Message.new(Ghun::Log::Level::INFO, Ghun::Log::Source::BASE, Ghun::Log::Source::BASE, "Loading modules done"))
