# encoding: utf-8
# license: gpl2p

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST
module Ghun
  module Auth
    class Handler < Ghun::Base::AutoloadingHandler
      Ghun::Base::Blackboard.config.declare_key(:"auth",:array,[])
      Ghun::Base::Blackboard.config.declare_key(:"auth.default",:string,nil,false)
      def initialize()
        super(Log::Source::AUTH,Log::Type::BASE)
        @default=config[:"auth.default"]
        enable_all
      end

      def member_class(type)
        Auth::Item
      end

      def [](name)
        if name.nil?()
          super(@default)
        else
          super(name)
        end
      end

      def init_member_list
        @member_list=Array.new()
        list=config[:"auth"]
        list.each do |m|
          @member_list << m.intern if m.is_a?(String)
          @member_list << m if m.is_a?(Symbol)
        end unless list.nil?
      rescue => e
        error "Error while loading auth member list", e
      end
    end
  end
end
