# encoding: utf-8
# license: gpl2p 

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST
module Ghun
  module Auth
    class Item < Ghun::Base::Member
      Ghun::Auth::ELEMENTS.each do |m|
        next if m.to_s().match(/^(__|object_id)/)
        undef_method(m) if  instance_methods.include?(m)
      end

      def initialize(name=nil)
        super("auth",name,Log::Source::AUTH)
        reload_configuration
      end

      def reload_configuration()
        return if @name.nil?()
        @values=Hash.new()
        Ghun::Auth::ELEMENTS.each do |t|
          Ghun::Base::Blackboard.config.declare_dynamic_key("#{@config_base}#{t.to_s}".intern,:string,nil,false)
          @values[t]=config["#{@config_base}#{t.to_s}".intern]
        end
      end

      def method_missing(name, *args)
        if Ghun::Auth::ELEMENTS.include?(name)
          return @values[name]
        elsif name.to_s.match(/^supports_.*\?$/)
          parts=name.to_s.sub(/^supports_/,'').sub(/\?$/,'').split('_')
          result=true
          raise NameError, "undefined method '#{name.to_s}' for #{self}:#{self.class}" if parts.empty?()
          parts.each do |p|
            raise InvalidAuthItemError, "#{p.to_s} is no known auth element" unless Ghun::Auth::ELEMENTS.include?(p.intern)
            result&&=(@values.include?(p.intern) && !@values[p.intern].nil?())
            result&&=(p=='password' || @values[p.intern]!='')
          end
          return result
        elsif name.to_s.match(/=$/) && Ghun::Auth::ELEMENTS.include?(name.to_s.sub(/=$/,'').intern)
          @values[name.to_s.sub(/=$/,'').intern]=args[0]
        else
          raise NameError, "undefined method '#{name.to_s}' for #{self}:#{self.class}"
        end
      end
    end
  end
end
