# encoding: utf-8
# license: gpl2p 

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST
module Ghun
  module Cron
    Ghun::Log::Source.register_log_source("CRON")

    class Event
      def initialize(name)
        @name=name.intern
        @hours=nil
        @minutes=nil
        @wdays=nil
        @ydays=nil
        @days=nil
        @months=nil
        @years=nil
        @command=nil
        @single_execution=false
      end

      attr_accessor :command, :hours, :minutes, :months, :mdays, :years, :wdays, :ydays, :days
      attr_writer :single_execution
      attr_reader :name

      def single_execution?
        @single_execution
      end

      def self.hour_interval(stepwidth=1,offset=0)
        self.interval((0..23),stepwidth,offset)
      end

      def self.minute_interval(stepwidth=1,offset=0)
        self.interval((0..59),stepwidth,offset)
      end

      def self.month_interval(stepwidth=1,offset=0)
        self.interval((1..12),stepwidth,offset)
      end

      def self.year_interval(stepwidth=1,offset=0)
        #FIXME works only till year 2100
        self.interval((2012..2100),stepwidth,offset)
      end

      def self.yday_interval(stepwidth=1,offset=0)
        self.interval((1..366),stepwidth,offset)
      end

      def self.day_interval(stepwidth=1,offset=0)
        self.interval((1..31),stepwidth,offset)
      end

      def self.wday_interval(stepwidth=1,offset=0)
        self.interval((0..6),stepwidth,offset)
      end

      def self.interval(range,stepwidth,offset)
        if stepwidth==1 then
          steps=range.to_a
        else
          steps=Array.new()
          range.each do |h| steps << h if ((h-(offset%stepwidth))%stepwidth)==0 end
        end
        return steps
      end
    end
  end
end
