# encoding: utf-8
# license: gpl2p

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST
module Ghun
  module Cron
    class Runner < Ghun::Base::Thread
      def initialize(command_queue)
        super("Cron", Ghun::Log::Source::CRON)
        @events=Hash.new()
        @events_mutex=Mutex.new()
        @command_queue=command_queue
      end

      def run
        #TODO implement calculation of sleep time instead of fixed 60 seconds - X
        begin
          until @shutdown do
            begin
              undone=Array.new()
              before=Time.now()
              now=before
              @events_mutex.synchronize {
                @events.each do |name,e|
                  match=true
                  match&&=(e.years.nil?() || e.years.include?(now.year))
                  match&&=(e.months.nil?() || e.months.include?(now.month))
                  match&&=(e.days.nil?() || e.days.include?(now.day))
                  match&&=(e.hours.nil?() || e.hours.include?(now.hour))
                  match&&=(e.minutes.nil?() || e.minutes.include?(now.min))
                  match&&=(e.ydays.nil?() || e.ydays.include?(now.yday))
                  match&&=(e.wdays.nil?() || e.wdays.include?(now.wday))
                  if match then
                    debug "Event '#{name.to_s}' will be run"
                    undone << e
                  else
                    debug "Event '#{name.to_s}' will not be run"
                  end
                end
              }
              unless undone.empty?() then
                debug "Executing #{undone.size()} commands"
                undone.each do |e|
                  if e.command.nil?() then
                    warn "Event #{e.name} has no command set"
                  elsif e.command.is_a?(String) then
                    info e.command
                  elsif e.command.is_a?(Ghun::Log::Message)
                    log((e.command.log_level || @log_level), (e.command.log_source || @log_source), (e.command.log_type || @log_type), (e.command.message || "empty message"))
                  else
                    debug "Enqueuing command for event #{e.name}"
                    @command_queue << e.command
                  end
                  unregister_event(e.name) if e.single_execution?()
                end
              else
                debug "No commands to execute"
              end
              after=Time.now()
              needed=after-before
              debug "Cron needed #{needed} seconds to run #{todo.size} jobs", "Sleeping #{60-needed} seconds"
              break if @shutdown
              sleep (60-needed) if needed < 60
            rescue => e
              error "Error while running cron", e
            end
          end
        rescue => e
          error "Error while running cron", e
        end
      end

      def polite_exit
        @shutdown=true
        @thread.wakeup()
      end

      def register_event(event)
        @events_mutex.synchronize {
          if @events.include?(event.name) then
            warn "Event #{event.name.to_s} already registered"
          else
            debug "Registered event #{event.name.to_s}"
            @events[event.name]=event
          end
        }
      end

      def unregister_event(event)
        @events_mutex.synchronize {
          name=event
          name=event.name if event.is_a?(Ghun::Cron::Event)
          if @events.include?(name) then
            debug "Unregistered event #{name.to_s}"
            @events.delete(name)
          else
            warn "Event #{name.to_s} is not known"
          end
        }
      end
    end
  end
end
