# encoding: utf-8
# license: gpl2p

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST
module Ghun
  module Database
    class Base < Ghun::Base::StatefullConnection
      def initialize(name,mode=:sync,type=:database)
        super(mode,type,true,Ghun::Log::Source::DATABASE)
        config.declare_dynamic_key(:"db.#{name.to_s}.readonly",:bool,false)
        #TODO implement readonly for all engine and all interpreter
        #jruby hsqldb: done
        @readonly=config[:"db.#{name.to_s}.readonly"]
        @name=name
        @db=nil
        self.accept_nil_as_result=true
      end

      attr_reader :db
    end
  end
end
