# encoding: utf-8
# license: gpl2p

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST
module Ghun
  module Database
    class Handler < Ghun::Base::ConnectionHandler
      ENGINE_SELECTOR=Ghun::Base::Selector.new("DatabaseEngine",[:engine],false,Ghun::Log::Source::DATABASE,Ghun::Log::Type::BASE)
      def initialize()
        super(Ghun::Log::Source::DATABASE)
      end

      def init_database(name,mode=:sync)
        unless self["#{name.to_s}_#{mode.to_s}".intern].nil?()
          return self["#{name.to_s}_#{mode.to_s}".intern]
        end
        config.declare_dynamic_key("db.#{name.to_s}.engine".intern,:string)
        engine=config["db.#{name.to_s}.engine".intern]
        db_class=ENGINE_SELECTOR.select_member(engine.intern)
        raise UnknownEngineError, "Unknown database engine #{engine}" if db_class.nil?()
        db=db_class.new(name.intern,mode)
        self.register_member("#{name.to_s}_#{mode.to_s}".intern, db)
        return db
      rescue => e
        error "Failed to get engine for database with name '#{name.to_s}'", e
        raise
      end

      def get_database(name,mode=:sync)
        self["#{name.to_s}_#{mode.to_s}".intern]
      end

      def self.register_instance()
        Ghun::Base::Blackboard.database=Ghun::Database::Handler.new() if Ghun::Base::Blackboard.database.nil?()
      end
    end
  end
end
Ghun::Database::Handler.register_instance()
