# encoding: utf-8
# license: gpl2p

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST
module Ghun
  module Database
    class BaseHsqlDb < Base
      def initialize(name,mode=:sync)
        super(name,mode,:mysql)
        name_s=name.to_s
        config.declare_dynamic_key(:"db.#{name_s}.protocol",:string)
        config.declare_dynamic_key(:"db.#{name_s}.server",:string,nil,false)
        config.declare_dynamic_key(:"db.#{name_s}.port",:uint,nil,false)
        config.declare_dynamic_key(:"db.#{name_s}.file",:string,nil,false)
#        config.declare_dynamic_key(:"db.#{name_s}.database",:string)
        config.declare_dynamic_key(:"db.#{name_s}.auth",:string,nil,false)

        @protocol=config[:"db.#{name_s}.protocol"]
        @protocol=nil if @protocol==''
        @protocol=@protocol.downcase.intern unless @protocol.nil?()
        @server=config[:"db.#{name_s}.server"]
        @server=nil if @server==''
        @port=config[:"db.#{name_s}.port"]
        @port=nil if @port==0 || @server.nil?()
        @file=config[:"db.#{name_s}.file"]
        @file=nil if @file==''
#        @database=config[:"db.#{name_s}.database"]
        @auth_name=config[:"db.#{name_s}.auth"]
        if @auth_name.nil?()
          @auth=nil
          @user=nil
          @password=nil
        else
          @auth=Ghun::Auth::Item.new(@auth_name)
          if @auth.supports_username?()
            @user=@auth.username
            @password=nil
            @password=@auth.password if @auth.supports_password?()
            @password=nil if @password==''
          else
            raise HsqlDbConnectionError, "Given auth item #{@auth_name} provides no username"
          end
        end
 #       raise MsqlDbConnectionError, "No database given for hsqldb connection #{name_s}" if @database.nil?() || @database==''
        if @protocol==:file && @file.nil?()
          raise HsqlDbConnectionError, "File connection requested but not file given"
        elsif (@protocol==:http || @protocol==:https || @protocol==:hsql || @protocol==:hsqls) && @server.nil?()
          raise HsqlDbConnectionError, "#{@protocol} connection requested but no server address given"
        elsif !(@protocol==:http || @protocol==:https || @protocol==:hsql || @protocol==:hsqls || @protocol==:file)
          raise HsqlDbConnectionError, "Unknown protocol #{@protocol}"
        end
      end

      def query(query,qualified_keys=false)
        if query.is_a?(Array)
          queries=Array.new()
          query.each do |q|
            queries << {:query => q, :qualified_keys => qualified_keys}
          end
          return execute_request(queries)
        elsif query.match(';')
          queries=Array.new()
          query.split(';').each do |q|
            next if q.nil?() || q.strip().empty?()
            queries << {:query => q, :qualified_keys => qualified_keys}
          end
          return execute_request(queries)
        else
          return execute_request({:query => query, :qualified_keys => qualified_keys})
        end
      end

      def enqueue_query(id,query,qualified_keys=false)
        enqueue_request(id,{:query => query, :qualified_keys => qualified_keys})
      end
    end
  end
end

if Ghun::Base::Blackboard.ruby_engine==:jruby
  Ghun::Base.relative_require_if_exists(__FILE__, "hsqldb.inc.java.rb")
else
  Ghun::Base.relative_require_if_exists(__FILE__, "hsqldb.inc.ruby.rb")
end
