# encoding: utf-8
# license: gpl2p

### BEGIN LICENSE NOTICE
# This file is part of %LONG% (%SHORT%)
# Copyright (C) 2010 - %YEAR%
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
### END LICENSE NOTICE

### BEGIN AUTHOR LIST
#
### END AUTHOR LIST
begin
  require 'jdbc/mysql'
  Jdbc::MySQL.load_driver()

  module Ghun
    module Database
      class Mysql < BaseMysql
        Ghun::Database::Handler::ENGINE_SELECTOR.register_member(self,:mysql)
        def initialize(name,mode=:sync)
          super(name,mode)
          error MysqlConnectionError, "Mysql connection via JDBC does not support socket connections, trying default for database #{name.to_s}" if @server.nil?()
          @db_url="jdbc:mysql://"
          @db_url+="#{@server}" unless @server.nil?()
          @db_url+=":#{@port}" unless @server.nil?() || @port.nil?()
          @db_url+="/#{@database}"
          @db_url+="?multiStatements=true"
          @password="" if @password.nil?()
        end

        def self.escape_string(string)
          #See section "String Literals" in the mysql documentation for details
          raise TypeError, "Wrong argument type #{string.class} (expected String)" unless string.is_a?(String)
          result=""
          string.each_char.each do |c|
            case c
            when "\0"
              result += "\\0"
            when "\n"
              result += "\\n"
            when "\r"
              result += "\\r"
            when "\\"
              result += "\\\\"
            when "'"
              result += "\\'"
            when '"'
              result += '\\"'
            when "\32"
              result += "\\Z"
            else
              result += c
            end
          end
          return result
        end

        def connected?()
          !(@db.nil?() || @db.closed?())
        rescue
          return false
        end

      private

        def ping()
          return !@statement.execute_query("DO 1")
        rescue => e
          debug "Failed to ping database #{@name.to_s}", e
          return false
        end

        def execute_helper(args)
          debug args[:query]
          raw=nil
          affected_rows=nil
          result=nil
          if args[:query].downcase.match(/^show/) || args[:query].downcase.match(/^select/)
            raw=@statement.execute_query(args[:query])
            affected_rows=0
            meta=raw.meta_data()
            result=Hash.new()
            column_names=Array.new()
            column_count=meta.column_count
            column_count.times do |i|
              if args[:qualified_keys]
                column_names[i]="#{meta.table_name(i+1)}.#{meta.column_label(i+1)}".intern
              else
                column_names[i]=meta.column_label(i+1).intern
              end
            end
            row_count=1
            while (raw.next)
              row=Hash.new()
              column_count.times do |i|
                row[column_names[i]]=raw.string(i+1)
              end
              result[row_count.to_s.intern]=row
              row_count+=1
            end
            raw.close() unless raw.nil?()
          else
            affected_rows=@statement.execute_update(args[:query])
            result=nil
          end
          debug "#{affected_rows} affected rows"
          debug "Got result: #{result.to_s}" unless result.nil?
          debug "empty result" if result.nil?
          return result
        end

        def connect_helper()
          if @db.nil?()
            @db=java.sql.DriverManager.get_connection(@db_url,@user,@password)
            @statement=@db.create_statement()
            @statement.escape_processing=false
            return true
          else
            @db.close()
            @db=java.sql.DriverManager.get_connection(@db_url,@user,@password)
            @statement=@db.create_statement()
            return true
          end
        rescue => e
          error "Failed to create database connection with name #{@name}", e
          raise MysqlConnectionError, "Failed to create database connection with name #{@name}"
          return false
        end

        def disconnect_helper()
          @max_query_length=nil
          @statement.close() unless @statement.nil?()
          @db.close()  unless @db.nil?()
          @statement.nil?()
          @db.nil?()
          return true
        rescue => e
          error "Failed to close database connection with name #{@name}", e
          raise MysqlConnectionError, "Failed to close database connection with name #{@name}"
          return false
        end
      end
    end
  end
rescue LoadError => e
  Ghun::Base::Blackboard.logger.warn(Ghun::Log::Message.new(Ghun::Log::Level::WARN,Ghun::Log::Source::DATABASE, Ghun::Log::Type::BASE, "Failed to load needed file, no support for MySQL databases: #{e.message}"))
end
